/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartRepairDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryLineChartRepairQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QuerySeerLineChartDTO;
import com.ifourthwall.dbm.asset.dto.seer.QuerySeerLineChartQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageQuDTO;
import com.ifourthwall.dbm.sentry.service.SentryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Sentry\u7edf\u8ba1\u76f8\u5173\u63a5\u53e3"}, value="SentryController")
@RequestMapping(value={"/dbm/sentry/statistics"})
public class SentryController {
    private static final Logger log = LoggerFactory.getLogger(SentryController.class);
    @Resource(name="SentryServiceImpl")
    private SentryService sentryService;

    @ApiOperation(value="\u6298\u7ebf\u56fe\u7edf\u8ba1-\u8bbe\u5907\u5f02\u5e38\u6570", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/line/chart"})
    public ResponseEntity<BaseResponse<List<QueryLineChartDTO>>> queryLineChart(@Valid @RequestBody QueryLineChartQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/line/chart \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.sentryService.queryLineChart(query, user);
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/line/chart \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6298\u7ebf\u56fe\u7edf\u8ba1-\u8bbe\u5907\u8fd4\u4fee\u7387", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/line/chart/repair"})
    public ResponseEntity<BaseResponse<List<QueryLineChartRepairDTO>>> queryLineChartRepair(@Valid @RequestBody QueryLineChartRepairQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/line/chart/repair \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.sentryService.queryLineChartRepair(query, user);
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/line/chart/repair \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u544a\u8b66\u6b21\u6570\u6392\u884c", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/asset/number/rank"})
    public ResponseEntity<BaseResponse<AlertNumberRankingByDateDTO>> alertNumberRankingByDate(@RequestBody @Valid AlertNumberRankingByDateQuDTO rankingQuDTO, IFWUser user) {
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/asset/number/rank \u63a5\u53d7\u53c2\u6570:{}", (Object)rankingQuDTO);
        BaseResponse response = this.sentryService.alertNumberRankingByDate(rankingQuDTO, user);
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/asset/number/rank \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u76d1\u6d4b\u8bbe\u5907\u5360\u6bd4", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/asset/percentage"})
    public ResponseEntity<BaseResponse<MonitorPercentageDTO>> monitorPercentage(@RequestBody @Valid MonitorPercentageQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/asset/percentage \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.sentryService.monitorPercentage(query, user);
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/asset/percentage \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="seer\u8bbe\u5907\u7edf\u8ba1\u6298\u7ebf\u56fe", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/seer/line/chart"})
    public ResponseEntity<BaseResponse<QuerySeerLineChartDTO>> querySeerLineChart(@RequestBody @Valid QuerySeerLineChartQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/seer/line/chart \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.sentryService.querySeerLineChart(query, user);
        log.info("\u63a5\u53e3 /dbm/sentry/statistics/query/seer/line/chart \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

