/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListQuDTO;
import com.ifourthwall.dbm.sentry.service.SentryAppService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Sentry-App\u63a5\u53e3\u76f8\u5173\u63a5\u53e3"}, value="SentryAppController")
@RequestMapping(value={"/dbm/sentry/app"})
public class SentryAppController {
    private static final Logger log = LoggerFactory.getLogger(SentryAppController.class);
    @Resource(name="SentryAppServiceImpl")
    private SentryAppService assetAppService;

    @ApiOperation(value="\u901a\u8fc7\u8d44\u4ea7\u67e5\u8be2\u8d44\u4ea7\u53ca\u6284\u8868\u4fe1\u606f", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/asset/list"})
    public ResponseEntity<BaseResponse<List<QueryAssetAppListDTO>>> queryAssetAppList(@Valid @RequestBody QueryAssetAppListQuDTO assetList, IFWUser user) {
        log.info("\u63a5\u53e3 queryAssetAppList \u63a5\u53d7\u53c2\u6570:{}", (Object)assetList);
        BaseResponse response = this.assetAppService.queryAssetAppList(assetList, user);
        log.info("\u63a5\u53e3 queryAssetAppList \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

