/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingInfoDTO;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingQuDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorReadingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6284\u8868\u76f8\u5173\u63a5\u53e3"}, value="MonitorController")
@RequestMapping(value={"/dbm/sentry"})
public class MonitorReadingController {
    private static final Logger log = LoggerFactory.getLogger(MonitorReadingController.class);
    @Resource(name="MonitorReadingServiceImpl")
    private MonitorReadingService monitorReadingService;

    @ApiOperation(value="tracker\u79bb\u7ebf\u5305\u6570\u636e-\u6284\u8868", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/tracker/offline"})
    public ResponseEntity<BaseResponse<List<TrackerMeterReadingInfoDTO>>> trackerOfflineMeterReading(@Valid @RequestBody TrackerMeterReadingQuDTO trackerOffline, IFWUser user) {
        log.info("\u63a5\u53e3 trackerOfflineMeterReading \u63a5\u53d7\u53c2\u6570:{}", (Object)trackerOffline);
        BaseResponse response = this.monitorReadingService.trackerOfflineMeterReading(trackerOffline, user);
        log.info("\u63a5\u53e3 trackerOfflineMeterReading \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u4ea7\u67e5\u8be2\u7ed1\u5b9a\u6307\u6807", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/metric/by/asset"})
    public ResponseEntity<BaseResponse<List<QueryMetricByAssetDTO>>> queryMetricByAsset(@Valid @RequestBody QueryMetricByAssetQuDTO queryMetricByAsset, IFWUser user) {
        log.info("\u63a5\u53e3 queryMetricByAsset \u63a5\u53d7\u53c2\u6570:{}", (Object)queryMetricByAsset);
        BaseResponse response = this.monitorReadingService.queryMetricByAsset(queryMetricByAsset, user);
        log.info("\u63a5\u53e3 queryMetricByAsset \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

