/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.dashboard.DashboardQueryDataDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.DashboardQueryDataQuDTO;
import com.ifourthwall.dbm.sentry.service.DashboardDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Sentry\u4eea\u8868\u76d8\u6570\u636e\u67e5\u8be2\u63a5\u53e3"}, value="DashboardController")
@RequestMapping(value={"/dbm/sentry/dashboard/data"})
public class DashboardDataController {
    private static final Logger log = LoggerFactory.getLogger(DashboardDataController.class);
    @Resource(name="DashboardDataServiceImpl")
    private DashboardDataService dashboardDataService;

    @ApiOperation(value="Sentry\u4eea\u8868\u76d8\u6570\u636e\u67e5\u8be2", notes="\u6768\u9e4f")
    @PostMapping(value={"/query"})
    public ResponseEntity<BaseResponse<DashboardQueryDataDTO>> queryData(@Valid @RequestBody DashboardQueryDataQuDTO inseret, IFWUser user) {
        log.info("\u63a5\u53e3 queryData \u63a5\u53d7\u53c2\u6570:{}", (Object)inseret);
        BaseResponse response = this.dashboardDataService.queryData(inseret, user);
        log.info("\u63a5\u53e3 queryData \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

