/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.dashboard.DashboardPanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.DeleteDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.DeletePanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardAndPanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardPanelDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardPanelQuDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardQuDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.UpdateDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.UpdatePanelDTO;
import com.ifourthwall.dbm.sentry.service.DashboardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4eea\u8868\u76d8\u76f8\u5173\u63a5\u53e3"}, value="DashboardController")
@RequestMapping(value={"/dbm/sentry/dashboard"})
public class DashboardController {
    private static final Logger log = LoggerFactory.getLogger(DashboardController.class);
    @Resource(name="DashboardServiceImpl")
    private DashboardService dashboardService;

    @ApiOperation(value="\u65b0\u589e\u4eea\u8868\u76d8", notes="\u6768\u9e4f")
    @PostMapping(value={"/insert"})
    public ResponseEntity<BaseResponse> insertDashboard(@Valid @RequestBody InsertDashboardDTO inseret, IFWUser user) {
        log.info("\u63a5\u53e3 insertDashboard \u63a5\u53d7\u53c2\u6570:{}", (Object)inseret);
        BaseResponse response = this.dashboardService.insertDashboard(inseret, user);
        log.info("\u63a5\u53e3 insertDashboard \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u4fee\u6539\u4eea\u8868\u76d8", notes="\u6768\u9e4f")
    @PostMapping(value={"/update"})
    public ResponseEntity<BaseResponse> updateDashboard(@Valid @RequestBody UpdateDashboardDTO update, IFWUser user) {
        log.info("\u63a5\u53e3 updateDashboard \u63a5\u53d7\u53c2\u6570:{}", (Object)update);
        BaseResponse response = this.dashboardService.updateDashboard(update, user);
        log.info("\u63a5\u53e3 updateDashboard \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5220\u9664\u4eea\u8868\u76d8", notes="\u6768\u9e4f")
    @PostMapping(value={"/delete"})
    public ResponseEntity<BaseResponse> deleteDashboard(@Valid @RequestBody DeleteDashboardDTO delete, IFWUser user) {
        log.info("\u63a5\u53e3 deleteDashboard \u63a5\u53d7\u53c2\u6570:{}", (Object)delete);
        BaseResponse response = this.dashboardService.deleteDashboard(delete, user);
        log.info("\u63a5\u53e3 deleteDashboard \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u67e5\u8be2\u4eea\u8868\u76d8\uff08\u4e0d\u5305\u62ecpanel\uff09", notes="\u6768\u9e4f")
    @PostMapping(value={"/query"})
    public ResponseEntity<BaseResponse<IFWPageInfo<DashboardPanelDTO>>> queryDashboardPanel(@Valid @RequestBody QueryDashboardPanelQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryDashboardPanel \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.dashboardService.queryDashboardPanel(query, user);
        log.info("\u63a5\u53e3 queryDashboardPanel \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757", notes="\u6768\u9e4f")
    @PostMapping(value={"/query/info"})
    public ResponseEntity<BaseResponse<QueryDashboardDTO>> queryDashboard(@Valid @RequestBody QueryDashboardQuDTO query, IFWUser user) {
        log.info("\u63a5\u53e3 queryDashboard \u63a5\u53d7\u53c2\u6570:{}", (Object)query);
        BaseResponse response = this.dashboardService.queryDashboard(query, user);
        log.info("\u63a5\u53e3 queryDashboard \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u65b0\u589e\u6a21\u5757", notes="\u6768\u9e4f")
    @PostMapping(value={"/panel/insert"})
    public ResponseEntity<BaseResponse> insertPanel(@Valid @RequestBody InsertDashboardPanelDTO inseret, IFWUser user) {
        log.info("\u63a5\u53e3 insertPanel \u63a5\u53d7\u53c2\u6570:{}", (Object)inseret);
        BaseResponse response = this.dashboardService.insertPanel(inseret, user);
        log.info("\u63a5\u53e3 insertPanel \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u4fee\u6539\u6a21\u5757", notes="\u6768\u9e4f")
    @PostMapping(value={"/panel/update"})
    public ResponseEntity<BaseResponse> updatePanel(@Valid @RequestBody UpdatePanelDTO update, IFWUser user) {
        log.info("\u63a5\u53e3 updatePanel \u63a5\u53d7\u53c2\u6570:{}", (Object)update);
        BaseResponse response = this.dashboardService.updatePanel(update, user);
        log.info("\u63a5\u53e3 updatePanel \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5220\u9664\u6a21\u5757", notes="\u6768\u9e4f")
    @PostMapping(value={"/panel/delete"})
    public ResponseEntity<BaseResponse> deletePanel(@Valid @RequestBody DeletePanelDTO delete, IFWUser user) {
        log.info("\u63a5\u53e3 deletePanel \u63a5\u53d7\u53c2\u6570:{}", (Object)delete);
        BaseResponse response = this.dashboardService.deletePanel(delete, user);
        log.info("\u63a5\u53e3 deletePanel \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u65b0\u589e\u4eea\u8868\u76d8-\u975e\u81ea\u5b9a\u4e49", notes="\u6768\u9e4f")
    @PostMapping(value={"/non/custom/insert"})
    public ResponseEntity<BaseResponse> noCustomInsert(@Valid @RequestBody InsertDashboardAndPanelDTO inseret, IFWUser user) {
        log.info("\u63a5\u53e3 noCustomInsert \u63a5\u53d7\u53c2\u6570:{}", (Object)inseret);
        BaseResponse response = this.dashboardService.noCustomInsert(inseret, user);
        log.info("\u63a5\u53e3 noCustomInsert \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

