package com.ifourthwall.dbm.sentry.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/**
 * @Author: YangPeng
 * @Date: 2020/11/5 17:45
 * @Description:
 */
public class TimeUtils {

    public static final String JP_TIME_ZONE = "Asia/Tokyo";
    public static final String CN_TIME_ZONE = "Asia/Shanghai";
    public static final String EN_TIME_ZONE = "Europe/London";

    public static String TimeChange(Date date,String zoneId){
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("JP".equals(zoneId)) {
            timeFormat.setTimeZone(TimeZone.getTimeZone(JP_TIME_ZONE));
        }
        if ("EN".equals(zoneId)) {
            timeFormat.setTimeZone(TimeZone.getTimeZone(EN_TIME_ZONE));
        }
        if (zoneId == null || "CN".equals(zoneId)) {
            timeFormat.setTimeZone(TimeZone.getTimeZone(CN_TIME_ZONE));
        }
        String result = timeFormat.format(date);
        return result;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime()
                || nowTime.getTime() == endTime.getTime()) {
            return true;
        }

        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);

        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);

        Calendar end = Calendar.getInstance();
        end.setTime(endTime);

        if (date.after(begin) && date.before(end)) {
            return true;
        } else {
            return false;
        }
    }
}
