package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.kafka.TopicConstants;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.sentry.bo.QueryAlertIdDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskCreateKafkaBO;
import com.ifourthwall.dbm.sentry.bo.UpMonitorRecordDoBO;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.kafka.DataHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author: hao.dai
 * @Date: 2019/12/26 11:50
 * @Description: 更新tansk状态
 */
@Service("UpdateTaskIdHandler")
@Slf4j
public class UpdateTaskIdHandler implements DataHandler {

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public void handle(String jsonStrData) {
        log.info("接收到dbm_task_alert_auto_create的数据" + jsonStrData);
        TaskCreateKafkaBO taskId = JSONUtils.jacksonFromJson(jsonStrData, TaskCreateKafkaBO.class);
        if (taskId != null && !StringUtils.isEmpty(taskId.getAlertId())) {
            QueryAlertIdDoBO queryAlertIdDoBO = new QueryAlertIdDoBO();
            queryAlertIdDoBO.setAlertId(taskId.getAlertId());
            queryAlertIdDoBO.setLanguageCode("CN");
            Boolean aBoolean = monitorRepository.queryAlertId(queryAlertIdDoBO);
            if (aBoolean) {
                UpMonitorRecordDoBO upMonitorRecordDoBO = new UpMonitorRecordDoBO();
                upMonitorRecordDoBO.setAlertId(taskId.getAlertId());
                upMonitorRecordDoBO.setTaskStatusId("1");
                upMonitorRecordDoBO.setTaskWorkSheetId(taskId.getTaskId());
                monitorRepository.upMonitorRecord(upMonitorRecordDoBO);
                if (redisTemplate.hasKey(RedisKeyPrefixUtil.getTaskAutoCreateTaskPrefix(taskId.getAlertId()))) {
                    redisTemplate.delete(RedisKeyPrefixUtil.getTaskAutoCreateTaskPrefix(taskId.getAlertId()));
                }
            }
        }
    }

    @Override
    public boolean judge(String topic) {
        return StringUtils.equals(TopicConstants.dbmTaskAutoCreate, topic);
    }
}
