package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.kafka.TopicConstants;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO;
import com.ifourthwall.dbm.sentry.bo.QuerySpaceInfoQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.SeerAlarmNumBO;
import com.ifourthwall.dbm.sentry.bo.UpdateAlarmNumberBO;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.kafka.DataHandler;
import com.ifourthwall.kafka.IFWKafkaClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/12/26 11:50
 * @Description: 更新tansk状态
 */
@Service("UpdateTaskAlarmNumberNewHandler")
@Slf4j
public class UpdateTaskAlarmNumberNewHandler implements DataHandler {

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Resource(name = "SpaceRepository")
    private SpaceRepository spaceRepository;

    @Autowired
    private RedisTemplate redisTemplate;

    //当有自动告警发生时，把该空间的告警数+1 或-1
    @Resource(name = "IFWKafkaClient-" + TopicConstants.DBM_SENTRY_UPDATE_SPACE_SPECIAL_ALARM_NUM)
    private IFWKafkaClient ifwKafkaClientUpdateAlarmNumber;

    @Override
    public void handle(String jsonStrData) {
        log.info("接收到DBM_SENTRY_UPDATE_SPACE_SPECIAL_ALARM_NUM的数据" + jsonStrData);
        UpdateAlarmNumberBO alarmNumberBO = JSONUtils.jacksonFromJson(jsonStrData, UpdateAlarmNumberBO.class);
        SeerAlarmNumBO number = (SeerAlarmNumBO) redisTemplate.opsForValue().get(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(alarmNumberBO.getSpaceId()));
        if (StringUtils.isEmpty(alarmNumberBO.getOtherType())) {
            SeerAlarmNumBO result = new SeerAlarmNumBO();
            log.info("接收到seer空间数量标签参数，需要：" + alarmNumberBO.getType() + "操作，其中此次操作的数值为：" + number + ",空间id为：" + alarmNumberBO.getSpaceId());
            //判断是否进行下一次消费的标志位（1.不消费）
            int a = 0;
            if (alarmNumberBO.getType() == 1) {
                if (number != null) {
                    //当查redis中，该空间存在资产的时候
                    if (DataUtils.isListAvali(number.getAssetIds())) {
                        log.info("数据不为空，且存在资产id：" + number.getAssetIds());
                        //如果list中不存在这个资产（监控对象），且出现报警，就+1个告警数量
                        if (!number.getAssetIds().contains(alarmNumberBO.getAssetId())) {
                            ArrayList<String> ids = new ArrayList<>();
                            ids.add(alarmNumberBO.getAssetId());
                            ids.addAll(number.getAssetIds());
                            //加1
                            Integer alarmNumber = 0;
                            if (number.getNumber() != null) {
                                alarmNumber = number.getNumber() + 1;
                            } else {
                                alarmNumber = 1;
                            }
                            result.setAssetIds(ids);
                            result.setNumber(alarmNumber);
                            redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(alarmNumberBO.getSpaceId()), result);
                        } else {
                            a = 1;
                        }
                    } else {
                        //不存在资产的时候
                        Integer alarmNumber = 0;
                        if (number.getNumber() != null) {
                            alarmNumber = number.getNumber() + 1;
                        } else {
                            alarmNumber = 1;
                        }
                        if (!StringUtils.isEmpty(alarmNumberBO.getAssetId())) {
                            ArrayList<String> ids = new ArrayList<>();
                            ids.add(alarmNumberBO.getAssetId());
                            result.setAssetIds(ids);
                        }
                        result.setNumber(alarmNumber);
                        redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(alarmNumberBO.getSpaceId()), result);
                    }
                } else {
                    //这个空间第一次发生告警的时候
                    Integer alarmNumber = 1;
                    result.setNumber(alarmNumber);
                    if (!StringUtils.isEmpty(alarmNumberBO.getAssetId())) {
                        ArrayList<String> ids = new ArrayList<>();
                        ids.add(alarmNumberBO.getAssetId());
                        log.info("redis存入资产id为：" + ids);
                        result.setAssetIds(ids);
                    } else {
                        log.info("入参中不存在资产");
                    }
                    redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(alarmNumberBO.getSpaceId()), result);
                }
            } else if (alarmNumberBO.getType() == 2) {
                if (number != null) {
                    if (number.getNumber() != 0) {
                        //当传入有资产id，但是资产id不存在这个空间，就不允许减1.
                        if (alarmNumberBO.getAssetId() != null) {
                            if (number.getAssetIds().contains(alarmNumberBO.getAssetId())) {
                                Integer alarmNumber = 0;
                                //减1
                                if (number.getNumber() == null) {
                                    throw new BizException("该空间不存在异常数，无法减1", "030");
                                } else if (number.getNumber() != null) {
                                    alarmNumber = number.getNumber() - 1;
                                }
                                result.setNumber(alarmNumber);
                                //传入的参数有资产，代表需要删除该资产
                                if (DataUtils.isListAvali(number.getAssetIds())) {
                                    if (!StringUtils.isEmpty(alarmNumberBO.getAssetId())) {
                                        ArrayList<String> ids = new ArrayList<>();
                                        for (String assetId : number.getAssetIds()) {
                                            if (!alarmNumberBO.getAssetId().equals(assetId)) {
                                                ids.add(assetId);
                                            }
                                        }
                                        if (DataUtils.isListAvali(ids)) {
                                            result.setAssetIds(ids);
                                        }
                                    }
                                }
                                redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(alarmNumberBO.getSpaceId()), result);
                            } else {
                                a = 1;
                            }
                        } else {
                            //没有传入资产id
                            Integer alarmNumber = 0;
                            //减1
                            if (number.getNumber() == null) {
                                throw new BizException("该空间不存在异常数，无法减1", "030");
                            } else if (number.getNumber() != null) {
                                alarmNumber = number.getNumber() - 1;
                            }
                            result.setNumber(alarmNumber);
                            //传入的参数有资产，代表需要删除该资产
                            if (DataUtils.isListAvali(number.getAssetIds())) {
                                ArrayList<String> ids = new ArrayList<>();
                                ids.addAll(number.getAssetIds());
                                result.setAssetIds(ids);
                            }
                            redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(alarmNumberBO.getSpaceId()), result);
                        }
                    } else {
                        a = 1;
                    }
                }
            }
            //查询是否有父级id
            QuerySpaceInfoQueryDoBO query = new QuerySpaceInfoQueryDoBO();
            query.setSpcaeId(alarmNumberBO.getSpaceId());
            query.setLanguageCode("CN");
            ProjectSpaceBaseDoBO spaceInfo = spaceRepository.querySpaceInfo(query);
            log.info("父级空间id：" + spaceInfo.getParentProjectSpaceId() + "是否继续发送：" + a);
            if (!StringUtils.isEmpty(spaceInfo.getParentProjectSpaceId()) && a != 1) {
                UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                updateAlarmNumberBO.setType(alarmNumberBO.getType());
                updateAlarmNumberBO.setSpaceId(spaceInfo.getParentProjectSpaceId());
                updateAlarmNumberBO.setAssetId(alarmNumberBO.getAssetId());
                String sendInfo1 = JSONUtils.jacksonToJson(updateAlarmNumberBO);
                ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
            }
        }else {
            log.info("删除资产空间信息中");
            if (number != null && number.getNumber() > 0){
                log.info("缓存数据为：" + number);
                SeerAlarmNumBO newRedisInfo = new SeerAlarmNumBO();
                Integer newNumber = number.getNumber();
                List<String> assetIds = number.getAssetIds();
                List<String> newAssetIds = new ArrayList<>();
                for (String id : assetIds) {
                    if(!id.equals(alarmNumberBO.getAssetId())){
                        newAssetIds.add(id);
                    }else {
                        log.info("资产id为：" + id + "的资产在seer中外部空间标签中已被删除");
                        newNumber = newNumber - 1;
                    }
                }
                newRedisInfo.setAssetIds(newAssetIds);
                newRedisInfo.setNumber(newNumber);
                log.info("存入新的redis信息：" + newRedisInfo);
                redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(alarmNumberBO.getSpaceId()), newRedisInfo);
                //查询是否有父级id
                QuerySpaceInfoQueryDoBO query = new QuerySpaceInfoQueryDoBO();
                query.setSpcaeId(alarmNumberBO.getSpaceId());
                query.setLanguageCode("CN");
                ProjectSpaceBaseDoBO spaceInfo = spaceRepository.querySpaceInfo(query);
                log.info("父级空间id：" + spaceInfo.getParentProjectSpaceId());
                if (!StringUtils.isEmpty(spaceInfo.getParentProjectSpaceId())) {
                    UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                    updateAlarmNumberBO.setSpaceId(spaceInfo.getParentProjectSpaceId());
                    updateAlarmNumberBO.setAssetId(alarmNumberBO.getAssetId());
                    updateAlarmNumberBO.setOtherType("1");
                    String sendInfo1 = JSONUtils.jacksonToJson(updateAlarmNumberBO);
                    ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
                    log.info("继续删除上一层级空间资产信息：" + sendInfo1);
                }
            }
        }
    }

    @Override
    public boolean judge(String topic) {
        return StringUtils.equals(TopicConstants.DBM_SENTRY_UPDATE_SPACE_SPECIAL_ALARM_NUM, topic);
    }

    public static void main(String[] args) {
        SeerAlarmNumBO alarmNumberBO = new SeerAlarmNumBO();
        ArrayList<String> strings = new ArrayList<>();
        strings.add("1");
        strings.add("2");
        alarmNumberBO.setAssetIds(strings);
        alarmNumberBO.getAssetIds().add("3");
        System.out.println(!alarmNumberBO.getAssetIds().contains("1"));
        System.out.println(alarmNumberBO.getAssetIds());

    }
}
