package com.ifourthwall.dbm.sentry.service.impl;

import com.alibaba.fastjson.JSON;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.kafka.TopicConstants;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.sentry.bo.QueryTaskIdQuDoBO;
import com.ifourthwall.dbm.sentry.bo.TaskWorksheetStatusKafkaBO;
import com.ifourthwall.dbm.sentry.bo.UpMonitorRecordDoBO;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.kafka.DataHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author: hao.dai
 * @Date: 2019/12/26 11:50
 * @Description: 更新任务状态
 */
@Service("UpdateStatusHandler")
@Slf4j
public class UpdateStatusHandler implements DataHandler {

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public void handle(String jsonStrData) {
        log.info("接收到dbm_task_alert_update_status的数据" + jsonStrData);
        TaskWorksheetStatusKafkaBO taskStatus = JSONUtils.jacksonFromJson(jsonStrData, TaskWorksheetStatusKafkaBO.class);
        //查询是否存在
        QueryTaskIdQuDoBO query = new QueryTaskIdQuDoBO();
        query.setTaskWorkSheetId(taskStatus.getTaskId());
        Boolean aBoolean = monitorRepository.queryTaskId(query);
        if (aBoolean) {
            UpMonitorRecordDoBO upMonitorRecordDoBO = new UpMonitorRecordDoBO();
            if (("6").equals(taskStatus.getWorksheetStatusId()) || ("8").equals(taskStatus.getWorksheetStatusId())) {
                upMonitorRecordDoBO.setTaskStatusId("3");
            } else if (("1").equals(taskStatus.getWorksheetStatusId())) {
                upMonitorRecordDoBO.setTaskStatusId("1");
            } else {
                upMonitorRecordDoBO.setTaskStatusId("2");
            }
            upMonitorRecordDoBO.setTaskWorkSheetId(taskStatus.getTaskId());
            monitorRepository.upMonitorByTaskId(upMonitorRecordDoBO);
        }else {
            log.info("该taskId不存在，无法更新自动告警任务状态");
        }
    }

    @Override
    public boolean judge(String topic) {
        return StringUtils.equals(TopicConstants.dbmTaskUpdateStatus, topic);
    }
}
