package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.dbm.asset.dto.file.SeerFileQuDTO;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.file.SentryExcelBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.config.SentryExcelConfig;
import com.ifourthwall.dbm.sentry.domain.AssetRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.domain.SpaceRepository;
import com.ifourthwall.dbm.sentry.service.SentryFileService;
import com.ifourthwall.dbm.sentry.util.TimeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/6/16 17:17
 * @Description:
 */
@Service("SentryFileServiceImpl")
@Slf4j
public class SentryFileServiceImpl implements SentryFileService {

    @Autowired
    private SentryExcelConfig excelConfig;

    @Autowired
    private GodzillaServerRepository godzillaServerRepository;


    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Resource(name = "AssetRepository")
    private AssetRepository assetRepository;

    @Resource(name = "SpaceRepository")
    private SpaceRepository spaceRepository;

    /**
     * seer下载数据点位
     *
     * @param query
     * @param user
     * @return com.ifourthwall.dbm.sentry.bo.FileExportBO
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/16 17:19
     */
    @Override
    public FileExportBO download(SeerFileQuDTO query, IFWUser user) {
        FileExportBO result = new FileExportBO();
        String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
        query.setTenantId(tenantId);
        //表头
        SentryExcelBO sentryExcelBO = new SentryExcelBO();
        if ("CN".equals(query.getLanguageCode())) {
            sentryExcelBO = excelConfig.getList().get(0);
        }
        if ("EN".equals(query.getLanguageCode())) {
            sentryExcelBO = excelConfig.getList().get(1);
        }
        if ("JP".equals(query.getLanguageCode())) {
            sentryExcelBO = excelConfig.getList().get(2);
        }
        //创建表格
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(query.getMonitorMetricName());
        XSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue(sentryExcelBO.getSpace());
        row.createCell(1).setCellValue(sentryExcelBO.getName());
        row.createCell(2).setCellValue(sentryExcelBO.getTime());
        row.createCell(3).setCellValue(sentryExcelBO.getValue());
        row.createCell(4).setCellValue(sentryExcelBO.getMax());
        row.createCell(5).setCellValue(sentryExcelBO.getMin());
        row.createCell(6).setCellValue(sentryExcelBO.getUnit());
        row.createCell(7).setCellValue(sentryExcelBO.getUser());
        row.createCell(8).setCellValue(sentryExcelBO.getType());
        //查询appID
        QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
        queryAppIdQueryDoBO.setTenantId(tenantId);
        QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppIdQueryDoBO);
        if (queryAppIdBO != null) {
            //查询指标
            MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
            metricValueRecordListReqBO.setDataPointId(query.getDataPointId());
            metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
            metricValueRecordListReqBO.setStartTime(query.getStartTime());
            metricValueRecordListReqBO.setEndTime(query.getEndTime());
            MetricValueRecordListBO metricValueRecordListBO = godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
            if (metricValueRecordListBO != null) {
                //查询单位
                QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                queryRuleAndStartBO.setDataPointId(query.getDataPointId());
                QueryRuleAndStartDoBO queryRuleAndStartDoBO = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                if (queryRuleAndStartDoBO != null) {
                    //从第一行插入数据
                    int fistRow = 1;
                    for (GodzillaInfoBO godzillaInfoBO : metricValueRecordListBO.getCollectDataList()) {
                        XSSFRow row1 = sheet.createRow(fistRow);
                        row1.createCell(0).setCellValue(query.getSpaceName());
                        row1.createCell(1).setCellValue(query.getAssetName());
                        row1.createCell(2).setCellValue(godzillaInfoBO.getTime());
                        row1.createCell(3).setCellValue(godzillaInfoBO.getValue());
                        row1.createCell(4).setCellValue(godzillaInfoBO.getAlarmMax());
                        row1.createCell(5).setCellValue(godzillaInfoBO.getAlarmMin());
                        row1.createCell(6).setCellValue(queryRuleAndStartDoBO.getUnit());
                        row1.createCell(7).setCellValue(godzillaInfoBO.getUserName());
                        row1.createCell(8).setCellValue(query.getMetricType());
                        fistRow++;
                    }
                }
            }
        }
        result.setFile(wb);
        result.setFilename(query.getMonitorMetricName());
        return result;
    }

    /**
     * seer通过点位下载数据点位
     *
     * @param query
     * @param user
     * @return com.ifourthwall.dbm.sentry.bo.FileExportBO
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/16 15:20
     */
    @Override
    public FileExportBO downloadByDataPoint(SeerFileQuBO query, IFWUser user) {
        FileExportBO result = new FileExportBO();
        String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
        query.setTenantId(tenantId);
        //查询监控对象
        queryDataPointIdQuBO queryDataByMonitorQuDoBO = new queryDataPointIdQuBO();
        queryDataByMonitorQuDoBO.setDataPointId(query.getDataPointId());
        queryDataByMonitorQuDoBO.setTenantId(query.getTenantId());
        queryDataByMonitorQuDoBO.setLanguageCode(query.getLanguageCode());
        queryDataPointIdBO queryDataByMonitorDoBO = monitorRepository.queryDataPointId(queryDataByMonitorQuDoBO);
        QueryAssetByDPDoQuBO queryAsset = new QueryAssetByDPDoQuBO();
        queryAsset.setDataPointId(query.getDataPointId());

        QueryAssetByDPDoBO asset = monitorRepository.queryAssetByDP(queryAsset);
        String assetName = "unknown";
        String spaceName = "unknown";
        if (asset != null) {
            //查询资产信息
            AssetInfoQueryDoBO assetInfoQueryDoBO = new AssetInfoQueryDoBO();
            assetInfoQueryDoBO.setAssetId(asset.getAssetId());
            assetInfoQueryDoBO.setLanguageCode(query.getLanguageCode());
            QueryAssetInfoDoBO queryAssetInfoDoBO = assetRepository.queryAssetInfo(assetInfoQueryDoBO);
            if (queryAssetInfoDoBO != null) {
                assetName = queryAssetInfoDoBO.getAssetName();
            }
            //查询空间名称
            GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
            ArrayList<String> spaceIds = new ArrayList<>();
            spaceIds.add(queryAssetInfoDoBO.getProjectSpaceId());
            getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
            getNewPathBatchQueryBO.setProjectId(queryAssetInfoDoBO.getProjectId());
            getNewPathBatchQueryBO.setLanguageCode(query.getLanguageCode());
            getNewPathBatchQueryBO.setTenantId(tenantId);
            List<ProjectSpacePathBO> newPathBatch = spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
            if (newPathBatch != null) {
                spaceName = newPathBatch.get(0).getNameStr();
            }
        }
        //表头
        SentryExcelBO sentryExcelBO = new SentryExcelBO();
        if ("CN".equals(query.getLanguageCode())) {
            sentryExcelBO = excelConfig.getList().get(0);
        }
        if ("EN".equals(query.getLanguageCode())) {
            sentryExcelBO = excelConfig.getList().get(1);
        }
        if ("JP".equals(query.getLanguageCode())) {
            sentryExcelBO = excelConfig.getList().get(2);
        }
        //创建表格
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(queryDataByMonitorDoBO.getMonitorMetricName());
        XSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue(sentryExcelBO.getSpace());
        row.createCell(1).setCellValue(sentryExcelBO.getName());
        row.createCell(2).setCellValue(sentryExcelBO.getTime());
        row.createCell(3).setCellValue(sentryExcelBO.getValue());
        row.createCell(4).setCellValue(sentryExcelBO.getMax());
        row.createCell(5).setCellValue(sentryExcelBO.getMin());
        row.createCell(6).setCellValue(sentryExcelBO.getUnit());
        row.createCell(7).setCellValue(sentryExcelBO.getUser());
        row.createCell(8).setCellValue(sentryExcelBO.getType());
        if (queryDataByMonitorDoBO != null) {
            //查询appID
            QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
            queryAppIdQueryDoBO.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppIdQueryDoBO);
            if (queryAppIdBO != null) {
                //查询指标
                MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                metricValueRecordListReqBO.setDataPointId(query.getDataPointId());
                metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                metricValueRecordListReqBO.setStartTime(query.getStartTime());
                metricValueRecordListReqBO.setEndTime(query.getEndTime());
                MetricValueRecordListBO metricValueRecordListBO = godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                if (metricValueRecordListBO != null) {
                    //查询单位
                    QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                    queryRuleAndStartBO.setDataPointId(query.getDataPointId());
                    QueryRuleAndStartDoBO queryRuleAndStartDoBO = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                    if (queryRuleAndStartDoBO != null) {
                        //从第一行插入数据
                        int fistRow = 1;
                        for (GodzillaInfoBO godzillaInfoBO : metricValueRecordListBO.getCollectDataList()) {
                            XSSFRow row1 = sheet.createRow(fistRow);
                            row1.createCell(0).setCellValue(spaceName);
                            row1.createCell(1).setCellValue(assetName);
                            row1.createCell(2).setCellValue(godzillaInfoBO.getTime());
                            row1.createCell(3).setCellValue(godzillaInfoBO.getValue());
                            row1.createCell(4).setCellValue(godzillaInfoBO.getAlarmMax());
                            row1.createCell(5).setCellValue(godzillaInfoBO.getAlarmMin());
                            row1.createCell(6).setCellValue(queryRuleAndStartDoBO.getUnit());
                            row1.createCell(7).setCellValue(godzillaInfoBO.getUserName());
                            row1.createCell(8).setCellValue(queryDataByMonitorDoBO.getMetricType());
                            fistRow++;
                        }
                    }
                }
            }
        }
        result.setFile(wb);
        result.setFilename(queryDataByMonitorDoBO.getMonitorMetricName());
        return result;
    }

    public static void main(String[] args) throws ParseException {
        boolean send = false;
        String time = "00:00-15:12";
        SimpleDateFormat formatHours = new SimpleDateFormat("HH:mm");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] split = time.split(",");
        for (String s : split) {
            if (!StringUtils.isEmpty(s)) {
                String[] split1 = s.split("-");
                String start = split1[0];
                String end = split1[1];
                Date startTime = formatHours.parse(start);
                Date endTime = formatHours.parse(end);
                Date nowTime = format.parse(format.format(new Date()));
                boolean effectiveDate = TimeUtils.isEffectiveDate(nowTime, startTime, endTime);
                if (!effectiveDate) {
                    log.info("不在告警区间内");
                    send = true;
                    break;
                }
            }
        }
        if (!send) {
            log.info("不在告警区间内");
        }
    }
}
