package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.kafka.TopicConstants;
import com.ifourthwall.common.utils.*;
import com.ifourthwall.dbm.asset.dto.seer.*;
import com.ifourthwall.dbm.asset.dto.seer.energy.*;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoBasisDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoQuDTO;
import com.ifourthwall.dbm.security.dto.QueryCameraListDTO;
import com.ifourthwall.dbm.security.dto.QueryCameraListQuDTO;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordDoBO;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordQuDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.QueryEnvironmentListDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.QueryMonitorMetricListDoBO;
import com.ifourthwall.dbm.sentry.bo.sq.SqDepositSentryBasisBO;
import com.ifourthwall.dbm.sentry.bo.sq.SqDepositSentryInfoBO;
import com.ifourthwall.dbm.sentry.dto.DataPointDTO;
import com.ifourthwall.dbm.sentry.dto.DataPointQuDTO;
import com.ifourthwall.dbm.sentry.dto.QueryInfoByDataPointDTO;
import com.ifourthwall.dbm.sentry.dto.QueryMetricIdDTO;
import com.ifourthwall.kafka.IFWKafkaClient;
import org.springframework.scheduling.annotation.Scheduled;
import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.domain.*;
import com.ifourthwall.dbm.sentry.service.SeerService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 10:29
 * @Description:
 */
@Slf4j
@Service("SeerServiceImpl")
public class SeerServiceImpl implements SeerService {

    @Autowired
    private RedisTemplate redisTemplate;

    @Reference(version = "1.0.0")
    private MonitorFacade monitorFacade;

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Resource(name = "MonitorTargetTagRepository")
    private MonitorTargetTagRepository targetTagRepository;

    @Resource(name = "AssetRepository")
    private AssetRepository assetRepository;

    @Resource(name = "SpaceRepository")
    private SpaceRepository spaceRepository;

    @Resource(name = "TaskRepository")
    private TaskRepository taskRepository;

    @Resource(name = "CameraRepository")
    private CameraRepository cameraRepository;

    @Autowired
    private GodzillaServerRepository godzillaServerRepository;

    @Value("${sq.app.id}")
    private String appId;

    @Value("${sq.project.id}")
    private String projectId;

    @Value("${sq.tenant.id}")
    private String tenantId;

    @Value("${sq.tag.water}")
    private String waterId;

    @Value("${sq.tag.electricity}")
    private String electricityId;

    public static DateTimeFormatter dateTimeFormatterFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");


    //当有自动告警发生时，把该空间的告警数+1 或-1
    @Resource(name = "IFWKafkaClient-" + TopicConstants.DBM_SENTRY_UPDATE_SPACE_SPECIAL_ALARM_NUM)
    private IFWKafkaClient ifwKafkaClientUpdateAlarmNumber;

    private static final int FRACTION_MIN_WIDTH = 0;
    private static final int FRACTION_MAX_WIDTH = 9;
    private static final boolean ADD_DECIMAL_POINT = true;
    public static final DateTimeFormatter RFC3339_FORMATTER = new DateTimeFormatterBuilder()
            .appendPattern("yyyy-MM-dd'T'HH:mm:ss")
            .appendFraction(ChronoField.NANO_OF_SECOND, FRACTION_MIN_WIDTH, FRACTION_MAX_WIDTH, ADD_DECIMAL_POINT)
            .appendZoneOrOffsetId()
            .toFormatter();

    /**
     * seer空间标签
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.SeerQueryTagDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/4/24 15:08
     */
    @Override
    public BaseResponse<List<SeerQueryTagDTO>> seerQueryTag(SeerQueryTagQuDTO query, IFWUser user) {
        BaseResponse<List<SeerQueryTagDTO>> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            //获取现在时间及十分钟前的时间
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long nowTime = System.currentTimeMillis();
            long Tenminute = nowTime - (5*60*1000);
            //获取当前时间戳
            Long timeStamp = System.currentTimeMillis();
            SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            // 时间戳转换成时间
            String now = sdf.format(new Date(Long.parseLong(String.valueOf(nowTime))));
            // 时间戳转换成时间
            String ten = sdf.format(new Date(Long.parseLong(String.valueOf(Tenminute))));
            ArrayList<SeerQueryTagDTO> resultList = new ArrayList<>();
            if (DataUtils.isListAvali(query.getSpaceIdList())) {
                for (String id : query.getSpaceIdList()) {
                    log.info("redis查询id为：" + id);
                    SeerAlarmNumBO number = (SeerAlarmNumBO) redisTemplate.opsForValue().get(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(id));
                    log.info("redis查询数据为：" + number);
                    SeerQueryTagDTO result = new SeerQueryTagDTO();
                    result.setSpaceId(id);
                    Integer alertNumber = 0;
                    //查询摄像头告警
                    GetSonSpaceQueryBO getSonSpaceQueryBO = new GetSonSpaceQueryBO();
                    getSonSpaceQueryBO.setSpaceId(id);
                    GetSonSpaceBO sonpace = spaceRepository.getSonpace(getSonSpaceQueryBO);
                    QueryAlarmRecordQuDoBO queryCameraList = new QueryAlarmRecordQuDoBO();
                    queryCameraList.setSpaceId(sonpace.getSpaceId());
                    queryCameraList.setProjectId(query.getProjectId());
                    queryCameraList.setLanguageCode(query.getLanguageCode());
                    queryCameraList.setTenantId(tenantId);
                    queryCameraList.setStartTime(ten);
                    queryCameraList.setEndTime(now);
                    IFWPageInfo<QueryAlarmRecordDoBO> queryAlarmRecord = cameraRepository.queryAlarmRecord(queryCameraList);
                    if (queryAlarmRecord != null) {
                        ArrayList<String> cameraType = new ArrayList<>();
                        Map<String, List<QueryAlarmRecordDoBO>> typeMap = queryAlarmRecord.getList().stream().filter(a -> a.getCameraEventTypeId() != null).collect(Collectors.groupingBy(QueryAlarmRecordDoBO::getCameraEventTypeId));
                        for (Map.Entry<String, List<QueryAlarmRecordDoBO>> type : typeMap.entrySet()) {
                            cameraType.add(type.getKey());
                        }
                        List<String> cameraId = queryAlarmRecord.getList().stream().map(QueryAlarmRecordDoBO::getCameraId).distinct().collect(Collectors.toList());
                        result.setCameraId(cameraId);
                        result.setCameraInfoType(cameraType);
                    }
                    if (number == null) {
                        result.setAlarmNumber(alertNumber);
                    } else {
                        result.setAlarmNumber(number.getNumber());
                        if (DataUtils.isListAvali(number.getAssetIds())) {
                            result.setAssetId(number.getAssetIds());
                        }
                    }
                    resultList.add(result);
                }
            } else {
                QueryNextSonListQuDoBO queryNextSonList = new QueryNextSonListQuDoBO();
                queryNextSonList.setSpaceId(query.getSpaceId());
                queryNextSonList.setProjectId(query.getProjectId());
                queryNextSonList.setLanguageCode(query.getLanguageCode());
                queryNextSonList.setTenantId(query.getTenantId());
                QueryNextSonListDoBO nextSonList = spaceRepository.queryNextSonList(queryNextSonList);
                if (nextSonList != null) {
                    for (String id : nextSonList.getSpaceId()) {
                        SeerAlarmNumBO number = (SeerAlarmNumBO) redisTemplate.opsForValue().get(RedisKeyPrefixUtil.getDbmSentryUpdateSpaceSpecialAlarmNumNew(id));
                        log.info("redis查询结果：" + number);
                        SeerQueryTagDTO result = new SeerQueryTagDTO();
                        result.setSpaceId(id);
                        Integer alertNumber = 0;
                        if (number == null) {
                            result.setAlarmNumber(alertNumber);
                        } else {
                            result.setAlarmNumber(number.getNumber());
                            if (DataUtils.isListAvali(number.getAssetIds())) {
                                result.setAssetId(number.getAssetIds());
                            }
                        }
                        //查询摄像头告警
                        GetSonSpaceQueryBO getSonSpaceQueryBO = new GetSonSpaceQueryBO();
                        getSonSpaceQueryBO.setSpaceId(id);
                        GetSonSpaceBO sonpace = spaceRepository.getSonpace(getSonSpaceQueryBO);
                        QueryAlarmRecordQuDoBO queryCameraList = new QueryAlarmRecordQuDoBO();
                        queryCameraList.setSpaceId(sonpace.getSpaceId());
                        queryCameraList.setProjectId(query.getProjectId());
                        queryCameraList.setLanguageCode(query.getLanguageCode());
                        queryCameraList.setTenantId(tenantId);
                        queryCameraList.setStartTime(ten);
                        queryCameraList.setEndTime(now);
                        IFWPageInfo<QueryAlarmRecordDoBO> queryAlarmRecord = cameraRepository.queryAlarmRecord(queryCameraList);
                        if (queryAlarmRecord != null) {
                            ArrayList<String> cameraType = new ArrayList<>();
                            Map<String, List<QueryAlarmRecordDoBO>> typeMap = queryAlarmRecord.getList().stream().filter(a -> a.getCameraEventTypeId() != null).collect(Collectors.groupingBy(QueryAlarmRecordDoBO::getCameraEventTypeId));
                            for (Map.Entry<String, List<QueryAlarmRecordDoBO>> type : typeMap.entrySet()) {
                                cameraType.add(type.getKey());
                            }
                            List<String> cameraId = queryAlarmRecord.getList().stream().map(QueryAlarmRecordDoBO::getCameraId).distinct().collect(Collectors.toList());
                            result.setCameraId(cameraId);
                            result.setCameraInfoType(cameraType);
                        }
                        resultList.add(result);
                    }
                }
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 根据空间标签查询指标统计
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.SeerQueryTagDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/4/28 20:32
     */
    @Override
    public BaseResponse<QueryIndexStatisticsDTO> queryIndexStatistics(QueryIndexStatisticsQuDTO query, IFWUser user) {
        BaseResponse<QueryIndexStatisticsDTO> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            QueryIndexStatisticsDTO result = new QueryIndexStatisticsDTO();
            //查询该标签下有哪些检测对象
            QueryTagInfoListQuBO queryTagInfoList = new QueryTagInfoListQuBO();
            queryTagInfoList.setTagId(query.getTargetTagId());
            queryTagInfoList.setLanguageCode("CN");
            List<QueryTagInfoListDTO> queryTagInfoListBO = targetTagRepository.queryTagInfoList(queryTagInfoList);
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException("不存在appId，请申请!", "15");
            }
            if (DataUtils.isListAvali(queryTagInfoListBO)) {
                //获取昨天、今天的时间
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date startTime = DataUtils.getDayBegin();
                Date endTime = DataUtils.getDayEnd();
                Date beginDayOfTomorrow = DataUtils.getBeginDayOfTomorrow();
                Date yesterDayStartTime = DataUtils.getBeginDayOfYesterday();
                Date YesterDayEndTime = DataUtils.getEndDayOfYesterDay();
                //查询总的数据
                BigDecimal number = new BigDecimal("0");
                List<QueryTagInfoListDTO> notNullList = queryTagInfoListBO.stream().filter(a -> !StringUtils.isEmpty(a.getDataPointId())).collect(Collectors.toList());
                //按照指标查询
                for (QueryTagInfoListDTO queryInfo : notNullList) {
                    //查询今天的数据
                    MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                    metricValueRecordListReqBO.setDataPointId(queryInfo.getDataPointId());
                    metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                    metricValueRecordListReqBO.setStartTime(startTime);
                    metricValueRecordListReqBO.setEndTime(endTime);
                    MetricValueRecordListBO nowGodzillaInfo = godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                    if (nowGodzillaInfo != null) {
                        if (DataUtils.isListAvali(nowGodzillaInfo.getCollectDataList())) {
                            //获取第一条数据和最后一条数据，
                            GodzillaInfoBO godzillaInfoBO = nowGodzillaInfo.getCollectDataList().get(0);
                            GodzillaInfoBO godzillaInfoBO1 = nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                            //获取值
                            BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                            BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                            log.info("第一条数据值为:" + vaule1);
                            log.info("最后一条条数据值为:" + vaule2);
                            //获取第一条数据的时间
                            TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                            LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                            int hour1 = isoTime1.getHour();
                            //获取第二条数据的时间
                            TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                            LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                            int hour2 = isoTime2.getHour();
                            //若开始和结束的值相等，则取开始的值
                            if (vaule1.equals(vaule2)) {
                                number = number.add(new BigDecimal("0"));
                            } else if (!vaule1.equals(vaule2)) {
                                if (hour1 > hour2) {
                                    number = number.add(vaule1.subtract(vaule2));
                                }
                                if (hour1 < hour2) {
                                    number = number.add(vaule2.subtract(vaule1));
                                }
                            }
                        }
                    }
                }
                if ("1".equals(query.getType())) {
                    QueryIndexStatisticsDTO electricity = (QueryIndexStatisticsDTO) redisTemplate.opsForValue().get(RedisKeyPrefixUtil.getCameraCountInfoType("1"));
                    if (electricity != null) {
                        log.info("redis数据：" + electricity);
                        result.setTodayIndexInfo(electricity.getTodayIndexInfo());
                        result.setYesterdayIndexInfo(electricity.getYesterdayIndexInfo());
                    }
                } else if ("2".equals(query.getType())) {
                    QueryIndexStatisticsDTO water = (QueryIndexStatisticsDTO) redisTemplate.opsForValue().get(RedisKeyPrefixUtil.getCameraCountInfoType("2"));
                    if (water != null) {
                        log.info("redis数据：" + water);
                        result.setTodayIndexInfo(water.getTodayIndexInfo());
                        result.setYesterdayIndexInfo(water.getYesterdayIndexInfo());
                    }
                }
                result.setNumber(number);
            }
            response.setData(result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 根据空间标签查询排行
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryIndexRankingDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/4/29 18:17
     */
    @Override
    public BaseResponse<List<QueryIndexRankingDTO>> queryIndexRanking(QueryIndexRankingQuDTO query, IFWUser user) {
        BaseResponse<List<QueryIndexRankingDTO>> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            ArrayList<QueryIndexRankingDTO> resultList = new ArrayList<>();
            QueryIndexStatisticsDTO result = new QueryIndexStatisticsDTO();
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException("不存在appId，请申请!", "15");
            }
            //查询系统分类
            TranslationDoBO translationDoBO = new TranslationDoBO();
            translationDoBO.setLanguageCode(query.getLanguageCode());
            AllTranslationDoBO allTranslationDoBO = assetRepository.allTranslation(translationDoBO);
            for (Map.Entry<String, String> tagIds : allTranslationDoBO.getSystem().entrySet()) {
                QueryIndexRankingDTO resultDTO = new QueryIndexRankingDTO();
                resultDTO.setTargetTagId(tagIds.getKey());
                resultDTO.setTargetTagName(tagIds.getValue());
                // 下有哪些检测对象
                QueryTagInfoListQuBO queryTagInfoList = new QueryTagInfoListQuBO();
                queryTagInfoList.setTagId(query.getTargetTagId());
                queryTagInfoList.setLanguageCode("CN");
                queryTagInfoList.setAssetSystemId(tagIds.getKey());
                List<QueryTagInfoListDTO> queryTagInfoListBO = targetTagRepository.queryTagInfoList(queryTagInfoList);
                //获取昨天、今天的时间
                Date startTime = DataUtils.getDayBegin();
                Date endTime = DataUtils.getDayEnd();
                Date beginDayOfTomorrow = DataUtils.getBeginDayOfTomorrow();
                Date yesterDayStartTime = DataUtils.getBeginDayOfYesterday();
                Date YesterDayEndTime = DataUtils.getEndDayOfYesterDay();
                //查询总的数据
                BigDecimal number = new BigDecimal("0");
                //按照指标查询
                List<QueryTagInfoListDTO> notNullList = queryTagInfoListBO.stream().filter(a -> !StringUtils.isEmpty(a.getDataPointId())).collect(Collectors.toList());
                if (DataUtils.isListAvali(notNullList)) {
                    for (QueryTagInfoListDTO queryInfo : notNullList) {
                        //查询今天的数据
                        MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                        metricValueRecordListReqBO.setDataPointId(queryInfo.getDataPointId());
                        metricValueRecordListReqBO.setAppId(queryAppIdBO.getAppId());
                        metricValueRecordListReqBO.setStartTime(startTime);
                        metricValueRecordListReqBO.setEndTime(endTime);
//                            metricValueRecordListReqBO.setStartTime(yesterDayStartTime);
//                            metricValueRecordListReqBO.setEndTime(YesterDayEndTime);
                        MetricValueRecordListBO nowGodzillaInfo = godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                        if (nowGodzillaInfo != null) {
                            if (DataUtils.isListAvali(nowGodzillaInfo.getCollectDataList())) {
                                //获取第一条数据和最后一条数据，拿出时间比较，时间大的减去时间小的
                                GodzillaInfoBO godzillaInfoBO = nowGodzillaInfo.getCollectDataList().get(0);
                                GodzillaInfoBO godzillaInfoBO1 = nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                                //获取值
                                BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                                BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                                log.info("第一条数据值为:" + vaule1);
                                log.info("最后一条条数据值为:" + vaule2);
                                //获取第一条数据的时间
                                TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                                LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                                int hour1 = isoTime1.getHour();
                                //获取第二条数据的时间
                                TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                                LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                                int hour2 = isoTime2.getHour();
                                //若开始和结束的值相等，则取开始的值
                                if (vaule1.equals(vaule2)) {
                                    number = number.add(new BigDecimal("0"));
                                } else if (!vaule1.equals(vaule2)) {
                                    if (hour1 > hour2) {
                                        number = number.add(vaule1.subtract(vaule2));
                                    }
                                    if (hour1 < hour2) {
                                        number = number.add(vaule2.subtract(vaule1));
                                    }
                                }
                                log.info("相见后数值为：" + number);
                            }
                        }
                    }
                }
                resultDTO.setNumber(number);
                resultList.add(resultDTO);
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 环境统计
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/22 15:40
     */
    @Override
    public BaseResponse<QueryEnvironmentDTO> queryEnvironment(QueryEnvironmentBasisQuDTO query, IFWUser user) {
        BaseResponse<QueryEnvironmentDTO> response = new BaseResponse<>();
        QueryEnvironmentDTO result = new QueryEnvironmentDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            Integer normalNumber = 0;
            Integer abnormalNumber = 0;
            if (DataUtils.isListAvali(query.getMonitorMetricTargetId())) {
                //根据需要查询的监控对象查询出状态
                QueryMonitorListDoQueryBO queryMonitorList = new QueryMonitorListDoQueryBO();
                queryMonitorList.setTenantId(tenantId);
                queryMonitorList.setLanguageCode(query.getLanguageCode());
                queryMonitorList.setMonitorTargetId(query.getMonitorMetricTargetId());
                queryMonitorList.setProjectId(query.getProjectId());
                IFWPageInfo<QueryMonitorListDoBO> monitorList = monitorRepository.queryMonitorList(queryMonitorList);
                if (monitorList != null) {
                    Map<String, List<QueryMonitorListDoBO>> spaceMap = monitorList.getList().stream().filter(a -> !StringUtils.isEmpty(a.getAssetStatus())).collect(Collectors.groupingBy(QueryMonitorListDoBO::getProjectSpaceId));
                    for (Map.Entry<String, List<QueryMonitorListDoBO>> space : spaceMap.entrySet()) {
                        List<QueryMonitorListDoBO> normal = space.getValue().stream().filter(a -> "2".equals(a.getAssetStatus())).collect(Collectors.toList());
                        if (DataUtils.isListAvali(normal)) {
                            abnormalNumber += 1;
                        } else {
                            normalNumber += 1;
                        }
                    }
                }
            }
            result.setAbnormalNumber(abnormalNumber);
            result.setNormalNumber(normalNumber);
            response.setData(result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 环境统计列表
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo < com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/22 16:26
     */
    @Override
    public BaseResponse<List<EnvironmentListDTO>> queryEnvironmentList(QueryEnvironmentListQuDTO query, IFWUser user) {
        BaseResponse<List<EnvironmentListDTO>> response = new BaseResponse<>();
        ArrayList<EnvironmentListDTO> resultList = new ArrayList<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            //查询监控指标
            if (DataUtils.isListAvali(query.getMonitorMetricTargetId()) || DataUtils.isListAvali(query.getDataPointId()) || DataUtils.isListAvali(query.getMonitorMetricTargetId())) {
                List<QueryEnvironmentListDoBO> environmentList = monitorRepository.queryMonitorMetricList(IFWBeanCopyUtil.map(query, QueryMonitorMetricListDoBO.class));
                if (environmentList != null) {
                    Map<String, List<QueryEnvironmentListDoBO>> monitorMetricMap = environmentList.stream().collect(Collectors.groupingBy(QueryEnvironmentListDoBO::getProjectSpaceId));
                    for (Map.Entry<String, List<QueryEnvironmentListDoBO>> spaceInfo : monitorMetricMap.entrySet()) {
                        EnvironmentListDTO result = new EnvironmentListDTO();
                        ArrayList<EnvironmentListBasisDTO> resultBasisList = new ArrayList<>();
                        //存入空间信息
                        result.setSpaceId(spaceInfo.getKey());
                        ArrayList<String> spaceIds = new ArrayList<>();
                        spaceIds.add(spaceInfo.getKey());
                        GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
                        getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
                        getNewPathBatchQueryBO.setProjectId(query.getProjectId());
                        getNewPathBatchQueryBO.setLanguageCode(query.getLanguageCode());
                        getNewPathBatchQueryBO.setTenantId(tenantId);
                        List<ProjectSpacePathBO> newPathBatch = spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
                        if (DataUtils.isListAvali(newPathBatch)) {
                            result.setSpaceName(newPathBatch.get(0).getNameStr());
                        }
                        //存入监控指标信息
                        for (QueryEnvironmentListDoBO monitorMetricInfo : spaceInfo.getValue()) {
                            EnvironmentListBasisDTO resultBasis = new EnvironmentListBasisDTO();
                            resultBasis.setName(monitorMetricInfo.getMonitorMetricName());
                            resultBasis.setMonitorTargetTagPicture(monitorMetricInfo.getMonitorTargetTagPicture());
                            //通过查询哥斯拉查询出相关数据
                            QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                            queryRuleAndStartBO.setDataPointId(monitorMetricInfo.getDataPointId());
                            log.info("查询点位：" + monitorMetricInfo);
                            QueryRuleAndStartDoBO ruleAndStart = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                            log.info("查询数据：" + ruleAndStart);
                            if (ruleAndStart != null) {
                                resultBasis.setUnit(ruleAndStart.getUnit());
                                resultBasis.setValue(ruleAndStart.getCurrentValue());
                            }
                            //判断监测点位是否为空，因该字段为后来增加，可能会出现数据为空
                            if (StringUtils.isEmpty(monitorMetricInfo.getMonitorMetricStatusId())) {
                                //状态字段为空，则为正常
                                resultBasis.setMonitorMetricStatusId("1");
                                result.setSpaceStatus("1");
                            } else {
                                if ("1".equals(monitorMetricInfo.getMonitorMetricStatusId())) {
                                    //状态字段不为空，且为正常
                                    resultBasis.setMonitorMetricStatusId(monitorMetricInfo.getMonitorMetricStatusId());
                                    result.setSpaceStatus("1");
                                    log.info("设备正常");
                                }
                                if ("2".equals(monitorMetricInfo.getMonitorMetricStatusId())) {
                                    //状态字段不为空，且为异常
                                    result.setSpaceStatus("2");
                                    //判断最后一次采集与预值的大小
                                    if (DataUtils.isListAvali(ruleAndStart.getAlarmInfo())) {
                                        //判断值
                                        int rules = 0;
                                        for (AlertRulesDTO alertRulesDTO : ruleAndStart.getAlarmInfo()) {
                                            if (rules == 0) {
                                                BigDecimal value = new BigDecimal(ruleAndStart.getCurrentValue());
                                                BigDecimal max = new BigDecimal(alertRulesDTO.getAlarmMaximumValue());
                                                BigDecimal min = new BigDecimal(alertRulesDTO.getAlarmMinimumValue());
                                                int a = value.compareTo(max);
                                                int b = value.compareTo(min);
                                                if (a != 1) {
                                                    //当前值 >= 最大值
                                                    resultBasis.setMonitorMetricStatusId("2");
                                                    rules += 1;
                                                    log.info("大于预值");
                                                }
                                                if (b != -1) {
                                                    //当前值 <= 最小值
                                                    resultBasis.setMonitorMetricStatusId("3");
                                                    rules += 1;
                                                    log.info("小于预值");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            resultBasis.setMonitorTargetTagPicture(monitorMetricInfo.getMonitorTargetTagPicture());
                            resultBasisList.add(resultBasis);
                        }
                        result.setMonitorMetricInfo(resultBasisList);
                        resultList.add(result);
                    }
                }
                if (!StringUtils.isEmpty(query.getSpaceName())) {
                    //按照空间名称搜索
                    ProjectSpaceSubListQueryDoBO querySpaceList = new ProjectSpaceSubListQueryDoBO();
                    querySpaceList.setLanguageCode(query.getLanguageCode());
                    querySpaceList.setProjectId(query.getProjectId());
                    querySpaceList.setNameLike(query.getSpaceName());
                    querySpaceList.setTenantId(tenantId);
                    //匹配查询出来的名字
                    List<ProjectSpaceBaseDoBO> sonSpaceList = spaceRepository.getSonSpaceList(querySpaceList);
                    if (sonSpaceList != null) {
                        ArrayList<EnvironmentListDTO> spaceResultList = new ArrayList<>();
                        for (EnvironmentListDTO result : resultList) {
                            for (ProjectSpaceBaseDoBO space : sonSpaceList) {
                                if (StringUtils.equals(result.getSpaceId(), space.getProjectSpaceId())) {
                                    spaceResultList.add(result);
                                }
                            }
                        }
                        response.setData(spaceResultList);
                    } else {
                        response.setData(null);
                    }
                } else {
                    response.setData(resultList);
                }
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 门磁-空间安全监测
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.QueryInductionDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/24 16:27
     */
    @Override
    public BaseResponse<QueryInductionDTO> queryInduction(QueryInductionQuDTO query, IFWUser user) {
        BaseResponse<QueryInductionDTO> response = new BaseResponse<>();
        QueryInductionDTO result = new QueryInductionDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            //查询监测指标状态
            Integer totalNumber = 0;
            Integer noPeopelSpaceNumber = 0;
            Integer peopelSpaceNumber = 0;
            if (DataUtils.isListAvali(query.getMonitorMetricTargetId())) {
                //根据需要查询的监控对象查询出状态
                QueryMonitorListDoQueryBO queryMonitorList = new QueryMonitorListDoQueryBO();
                queryMonitorList.setTenantId(tenantId);
                queryMonitorList.setLanguageCode(query.getLanguageCode());
                queryMonitorList.setMonitorTargetId(query.getMonitorMetricTargetId());
                queryMonitorList.setProjectId(query.getProjectId());
                IFWPageInfo<QueryMonitorListDoBO> monitorList = monitorRepository.queryMonitorList(queryMonitorList);
                if (monitorList != null) {
                    Map<String, List<QueryMonitorListDoBO>> spaceMap = monitorList.getList().stream().filter(a -> !StringUtils.isEmpty(a.getAssetStatus())).collect(Collectors.groupingBy(QueryMonitorListDoBO::getProjectSpaceId));
                    for (Map.Entry<String, List<QueryMonitorListDoBO>> space : spaceMap.entrySet()) {
                        totalNumber += 1;
                        List<QueryMonitorListDoBO> normal = space.getValue().stream().filter(a -> "2".equals(a.getAssetStatus())).collect(Collectors.toList());
                        if (DataUtils.isListAvali(normal)) {
                            peopelSpaceNumber += 1;
                        } else {
                            noPeopelSpaceNumber += 1;
                        }
                    }
                }
            }
            result.setTotalNumber(totalNumber);
            result.setNoPeopelSpaceNumber(noPeopelSpaceNumber);
            result.setPeopelSpaceNumber(peopelSpaceNumber);
            response.setData(result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 门磁-空间列表
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.seer.QueryInductionListDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/24 16:27
     */
    @Override
    public BaseResponse<List<QueryInductionListDTO>> queryInductionList(QueryInductionListQuDTO query, IFWUser user) {
        BaseResponse<List<QueryInductionListDTO>> response = new BaseResponse<>();
        ArrayList<QueryInductionListDTO> resultList = new ArrayList<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            if (DataUtils.isListAvali(query.getMonitorMetricTargetId()) || DataUtils.isListAvali(query.getDataPointId()) || DataUtils.isListAvali(query.getMonitorMetricTargetId())) {
                //查询监测指标
                List<QueryEnvironmentListDoBO> environmentList = monitorRepository.queryMonitorMetricList(IFWBeanCopyUtil.map(query, QueryMonitorMetricListDoBO.class));
                if (environmentList != null) {
                    Map<String, List<QueryEnvironmentListDoBO>> monitorMetricMap = environmentList.stream().collect(Collectors.groupingBy(QueryEnvironmentListDoBO::getProjectSpaceId));
                    for (Map.Entry<String, List<QueryEnvironmentListDoBO>> spaceInfo : monitorMetricMap.entrySet()) {
                        QueryInductionListDTO result = new QueryInductionListDTO();
                        result.setSpaceId(spaceInfo.getKey());
                        result.setTotalNumber(spaceInfo.getValue().size());
                        ArrayList<String> spaceIds = new ArrayList<>();
                        spaceIds.add(spaceInfo.getKey());
                        GetNewPathBatchQueryBO getNewPathBatchQueryBO = new GetNewPathBatchQueryBO();
                        getNewPathBatchQueryBO.setProjectSpaceId(spaceIds);
                        getNewPathBatchQueryBO.setProjectId(query.getProjectId());
                        getNewPathBatchQueryBO.setLanguageCode(query.getLanguageCode());
                        getNewPathBatchQueryBO.setTenantId(tenantId);
                        List<ProjectSpacePathBO> newPathBatch = spaceRepository.getNewPathBatch(getNewPathBatchQueryBO);
                        if (DataUtils.isListAvali(newPathBatch)) {
                            result.setSpaceName(newPathBatch.get(0).getNameStr());
                        }
                        List<QueryEnvironmentListDoBO> use = spaceInfo.getValue().stream().filter(status -> "2".equals(status.getMonitorMetricStatusId())).collect(Collectors.toList());
                        if (DataUtils.isListAvali(use)) {
                            result.setUseNumber(use.size());
                        } else {
                            result.setUseNumber(0);
                        }
                        resultList.add(result);
                    }
                }
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 能耗-能耗统计
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/27 10:41
     */
    @Override
    public BaseResponse<QueryEnergyStatisticsDTO> queryEnergyStatistics(QueryEnergyStatisticsQuDTO query, IFWUser user) {
        BaseResponse<QueryEnergyStatisticsDTO> response = new BaseResponse<>();
        QueryEnergyStatisticsDTO result = new QueryEnergyStatisticsDTO();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            //查询appId
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            //获取昨天和今天的开始时间和结束时间
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startTime = DataUtils.getDayBegin();
            Date endTime = DataUtils.getDayEnd();
            Date YesterdayStartTime = DataUtils.getBeginDayOfYesterday();
            Date YesterdayEndTime = DataUtils.getEndDayOfYesterDay();
            //查询总的数据
            BigDecimal todayEnergyNumber = new BigDecimal("0");
            BigDecimal yesterdayEnergyNumber = new BigDecimal("0");
            if (DataUtils.isListAvali(query.getDataPointInfo())) {
                //按照指标查询
                for (QueryEnergyStatisticsBasisQuDTO dataPointId : query.getDataPointInfo()) {
                    //查询今天的数据
                    MetricValueRecordListReqBO todayQuery = new MetricValueRecordListReqBO();
                    todayQuery.setDataPointId(dataPointId.getDataPointId());
                    todayQuery.setAppId(queryAppIdBO.getAppId());
                    todayQuery.setStartTime(startTime);
                    todayQuery.setEndTime(endTime);
                    MetricValueRecordListBO nowGodzillaInfo = godzillaServerRepository.queryMetricValueRecordList(todayQuery);
                    MetricValueRecordListReqBO yesterdayQuery = new MetricValueRecordListReqBO();
                    yesterdayQuery.setDataPointId(dataPointId.getDataPointId());
                    yesterdayQuery.setAppId(queryAppIdBO.getAppId());
                    yesterdayQuery.setStartTime(YesterdayStartTime);
                    yesterdayQuery.setEndTime(YesterdayEndTime);
                    MetricValueRecordListBO yesterdayInfo = godzillaServerRepository.queryMetricValueRecordList(yesterdayQuery);
                    //按照不同的统计方式来统计数值
                    if ("2".equals(dataPointId)) {
                        //数据最后一条减去第一条
                        if (nowGodzillaInfo != null) {
                            if (DataUtils.isListAvali(nowGodzillaInfo.getCollectDataList())) {
                                //获取第一条数据和最后一条数据，
                                GodzillaInfoBO godzillaInfoBO = nowGodzillaInfo.getCollectDataList().get(0);
                                GodzillaInfoBO godzillaInfoBO1 = nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                                log.info("第一条数据为:" + godzillaInfoBO);
                                log.info("最后一条条数据为:" + godzillaInfoBO1);
                                //获取值
                                BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                                BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                                log.info("第一条数据值为:" + vaule1);
                                log.info("最后一条条数据值为:" + vaule2);
                                //获取第一条数据的时间
                                TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                                LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                                int hour1 = isoTime1.getHour();
                                //获取第二条数据的时间
                                TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                                LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                                int hour2 = isoTime2.getHour();
                                //若开始和结束的值相等，则取开始的值
                                if (vaule1.equals(vaule2)) {
                                    todayEnergyNumber = todayEnergyNumber.add(vaule1);
                                } else if (!vaule1.equals(vaule2)) {
                                    if (hour1 > hour2) {
                                        todayEnergyNumber = todayEnergyNumber.add(vaule1.subtract(vaule2));
                                    }
                                    if (hour1 < hour2) {
                                        todayEnergyNumber = todayEnergyNumber.add(vaule2.subtract(vaule1));
                                    }
                                }
                            }
                        }
                        if (yesterdayInfo != null) {
                            if (DataUtils.isListAvali(yesterdayInfo.getCollectDataList())) {
                                //获取第一条数据和最后一条数据，
                                GodzillaInfoBO godzillaInfoBO = yesterdayInfo.getCollectDataList().get(0);
                                GodzillaInfoBO godzillaInfoBO1 = yesterdayInfo.getCollectDataList().get(yesterdayInfo.getCollectDataList().size() - 1);
                                log.info("第一条数据为:" + godzillaInfoBO);
                                log.info("最后一条条数据为:" + godzillaInfoBO1);
                                //获取值
                                BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                                BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                                log.info("第一条数据值为:" + vaule1);
                                log.info("最后一条条数据值为:" + vaule2);
                                //获取第一条数据的时间
                                TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                                LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                                int hour1 = isoTime1.getHour();
                                //获取第二条数据的时间
                                TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                                LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                                int hour2 = isoTime2.getHour();
                                //若开始和结束的值相等，则取开始的值
                                if (vaule1.equals(vaule2)) {
                                    yesterdayEnergyNumber = yesterdayEnergyNumber.add(vaule1);
                                } else if (!vaule1.equals(vaule2)) {
                                    if (hour1 > hour2) {
                                        yesterdayEnergyNumber = yesterdayEnergyNumber.add(vaule1.subtract(vaule2));
                                    }
                                    if (hour1 < hour2) {
                                        yesterdayEnergyNumber = yesterdayEnergyNumber.add(vaule2.subtract(vaule1));
                                    }
                                }
                            }
                        }
                    }
                    if ("1".equals(dataPointId)) {
                        //数据累加
                        if (nowGodzillaInfo != null) {
                            if (DataUtils.isListAvali(nowGodzillaInfo.getCollectDataList())) {
                                for (GodzillaInfoBO godzillaInfoBO : nowGodzillaInfo.getCollectDataList()) {
                                    log.info("累加数据为:" + godzillaInfoBO);
                                    todayEnergyNumber.add(new BigDecimal(godzillaInfoBO.getValue()));
                                }
                            }
                        }
                        if (yesterdayInfo != null) {
                            if (DataUtils.isListAvali(yesterdayInfo.getCollectDataList())) {
                                for (GodzillaInfoBO godzillaInfoBO : yesterdayInfo.getCollectDataList()) {
                                    log.info("累加数据为:" + godzillaInfoBO);
                                    yesterdayEnergyNumber.add(new BigDecimal(godzillaInfoBO.getValue()));
                                }
                            }
                        }
                    }
                }
            }
            result.setTodayEnergy(todayEnergyNumber);
            result.setYesterdayEnergy(yesterdayEnergyNumber);
            response.setData(result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 能耗-能耗对比曲线
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/27 14:11
     */
    @Override
    public BaseResponse<QueryEnergyComparedGraphDTO> queryEnergyComparedGraph(QueryEnergyComparedGraphQuDTO query, IFWUser user) {
        BaseResponse<QueryEnergyComparedGraphDTO> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            //查询appId
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            if (DataUtils.isListAvali(query.getDataPointId())) {
                for (String dataPointId : query.getDataPointId()) {
                    //查询监控指标
                    MetricValueRecordListReqBO queryList = new MetricValueRecordListReqBO();
                    queryList.setDataPointId(dataPointId);
                    queryList.setAppId(queryAppIdBO.getAppId());
                    queryList.setStartTime(query.getStartTime());
                    queryList.setEndTime(query.getEndTime());
                    MetricValueRecordListBO nowGodzillaInfo = godzillaServerRepository.queryMetricValueRecordList(queryList);

                    if (nowGodzillaInfo != null) {
                        if (DataUtils.isListAvali(nowGodzillaInfo.getCollectDataList())) {
                            for (GodzillaInfoBO godzillaInfoBO : nowGodzillaInfo.getCollectDataList()) {
                                Date date = format.parse(godzillaInfoBO.getTime());
                                QueryEnergyComparedGraphBasisDTO result = new QueryEnergyComparedGraphBasisDTO();
                                if ("1".equals(query.getType())) {
                                    //以小时展示
                                    int hours = date.getHours();
//                                    result.setNumber();
//                                    result.setTime();

                                }
                                if ("2".equals(query.getType())) {
                                    //以天展示

                                }
                                if ("3".equals(query.getType())) {
                                    //以月展示

                                }
                            }

                        }
                    }


                }
            }

            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 上汽-环境统计
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/27 16:19
     */
    @Override
    public BaseResponse<List<QuerySqEnvironmentInfoDTO>> querySqEnvironmentInfo(QuerySqEnvironmentInfoQuDTO query, IFWUser user) {
        BaseResponse<List<QuerySqEnvironmentInfoDTO>> response = new BaseResponse<>();
        ArrayList<QuerySqEnvironmentInfoDTO> resultList = new ArrayList<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            //查询appId
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            Date startTime = DataUtils.getDayBegin();
            Date endTime = DataUtils.getDayEnd();
            if (DataUtils.isListAvali(query.getTagInfo())) {
                for (QuerySqEnvironmentInfoBasisDTO queryInfo : query.getTagInfo()) {
                    //根据标签id查询dataPointId
                    QueryMonitorMetricListDoBO queryMonitorMetricListDoBO = new QueryMonitorMetricListDoBO();
                    queryMonitorMetricListDoBO.setProjectId(query.getProjectId());
                    queryMonitorMetricListDoBO.setMonitorTargetTagId(queryInfo.getMonitorTargetTagId());
                    queryMonitorMetricListDoBO.setLanguageCode(query.getLanguageCode());
                    List<QueryEnvironmentListDoBO> queryEnvironmentListDoBOS = monitorRepository.queryMonitorMetricList(queryMonitorMetricListDoBO);
                    if (queryEnvironmentListDoBOS != null) {
                        List<String> dataPointIds = queryEnvironmentListDoBOS.stream().map(QueryEnvironmentListDoBO::getDataPointId).collect(Collectors.toList());
                        log.info("数据点位为：" + dataPointIds);
                        QuerySqEnvironmentInfoDTO result = new QuerySqEnvironmentInfoDTO();
                        result.setType(queryInfo.getType());
                        BigDecimal number = new BigDecimal(0);
                        //除数
                        int divisor = 0;
                        for (String dataPointId : dataPointIds) {
                            //查询监控指标
                            MetricValueRecordListReqBO queryList = new MetricValueRecordListReqBO();
                            queryList.setDataPointId(dataPointId);
                            queryList.setAppId(queryAppIdBO.getAppId());
                            queryList.setStartTime(startTime);
                            queryList.setEndTime(endTime);
                            MetricValueRecordListBO nowGodzillaInfo = godzillaServerRepository.queryMetricValueRecordList(queryList);
                            if (nowGodzillaInfo != null) {
                                if (DataUtils.isListAvali(nowGodzillaInfo.getCollectDataList())) {
                                    //获取第一条数据和最后一条数据
                                    GodzillaInfoBO godzillaInfoBO = nowGodzillaInfo.getCollectDataList().get(0);
                                    GodzillaInfoBO godzillaInfoBO1 = nowGodzillaInfo.getCollectDataList().get(nowGodzillaInfo.getCollectDataList().size() - 1);
                                    log.info("第一条数据为:" + godzillaInfoBO);
                                    log.info("最后一条条数据为:" + godzillaInfoBO1);
                                    //获取值
                                    BigDecimal vaule1 = new BigDecimal(godzillaInfoBO.getValue());
                                    BigDecimal vaule2 = new BigDecimal(godzillaInfoBO1.getValue());
                                    log.info("第一条数据值为:" + vaule1);
                                    log.info("最后一条条数据值为:" + vaule2);
                                    //获取第一条数据的时间
                                    TemporalAccessor parse1 = RFC3339_FORMATTER.parse(godzillaInfoBO.getTime());
                                    LocalTime isoTime1 = parse1.query(TemporalQueries.localTime());
                                    int hour1 = isoTime1.getHour();
                                    //获取第二条数据的时间
                                    TemporalAccessor parse2 = RFC3339_FORMATTER.parse(godzillaInfoBO1.getTime());
                                    LocalTime isoTime2 = parse2.query(TemporalQueries.localTime());
                                    int hour2 = isoTime2.getHour();
                                    //若开始和结束的值相等，则取开始的值
                                    number = number.add(vaule1);
                                    divisor += 1;
                                }
                            }
                        }
                        if (divisor != 0) {
                            BigDecimal resultNumber = number.divide(new BigDecimal(divisor), 2, BigDecimal.ROUND_HALF_UP);
                            result.setNumber(resultNumber);
                        }
                        resultList.add(result);
                    }
                }
            }
            response.setData(resultList);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    @Override
    public BaseResponse sqDepositSenrtyInfo(SqDepositSenrtyInfoDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            sqDepositSentryInfo();
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    @Override
    public BaseResponse seerTagMove(SeerTagMoveDTO query, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            //查询告警设备
            QueryAssetListQueryBO queryAssetListQueryBO = new QueryAssetListQueryBO();
            queryAssetListQueryBO.setProjectId(query.getProjectId());
            queryAssetListQueryBO.setAssetStatus("2");
            queryAssetListQueryBO.setLanguageCode("CN");
            IFWPageInfo<QueryAssetInfoBO> assetList = assetRepository.queryAssetList(queryAssetListQueryBO);
            if (assetList != null){
                for (QueryAssetInfoBO queryAssetInfoBO : assetList.getList()) {
                    UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                    updateAlarmNumberBO.setType(1);
                    updateAlarmNumberBO.setSpaceId(queryAssetInfoBO.getProjectSpaceId());
                    updateAlarmNumberBO.setAssetId(queryAssetInfoBO.getAssetId());
                    String sendInfo1 = JSONUtils.jacksonToJson(updateAlarmNumberBO);
                    log.info("seer标签统计数量+1，存入数据为：" + sendInfo1);
                    ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
                }
            }
            sqDepositSentryInfo();
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 根据标签查询
     *
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.QueryTagInfoListQuDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/22 15:20
     */
    @Override
    public BaseResponse<List<QueryTagInfoListDTO>> queryTagInfoList(QueryTagInfoListQuDTO query) {
        BaseResponse<List<QueryTagInfoListDTO>> response = new BaseResponse<>();
        try {
            List<QueryTagInfoListDTO> queryTagInfoListBO = targetTagRepository.queryTagInfoList(IFWBeanCopyUtil.map(query,QueryTagInfoListQuBO.class));
            if (DataUtils.isListAvali(queryTagInfoListBO)) {
                response.setData(queryTagInfoListBO);
            }else{
                response.setData(null);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }


    /**
     * 根据监控指标id查询监控信息
     *
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.QueryMonitorListDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/24 16:24
     */
    @Override
    public BaseResponse<List<QueryMonitorListDTO>> queryMetricId(QueryMetricIdDTO query) {
        BaseResponse<List<QueryMonitorListDTO>> response = new BaseResponse<>();
        try {
            IFWPageInfo<QueryMonitorListDoBO> queryTagInfoListBO = monitorRepository.queryMonitorList(IFWBeanCopyUtil.map(query,QueryMonitorListDoQueryBO.class));
            if (queryTagInfoListBO != null) {
                response.setData(IFWBeanCopyUtil.mapAsList(queryTagInfoListBO.getList(),QueryMonitorListDTO.class));
            }else{
                response.setData(null);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 根据dataPointId查询哥斯拉信息
     *
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.sentry.dto.DataPointDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/10/21 14:48
     */
    @Override
    public BaseResponse<List<QueryInfoByDataPointDTO>> queryByDataPoint(QueryMetricIdDTO query) {
        BaseResponse<List<QueryInfoByDataPointDTO>> response = new BaseResponse<>();
        try {
            IFWPageInfo<QueryMonitorListDoBO> queryTagInfoListBO = monitorRepository.queryMonitorList(IFWBeanCopyUtil.map(query,QueryMonitorListDoQueryBO.class));
            if (DataUtils.isListAvali(queryTagInfoListBO.getList())) {
                ArrayList<QueryInfoByDataPointDTO> resultList = new ArrayList<>();
                List<String> spaceIds = queryTagInfoListBO.getList().stream().map(QueryMonitorListDoBO::getProjectSpaceId).collect(Collectors.toList());
                GetNewPathBatchQueryBO queryName = new GetNewPathBatchQueryBO();
                queryName.setProjectSpaceId(spaceIds);
                queryName.setProjectId(query.getProjectId());
                queryName.setLanguageCode(query.getLanguageCode());
                queryName.setTenantId(query.getTenantId());
                List<ProjectSpacePathBO> newPathBatch = spaceRepository.getNewPathBatch(queryName);
                for (QueryMonitorListDoBO monitorIfo : queryTagInfoListBO.getList()) {
                    QueryInfoByDataPointDTO result = new QueryInfoByDataPointDTO();
                    result.setSpaceId(monitorIfo.getProjectSpaceId());
                    ArrayList<DataPointDTO> dataPointDTOS = new ArrayList<>();
                    if (DataUtils.isListAvali(monitorIfo.getGodzillaInfo())) {
                        for (GodzillaBindingInfo id : monitorIfo.getGodzillaInfo()) {
                            DataPointDTO dataPointDTO = new DataPointDTO();
                            dataPointDTO.setDataPointId(id.getDataPointId());
                            QueryRuleAndStartBO queryInfo = new QueryRuleAndStartBO();
                            queryInfo.setDataPointId(id.getDataPointId());
                            QueryRuleAndStartDoBO info = godzillaServerRepository.queryRuleAndStart(queryInfo);
                            if (info != null) {
                                if (!StringUtils.isEmpty(info.getUnit())){
                                    dataPointDTO.setUnit(info.getUnit());
                                }
                                if (!StringUtils.isEmpty(info.getCurrentValue())){
                                    dataPointDTO.setCurrentValue(info.getCurrentValue());
                                }
                            }
                            dataPointDTOS.add(dataPointDTO);
                        }
                    }
                    result.setDataInfo(dataPointDTOS);
                    resultList.add(result);
                }
                if (DataUtils.isListAvali(newPathBatch) && DataUtils.isListAvali(resultList)){
                    for (ProjectSpacePathBO pathBatch : newPathBatch) {
                        for (QueryInfoByDataPointDTO result : resultList) {
                            if (StringUtils.equals(result.getSpaceId(),pathBatch.getId())){
                                result.setSpaceName(pathBatch.getNameStr());
                            }
                        }
                    }
                }
                response.setData(resultList);
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }


    /**
     * 每天零点存入上汽用电、水量折线图
     * 租户id、项目id、类型id写死
     * redis key 为1代表用电  2用水
     *
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.SeerQueryTagDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/4/28 20:32
     */
//    @Scheduled(cron = "0 0 0 * * ?")
    public BaseResponse sqDepositSentryInfo() {
        BaseResponse response = new BaseResponse<>();
        ArrayList<String> queryList = new ArrayList<>();
        queryList.add(waterId);
        queryList.add(electricityId);
//        queryList.add("6f8a607c-bc57-4484-9937-d926da7a2f72");
        try {
            for (String query : queryList) {
                QueryIndexStatisticsDTO result = new QueryIndexStatisticsDTO();
                //查询该标签下有哪些检测对象
                QueryTagInfoListQuBO queryTagInfoList = new QueryTagInfoListQuBO();
                queryTagInfoList.setTagId(query);
                queryTagInfoList.setLanguageCode("CN");
                List<QueryTagInfoListDTO> queryTagInfoListBO = targetTagRepository.queryTagInfoList(queryTagInfoList);
                if (DataUtils.isListAvali(queryTagInfoListBO)) {
                    ArrayList<QueryIndexStatisticsBasisDTO> resultList = new ArrayList<>();
                    ArrayList<QueryIndexStatisticsBasisDTO> resultList2 = new ArrayList<>();
                    for (int i = 0; i < 24; i++) {
                        QueryIndexStatisticsBasisDTO resultDTO = new QueryIndexStatisticsBasisDTO();
                        resultDTO.setTime(i);
                        resultDTO.setValue(new BigDecimal("0"));
                        QueryIndexStatisticsBasisDTO resultDTO1 = new QueryIndexStatisticsBasisDTO();
                        resultDTO1.setTime(i);
                        resultDTO1.setValue(new BigDecimal("0"));
                        resultList.add(resultDTO);
                        resultList2.add(resultDTO1);
                    }
                    //获取昨天、前天的时间
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date beforeYesterdayStartTime = DataUtils.getBeginDayOfBeforeYesterday();
                    Date beforeYesterDayEndTime = DataUtils.getEndDayOfBeforeYesterDay();
                    Date yesterDayStartTime = DataUtils.getBeginDayOfYesterday();
                    Date YesterDayEndTime = DataUtils.getEndDayOfYesterDay();
                    Date DayEndTime = DataUtils.getDayEnd();
                    Date DayStartTime = DataUtils.getDayBegin();
                    //查询总的数据
                    List<QueryTagInfoListDTO> notNullList = queryTagInfoListBO.stream().filter(a -> !StringUtils.isEmpty(a.getDataPointId())).collect(Collectors.toList());
                    //前天最后一条数据
                    BigDecimal beforeYesterday = new BigDecimal("0");
                    BigDecimal yesterday = new BigDecimal("0");
                    List<QueryIndexStatisticsBasisDTO> todayInfo = IFWBeanCopyUtil.mapAsList(resultList, QueryIndexStatisticsBasisDTO.class);
                    List<QueryIndexStatisticsBasisDTO> YesterdayInfo = IFWBeanCopyUtil.mapAsList(resultList, QueryIndexStatisticsBasisDTO.class);
                    //按照指标查询
                    for (QueryTagInfoListDTO queryInfo : notNullList) {
                        //查询前天的数据
                        MetricValueRecordListReqBO metricValueRecordListReqBO = new MetricValueRecordListReqBO();
                        metricValueRecordListReqBO.setDataPointId(queryInfo.getDataPointId());
                        metricValueRecordListReqBO.setAppId(appId);
                        metricValueRecordListReqBO.setStartTime(beforeYesterdayStartTime);
                        metricValueRecordListReqBO.setEndTime(beforeYesterDayEndTime);
//                        metricValueRecordListReqBO.setDataPointId("d7828a77b80b4049a4f0a420b4cc34ae");
//                        metricValueRecordListReqBO.setAppId("c76e55827c5441f984fffaaf066a0742");
                        log.info("查询前天数据入参：" + metricValueRecordListReqBO);
                        MetricValueRecordListBO nowGodzillaInfo = godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBO);
                        log.info("查询出昨日数据：" + nowGodzillaInfo);
                        //查询昨天的数据
                        MetricValueRecordListReqBO metricValueRecordListReqBOOne = new MetricValueRecordListReqBO();
                        metricValueRecordListReqBOOne.setDataPointId(queryInfo.getDataPointId());
                        metricValueRecordListReqBOOne.setAppId(appId);
//                        metricValueRecordListReqBOOne.setDataPointId("d7828a77b80b4049a4f0a420b4cc34ae");
//                        metricValueRecordListReqBOOne.setAppId("c76e55827c5441f984fffaaf066a0742");
                        metricValueRecordListReqBOOne.setStartTime(yesterDayStartTime);
                        metricValueRecordListReqBOOne.setEndTime(YesterDayEndTime);
                        log.info("查询昨日数据入参：" + metricValueRecordListReqBOOne);
                        MetricValueRecordListBO godzillaInfoBOS = godzillaServerRepository.queryMetricValueRecordList(metricValueRecordListReqBOOne);
                        log.info("查询出昨日数据：" + godzillaInfoBOS);
                        MetricValueRecordListReqBO nowQuery = new MetricValueRecordListReqBO();
                        nowQuery.setDataPointId(queryInfo.getDataPointId());
                        nowQuery.setAppId(appId);
//                        nowQuery.setDataPointId("d7828a77b80b4049a4f0a420b4cc34ae");
//                        nowQuery.setAppId("c76e55827c5441f984fffaaf066a0742");
                        nowQuery.setStartTime(DayStartTime);
                        nowQuery.setEndTime(DayEndTime);
                        log.info("查询今日数据入参：" + nowQuery);
                        MetricValueRecordListBO nowGodzillaInfoBOS = godzillaServerRepository.queryMetricValueRecordList(nowQuery);
                        log.info("查询出今日数据：" + nowGodzillaInfoBOS);
                        //需要先查询出前日数据（昨日的0点数据需要昨天1点数据减去前天23点数据）
                        if (nowGodzillaInfo != null) {
                            //查询前天数据
                            if (DataUtils.isListAvali(nowGodzillaInfo.getCollectDataList())) {
                                //以小时数为单位  把每小时的数量累加
                                for (GodzillaInfoBO today : nowGodzillaInfo.getCollectDataList()) {
                                    TemporalAccessor parse = RFC3339_FORMATTER.parse(today.getTime());
                                    LocalTime isoTime = parse.query(TemporalQueries.localTime());
                                    int hour = isoTime.getHour();
                                    BigDecimal value = new BigDecimal(today.getValue());
                                    if (hour == 23) {
                                        beforeYesterday.add(value);
                                    }
                                }
                            }
                        }
                        log.info("前天数据：" + beforeYesterday);
                        //查询出昨日数据
                        if (godzillaInfoBOS != null) {
                            //查询昨天数据
                            if (DataUtils.isListAvali(godzillaInfoBOS.getCollectDataList())) {
                                //以小时数为单位  把每小时的数量累加
                                for (int i = 0; i < 24; i++) {
                                    for (GodzillaInfoBO today : godzillaInfoBOS.getCollectDataList()) {
                                        TemporalAccessor parse = RFC3339_FORMATTER.parse(today.getTime());
                                        LocalTime isoTime = parse.query(TemporalQueries.localTime());
                                        int hour = isoTime.getHour();
                                        BigDecimal value = new BigDecimal(today.getValue());
                                        if (hour == i) {
                                            log.info("dataPointId为：" + today.getDataPointId() + ",在第" + hour + "小时的值为：" + value);
                                            resultList2.get(i).setValue(resultList2.get(i).getValue().add(value));
                                            log.info("dataPointId为：" + today.getDataPointId() + "相加后的值为" + resultList.get(i).getValue());
                                        }
                                        if (hour == 23) {
                                            yesterday.add(value);
                                        }
                                    }
                                    //（今日的0点数据需要1点数据减去昨天23点数据）
                                    if (i == 0) {
                                        //当计算出来的数值小于0则设置为0
                                        if (resultList2.get(i).getValue().subtract(beforeYesterday).compareTo(new BigDecimal("0")) == -1) {
                                            YesterdayInfo.get(i).setValue(new BigDecimal("0"));
                                            log.info("数据相减为负数");
                                        } else {
                                            YesterdayInfo.get(i).setValue(resultList2.get(i).getValue().subtract(beforeYesterday));
                                            log.info("数据相加为：" + YesterdayInfo.get(i));
                                        }

                                    } else {
                                        //当计算出来的数值小于0则设置为0
                                        if (resultList2.get(i).getValue().subtract(resultList2.get(i - 1).getValue()).compareTo(new BigDecimal("0")) == -1) {
                                            todayInfo.get(i).setValue(new BigDecimal("0"));
                                            log.info("数据相减为负数");
                                        } else {
                                            YesterdayInfo.get(i).setValue(resultList2.get(i).getValue().subtract(resultList2.get(i - 1).getValue()));
                                            log.info("数据相加为：" + YesterdayInfo.get(i));
                                            log.info("数据点：" + queryInfo.getDataPointId() );
                                        }

                                    }
                                    log.info("第" + i + "小时计算结束，值为" + YesterdayInfo.get(i).getValue());
                                }
                            }
                        }
                        if (nowGodzillaInfoBOS != null) {
                            //查询今天数据
                            if (DataUtils.isListAvali(nowGodzillaInfoBOS.getCollectDataList())) {
                                for (int i = 0; i < 24; i++) {
                                    for (GodzillaInfoBO today : nowGodzillaInfoBOS.getCollectDataList()) {
                                        TemporalAccessor parse = RFC3339_FORMATTER.parse(today.getTime());
                                        LocalTime isoTime = parse.query(TemporalQueries.localTime());
                                        int hour = isoTime.getHour();
                                        BigDecimal value = new BigDecimal(today.getValue());
                                        if (hour == i) {
                                            log.info("dataPointId为：" + today.getDataPointId() + ",在第" + hour + "小时的值为：" + value);
                                            //拿到该小时的对象设置值
                                            resultList.get(i).setValue(resultList.get(i).getValue().add(value));
                                            log.info("dataPointId为：" + today.getDataPointId() + "相加后的值为" + resultList.get(i).getValue());
                                        }
                                    }
                                    if (i == 0) {
                                        //当计算出来的数值小于0则设置为0
                                        if (resultList.get(0).getValue().subtract(yesterday).compareTo(new BigDecimal("0")) == -1) {
                                            todayInfo.get(i).setValue(new BigDecimal("0"));
                                            log.info("数据相减为负数");
                                        } else {
                                            todayInfo.get(i).setValue(resultList.get(0).getValue().subtract(yesterday));
                                            log.info("数据相加为：" + todayInfo.get(i));
                                        }
                                    } else {
                                        //当计算出来的数值小于0则设置为0
                                        if (resultList.get(i).getValue().subtract(resultList.get(i - 1).getValue()).compareTo(new BigDecimal("0")) == -1) {
                                            todayInfo.get(i).setValue(new BigDecimal("0"));
                                            log.info("数据相减为负数");
                                        } else {
                                            todayInfo.get(i).setValue(resultList.get(i).getValue().subtract(resultList.get(i - 1).getValue()));
                                            log.info("数据相加为：" + todayInfo.get(i));
                                            log.info("数据点：" + queryInfo.getDataPointId() );
                                        }
                                    }
                                    log.info("第" + i + "小时计算结束，值为" + todayInfo.get(i).getValue());
                                }
                            }
                        }
                    }
                    result.setTodayIndexInfo(todayInfo);
                    result.setYesterdayIndexInfo(YesterdayInfo);
                    if (query.equals(electricityId)) {
                        //电
                        redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getCameraCountInfoType("1"), result);
                        log.info("存入用电量成功！" + result);
                    }
                    if (query.equals(waterId)) {
                        //水
                        redisTemplate.opsForValue().set(RedisKeyPrefixUtil.getCameraCountInfoType("2"), result);
                        log.info("存入用水量成功！" + result);
                    }
                }
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }


    public static void main(String[] args) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long nowTime = System.currentTimeMillis();
        long Tenminute = nowTime - 600000;  Long timeStamp = System.currentTimeMillis();  //获取当前时间戳
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = sdf.format(new Date(Long.parseLong(String.valueOf(nowTime))));      // 时间戳转换成时间
        String ten = sdf.format(new Date(Long.parseLong(String.valueOf(Tenminute))));

        System.out.println(now);
        System.out.println(ten);
    }

}


