package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.MessageTypeConstants;
import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.kafka.TopicConstants;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.GetDataPointBasisOneQueryDTO;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.app.UpdateAppIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.QueryAllDataPointDTO;
import com.ifourthwall.dbm.asset.dto.metric.QueryAllDataPointQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListQuBasisDTO;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.asset.facade.MonitorMetricFacade;
import com.ifourthwall.dbm.message.facade.dto.PushMessageReqDTO;
import com.ifourthwall.dbm.message.facade.dto.QueryMessageConfigReqDTO;
import com.ifourthwall.dbm.message.facade.dto.QueryMessageConfigResDTO;
import com.ifourthwall.dbm.message.facade.service.MessageServiceFacade;
import com.ifourthwall.dbm.project.dto.project.QueryCountryIdDTO;
import com.ifourthwall.dbm.project.dto.project.QueryCountryIdQuDTO;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.alarm.*;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameReqDoBO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameResDoBO;
import com.ifourthwall.dbm.sentry.constant.TaskSourceEnum;
import com.ifourthwall.dbm.sentry.domain.*;
import com.ifourthwall.dbm.sentry.service.MonitorAlarmService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.dbm.sentry.util.TimeUtils;
import com.ifourthwall.kafka.IFWKafkaClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: YangPeng
 * @Date: 2020/9/15 14:03
 * @Description:
 */
@Slf4j
@Service("MonitorAlarmServiceImpl")
public class MonitorAlarmServiceImpl implements MonitorAlarmService {

    /**
     * 启用告警
     */
    public static final String ENABLE_ALARM = "1";
    /**
     * 关闭告警
     */
    public static final String DISABLE_ALARM = "0";


    public static final String ASIA_TOKYO = "JST";
    public static final String ASIA_SHANGHAI = "CTT";
    public static final String EUROPE_PARIS = "CST";

    @Autowired
    private RedisTemplate redisTemplate;

    @Reference(version = "1.0.0")
    private MonitorFacade monitorFacade;

    @Reference(version = "1.0.0")
    private MonitorMetricFacade monitorMetricFacade;

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;

    @Resource(name = "ProjectRepository")
    private ProjectRepository projectRepository;

    @Resource(name = "AssetRepository")
    private AssetRepository assetRepository;

    @Resource(name = "SpaceRepository")
    private SpaceRepository spaceRepository;

    @Resource(name = "TaskRepository")
    private TaskRepository taskRepository;

    @Resource(name = "UserRepository")
    private UserRepository userRepository;

    @Reference(version = "1.0.0")
    private MessageServiceFacade messageServiceFacade;

    @Value("${robot.system.id}")
    private String robotId;

    @Value("${callback.url}")
    private String callbackUrl;

    @Value("${callback.token}")
    private String callbackToken;

    @Value("${robot.system.position.id}")
    private String robotPositionId;

    @Autowired
    private GodzillaServerRepository godzillaServerRepository;


    //指定客户端  IFWKafkaClient-topicName
    @Resource(name = "IFWKafkaClient-" + TopicConstants.dbmSentryCreateTask)
    private IFWKafkaClient ifwKafkaClientCreateTask;

    //当有自动告警发生时，把该空间的告警数+1 或-1
    @Resource(name = "IFWKafkaClient-" + TopicConstants.DBM_SENTRY_UPDATE_SPACE_SPECIAL_ALARM_NUM)
    private IFWKafkaClient ifwKafkaClientUpdateAlarmNumber;

    /**
     * 接收哥斯拉告警信息
     *
     * @param dataPointBasis
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/15 14:03
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse getDataPoint(GetDataPointBasisOneQueryDTO dataPointBasis) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date());
        log.info("接收到哥斯拉告警信息，状态为：{}" + dataPointBasis.getDataPointStatus() + "," + "AlertId为：{}" + dataPointBasis.getAlertId());
        //该功能分为两接口，第一个为插入数据（不插入任务工单），若有自动发工单功能，则往kafka里面扔消息；
        // 第二个当kafka消费完数据以后，更新插入工单；
        BaseResponse response = new BaseResponse<>();
        try {
            //jison转换
            Map message = JSONUtils.jacksonFromJson(dataPointBasis.getMessage(), HashMap.class);
            log.info("json转换" + message);
            ArrayList<PushMessageReqDTO> pushMessageReqDTOS = new ArrayList<>();
            //查询是否存在alertId
            QueryAlertIdDoBO queryAlertId = new QueryAlertIdDoBO();
            queryAlertId.setAlertId(dataPointBasis.getAlertId());
            queryAlertId.setLanguageCode("CN");
            Boolean alertId = monitorRepository.queryAlertId(queryAlertId);
            log.info("该AlertId是否存在：" + alertId);
            if (!alertId) {
                SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                //查询teantId
                QueryTenantIdDoQueryBO queryTenantId = new QueryTenantIdDoQueryBO();
                queryTenantId.setDataPointId(dataPointBasis.getDataPointId());
                QueryTenantIdBO tenantId = monitorRepository.queryTenantId(queryTenantId);
                IFWValidator.validate(tenantId);
                //根据monitorTargetId查询assetId、工单模板id、是否自动发起工单
                QueryMonitorInfoQueryBasisDoBO query = new QueryMonitorInfoQueryBasisDoBO();
                ArrayList<String> monitorTargetId = new ArrayList<>();
                monitorTargetId.add(tenantId.getMonitorTargetId());
                query.setTenantId(tenantId.getTenantId());
                query.setMonitorTargetId(monitorTargetId);
                query.setLanguageCode("CN");
                QueryMonitorInfoDoBO monitorInfo = monitorRepository.queryMonitorInfo(query);
                log.info("查询出监控对象信息 ：" + monitorInfo);
                //查询空间名字
                GetNewPathBatchQueryBO querySpaceName = new GetNewPathBatchQueryBO();
                ArrayList<String> spaceId = new ArrayList<>();
                spaceId.add(monitorInfo.getSpaceId());
                querySpaceName.setProjectId(monitorInfo.getProjectId());
                querySpaceName.setProjectSpaceId(spaceId);
                querySpaceName.setLanguageCode("CN");
                List<ProjectSpacePathBO> newPathBatch = spaceRepository.getNewPathBatch(querySpaceName);
                log.info("查询空间：" + newPathBatch);
                QueryMessageConfigReqDTO queryMessageConfigReqDTO = new QueryMessageConfigReqDTO();
                queryMessageConfigReqDTO.setProjectId(monitorInfo.getProjectId());
                queryMessageConfigReqDTO.setMessageType(MessageTypeConstants.MESSAGE_TYPE_SENTRY);
                queryMessageConfigReqDTO.setLanguageCode("CN");
                queryMessageConfigReqDTO.setTenantId(tenantId.getTenantId());
                log.info("查询告警人员信息：" + queryMessageConfigReqDTO);
                BaseResponse<List<QueryMessageConfigResDTO>> listBaseResponse = messageServiceFacade.queryMessageTemplateConfig(queryMessageConfigReqDTO);
                log.info("返回告警人员信息：" + listBaseResponse);
                queryDataPointIdQuBO queryDataPointIdQuBO = new queryDataPointIdQuBO();
                queryDataPointIdQuBO.setDataPointId(dataPointBasis.getDataPointId());
                queryDataPointIdQuBO.setLanguageCode("CN");
                queryDataPointIdQuBO.setTenantId(tenantId.getTenantId());
                queryDataPointIdBO queryDataPointIdBO = monitorRepository.queryDataPointId(queryDataPointIdQuBO);
                GetProjectSpaceInfoQueryBO getProjectSpaceInfoQueryBO = new GetProjectSpaceInfoQueryBO();
                getProjectSpaceInfoQueryBO.setTenantId(tenantId.getTenantId());
                getProjectSpaceInfoQueryBO.setProjectId(monitorInfo.getProjectId());
                getProjectSpaceInfoQueryBO.setLanguageCode("CN");
                QueryProjectPagePO projectSpaceInfo = projectRepository.getProjectSpaceInfo(getProjectSpaceInfoQueryBO);
                //查询默认告警规则
                QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
                queryAppIdQueryDoBO.setTenantId(tenantId.getTenantId());
                QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppIdQueryDoBO);
                //查询告警生效时间
                boolean send = false;
                QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                queryRuleAndStartBO.setDataPointId(dataPointBasis.getDataPointId());
                QueryRuleAndStartDoBO queryRuleAndStartDoBO = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                if (queryRuleAndStartDoBO != null && queryAppIdBO != null) {
                    String ruleId = null;
                    String[] ruleIds = queryRuleAndStartDoBO.getAlarmRuleId().split(",");
                    for (String id : ruleIds) {
                        if (!id.equals(queryAppIdBO.getDefaultAlarmRuleId())){
                            ruleId = id;
                        }
                    }
                    if (ruleId != null) {
                        QueryAlarmRuleDetailBO queryAlarmRuleDetailBO = new QueryAlarmRuleDetailBO();
                        queryAlarmRuleDetailBO.setAlarmRuleId(ruleId);
                        AlarmRuleBO alarmRuleBO = godzillaServerRepository.queryAlarmRuleDetail(queryAlarmRuleDetailBO);
                        if (alarmRuleBO != null && !StringUtils.isEmpty(alarmRuleBO.getValidTime())) {
                            //拆分时间
                            SimpleDateFormat formatHours = new SimpleDateFormat("HH:mm");
                            String[] split = alarmRuleBO.getValidTime().split(",");
                            log.info("逗号拆分结果：" + split);
                            for (String s : split) {
                                if (!StringUtils.isEmpty(s)) {
                                    String[] split1 = s.split("-");
                                    log.info("杠号拆分结果：" + split1);
                                    String start = split1[0];
                                    String end = split1[1];
                                    Date startTime = formatHours.parse(start);
                                    Date endTime = formatHours.parse(end);
                                    Date nowTime = format.parse(format.format(new Date()));
                                    log.info("查询时间段：" + nowTime + "," + startTime + "," + endTime );
                                    boolean effectiveDate = TimeUtils.isEffectiveDate(nowTime, startTime, endTime);
                                    log.info("查询结果：" + effectiveDate);
                                    if (!effectiveDate) {
                                        send = true;
                                        log.info("不在告警区间内");
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                if (monitorInfo != null) {
                    //先判断告警状态 alerting为产生告警 ok为设备从异常变为正常
                    if (dataPointBasis.getDataPointStatus().equals("alerting")) {
                        if (!send) {
                            //存入数据
                            GetDataPointQueryDoBO insertDataPoint = new GetDataPointQueryDoBO();
                            StringBuilder stringBuilder = new StringBuilder();
                            BeanUtils.copyProperties(dataPointBasis.getMessage(), insertDataPoint);
                            insertDataPoint.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                            insertDataPoint.setAssetId(monitorInfo.getAssetId());
                            insertDataPoint.setProjectId(monitorInfo.getProjectId());
                            insertDataPoint.setTenantId(tenantId.getTenantId());
                            insertDataPoint.setAlertId(dataPointBasis.getAlertId());
                            insertDataPoint.setCreateBy(robotId);
                            insertDataPoint.setMessage(dataPointBasis.getMessage());
//                        insertDataPoint.setDataPointId(dataPointBasis.getDataPointId());
//                        insertDataPoint.setDataPointStatus(dataPointBasis.getDataPointStatus());
//                        insertDataPoint.setCollectTime(dataPointBasis.getCollectTime());
//                        insertDataPoint.setValue(stringBuilder.append(dataPointBasis.getValue()).append(dataPointBasis.getDataPointUnit()).toString());
////                        Timestamp timestamp = new Timestamp((Long) message.get("collectTime")/1000000);
//                        Instant instant = timestamp.toInstant();
//                        Date collectTime = Date.from(instant);
//                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            insertDataPoint.setMessage((String) message.get("message"));
                            insertDataPoint.setDataPointId((String) message.get("dataPointId"));
                            insertDataPoint.setDataPointStatus((String) message.get("dataPointStatus"));
                            insertDataPoint.setCollectTime((String) message.get("collectTime"));
                            insertDataPoint.setValue(stringBuilder.append(message.get("value")).append(dataPointBasis.getDataPointUnit()).toString());
                            if ("1".equals(monitorInfo.getAutoCreateTemporaryTaskId())) {
                                insertDataPoint.setTaskStatusId("4");
                            } else if ("0".equals(monitorInfo.getAutoCreateTemporaryTaskId())) {
                                insertDataPoint.setTaskStatusId("1");
                            }
                            monitorRepository.insetMonitorRecord(insertDataPoint);
                            log.info("信息存入成功，是否自动发送工单 ：" + monitorInfo.getAutoCreateTemporaryTaskId());
                            if ("0".equals(monitorInfo.getAutoCreateTemporaryTaskId())) {
                                log.info("自动发送工单创建中");
                                //查询项目所属国家
                                QueryCountryIdQuDTO queryCountryIdQuDTO = new QueryCountryIdQuDTO();
                                queryCountryIdQuDTO.setTenantId(tenantId.getTenantId());
                                queryCountryIdQuDTO.setLanguageCode("CN");
                                queryCountryIdQuDTO.setProjectId(monitorInfo.getProjectId());
                                QueryCountryIdDTO queryCountryIdDTO = projectRepository.queryCountryId(queryCountryIdQuDTO);

                                KafkaAlertBO kafkaAlertBO = new KafkaAlertBO();
                                CreateTaskQueryDTO query1 = new CreateTaskQueryDTO();
                                TaskInsertDoBO taskQuery = new TaskInsertDoBO();
                                ArrayList<TaskSpaceInsertBO> taskSpaceInfo = new ArrayList<>();
                                TaskSpaceInsertBO taskSpace = new TaskSpaceInsertBO();
                                taskSpace.setSpaceId(monitorInfo.getSpaceId());
                                taskSpace.setTaskSpaceDescription(newPathBatch.get(0).getNameStr());
                                taskSpaceInfo.add(taskSpace);
                                ArrayList<String> operatingId = new ArrayList<>();
                                operatingId.add(robotPositionId);
                                taskQuery.setCreateByPositionId(robotPositionId);
                                taskQuery.setTenantId(tenantId.getTenantId());
                                taskQuery.setProjectId(monitorInfo.getProjectId());
                                taskQuery.setTaskTypeId("1");
                                taskQuery.setCreateBy(robotId);
                                taskQuery.setTaskTemplateId(monitorInfo.getTaskTemplateId());
                                taskQuery.setTaskSource(TaskSourceEnum.SENTRY.getId());
                                if (queryCountryIdDTO.getCountryId() == null || queryCountryIdDTO.getCountryId() == 1) {
                                    String time = TimeUtils.TimeChange(new Date(), "CN");
                                    //中文模板
                                    taskQuery.setTaskName("Sentry告警");
                                    taskQuery.setTaskDescription("采集值(抄表值)：" + dataPointBasis.getValue() + "告警值：" + dataPointBasis.getValue() + "告警内容:" + (String) message.get("message") +
                                            "; 告警时间:" + time);
                                } else if (queryCountryIdDTO.getCountryId() == 2) {
                                    String time = TimeUtils.TimeChange(new Date(), "JP");
                                    //日文模板
                                    taskQuery.setTaskName("sentryアラーム");
                                    taskQuery.setTaskDescription("収集値（メーター値）：" + dataPointBasis.getValue() + "アラーム詳細：" + dataPointBasis.getValue() + "アラーム情報:" + (String) message.get("message") +
                                            "; アラーム時間:" + time);
                                } else {
                                    String time = TimeUtils.TimeChange(new Date(), "EN");
                                    //英文模板
                                    taskQuery.setTaskName("Sentry Alert");
                                    taskQuery.setTaskDescription("Collected value (read meter value)：" + dataPointBasis.getValue() + "Value：" + dataPointBasis.getValue() + "Message:" + (String) message.get("message") +
                                            "; Time:" + time);
                                }
                                taskQuery.setCreateByPositionId(robotPositionId);
                                query1.setTask(taskQuery);
                                ArrayList<String> assetIds = new ArrayList<>();
                                assetIds.add(monitorInfo.getAssetId());
                                query1.setAssetIdList(assetIds);
                                //往kafka扔消息
                                kafkaAlertBO.setAlertId(dataPointBasis.getAlertId());
                                kafkaAlertBO.setTaskBO(query1);
                                kafkaAlertBO.getTaskBO().setTaskSpaceList(taskSpaceInfo);
                                String sendInfo = JSONUtils.jacksonToJson(kafkaAlertBO);
                                log.info("自动创建工单，kafka发送数据" + sendInfo);
                                ifwKafkaClientCreateTask.syncProduce(sendInfo);
                            }
                            //更新该空间的告警数量
                            UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                            updateAlarmNumberBO.setType(1);
                            updateAlarmNumberBO.setSpaceId(monitorInfo.getSpaceId());
                            updateAlarmNumberBO.setAssetId(monitorInfo.getAssetId());
                            String sendInfo1 = JSONUtils.jacksonToJson(updateAlarmNumberBO);
                            log.info("seer标签统计数量+1，存入数据为：" + sendInfo1);
                            ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
                            log.info("seer标签统计数量+1，空间为：" + monitorInfo.getSpaceId());
                            //消息中心
                            //-------------------------------------------消息推送---------------------------------------------
                            if (DataUtils.isListAvali(listBaseResponse.getData())) {
                                log.info("发送消息中心中...");
                                for (QueryMessageConfigResDTO pushInfo : listBaseResponse.getData()) {
                                    log.info("告警人信息：" + pushInfo);
                                    PushMessageReqDTO pushMessageReqDTO = new PushMessageReqDTO();
                                    pushMessageReqDTO.setTenantId(tenantId.getTenantId());
                                    pushMessageReqDTO.setToUserId(pushInfo.getUserId());
                                    PushMessageSentryBO pushMessageSentryBO = new PushMessageSentryBO();
                                    pushMessageSentryBO.setTime(timeFormat.format(new Date()));
                                    pushMessageSentryBO.setAssetName(monitorInfo.getAssetName());
                                    if (queryDataPointIdBO != null) {
                                        pushMessageSentryBO.setMonitorMetricName(queryDataPointIdBO.getMonitorMetricName());
                                    }
                                    pushMessageSentryBO.setSpaceName(newPathBatch.get(0).getNameStr());
                                    pushMessageSentryBO.setSpaceId(monitorInfo.getSpaceId());
                                    pushMessageSentryBO.setMessageInfo((String) message.get("message"));
                                    pushMessageSentryBO.setMessageInfo((String) message.get("message"));
                                    pushMessageSentryBO.setSentryStatus(dataPointBasis.getDataPointStatus());
                                    if (projectSpaceInfo != null && projectSpaceInfo.getProjectName() != null) {
                                        pushMessageSentryBO.setProjectName(projectSpaceInfo.getProjectName());
                                    }
                                    pushMessageSentryBO.setMessageType(MessageTypeConstants.MESSAGE_TYPE_SENTRY);
                                    pushMessageSentryBO.setProjectId(monitorInfo.getProjectId());
                                    pushMessageSentryBO.setAssetId(monitorInfo.getAssetId());
                                    pushMessageSentryBO.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                                    pushMessageSentryBO.setDataPointId(dataPointBasis.getDataPointId());
                                    String sendMessage = JSONUtils.jacksonToJson(pushMessageSentryBO);
                                    pushMessageReqDTO.setPushContent(sendMessage);
                                    pushMessageReqDTO.setGodzillaDeviceTypes("0,2");
                                    pushMessageReqDTO.setMessageType(MessageTypeConstants.MESSAGE_TYPE_SENTRY);
                                    pushMessageReqDTO.setProjectId(monitorInfo.getProjectId());
                                    pushMessageReqDTOS.add(pushMessageReqDTO);
                                }
                            } else {
                                log.info("未配置消息发送！");
                            }
                        }
                    }
                    if (dataPointBasis.getDataPointStatus().equals("ok")) {
                        //查询资产id
                        QueryAssetByDPDoQuBO queryAsset = new QueryAssetByDPDoQuBO();
                        queryAsset.setDataPointId(dataPointBasis.getDataPointId());
                        QueryAssetByDPDoBO assetId = monitorRepository.queryAssetByDP(queryAsset);
                        //查询资产信息
                        AssetInfoQueryDoBO queryAssetInfo = new AssetInfoQueryDoBO();
                        queryAssetInfo.setAssetId(assetId.getAssetId());
                        queryAssetInfo.setLanguageCode("CN");
                        QueryAssetInfoDoBO queryAssetInfoDoBO = assetRepository.queryAssetInfo(queryAssetInfo);
                        log.info("查询到资产信息" + queryAssetInfoDoBO);
                        //更改资产状态
                        UpAssetStatusDoBO upAssetStatusDoBO = new UpAssetStatusDoBO();
                        upAssetStatusDoBO.setCollectTime(dataPointBasis.getCollectTime());
                        upAssetStatusDoBO.setAlertId(dataPointBasis.getAlertId());
                        upAssetStatusDoBO.setProjectId(monitorInfo.getProjectId());
                        upAssetStatusDoBO.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                        upAssetStatusDoBO.setAssetId(assetId.getAssetId());
                        upAssetStatusDoBO.setAssetStatus("1");
                        upAssetStatusDoBO.setUpdateBy(robotId);
                        upAssetStatusDoBO.setDataPointId(dataPointBasis.getDataPointId());
                        upAssetStatusDoBO.setTenantId(tenantId.getTenantId());
                        log.info("更改资产状态" + upAssetStatusDoBO);
                        assetRepository.upAssetStatus(upAssetStatusDoBO);
                        log.info("更改资产状态成功！准备插入空间标签");
                        //查询资产信息，减去该空间的异常数
                        if (queryAssetInfoDoBO != null) {
                            UpdateAlarmNumberBO updateAlarmNumberBO = new UpdateAlarmNumberBO();
                            updateAlarmNumberBO.setType(2);
                            updateAlarmNumberBO.setSpaceId(queryAssetInfoDoBO.getProjectSpaceId());
                            updateAlarmNumberBO.setAssetId(assetId.getAssetId());
                            String sendInfo1 = JSONUtils.jacksonToJson(updateAlarmNumberBO);
                            log.info("seer标签统计数量-1，存入数据为：" + sendInfo1);
                            ifwKafkaClientUpdateAlarmNumber.syncProduce(sendInfo1);
                            log.info("seer标签统计数量-1，存入成功");
                        }
                        //-------------------------------------------消息推送---------------------------------------------
                        if (!send) {
                            if (DataUtils.isListAvali(listBaseResponse.getData())) {
                                for (QueryMessageConfigResDTO pushInfo : listBaseResponse.getData()) {
                                    log.info("告警人信息：" + pushInfo);
                                    PushMessageReqDTO pushMessageReqDTO = new PushMessageReqDTO();
                                    pushMessageReqDTO.setTenantId(tenantId.getTenantId());
                                    pushMessageReqDTO.setToUserId(pushInfo.getUserId());
                                    PushMessageSentryBO pushMessageSentryBO = new PushMessageSentryBO();
                                    pushMessageSentryBO.setTime(timeFormat.format(new Date()));
                                    pushMessageSentryBO.setAssetName(monitorInfo.getAssetName());
                                    if (queryDataPointIdBO != null) {
                                        pushMessageSentryBO.setMonitorMetricName(queryDataPointIdBO.getMonitorMetricName());
                                    }
                                    pushMessageSentryBO.setSpaceName(newPathBatch.get(0).getNameStr());
                                    pushMessageSentryBO.setSpaceId(monitorInfo.getSpaceId());
                                    pushMessageSentryBO.setMessageInfo((String) message.get("message"));
                                    pushMessageSentryBO.setSentryStatus(dataPointBasis.getDataPointStatus());
                                    if (projectSpaceInfo != null && projectSpaceInfo.getProjectName() != null) {
                                        pushMessageSentryBO.setProjectName(projectSpaceInfo.getProjectName());
                                    }
                                    pushMessageSentryBO.setProjectId(monitorInfo.getProjectId());
                                    pushMessageSentryBO.setAssetId(monitorInfo.getAssetId());
                                    pushMessageSentryBO.setMonitorTargetId(monitorInfo.getMonitorTargetId());
                                    pushMessageSentryBO.setDataPointId(dataPointBasis.getDataPointId());
                                    pushMessageSentryBO.setMessageType(MessageTypeConstants.MESSAGE_TYPE_SENTRY);
                                    String sendMessage = JSONUtils.jacksonToJson(pushMessageSentryBO);
                                    pushMessageReqDTO.setPushContent(sendMessage);
                                    pushMessageReqDTO.setGodzillaDeviceTypes("0,2");
                                    pushMessageReqDTO.setMessageType(MessageTypeConstants.MESSAGE_TYPE_SENTRY);
                                    pushMessageReqDTO.setProjectId(monitorInfo.getProjectId());
                                    pushMessageReqDTOS.add(pushMessageReqDTO);
                                }
                            }
                        }
                    }
                }
            }

            log.info("发送消息成功！数据为：" + pushMessageReqDTOS);
            messageServiceFacade.batchPush(pushMessageReqDTOS);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
            log.error("DataPointId未绑定!DataPointId:" + dataPointBasis.getDataPointId());
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 查询数据点信息
     *
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.String>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/15 14:03
     */
    @Override
    public BaseResponse<String> datapointInfo(EnvironmentListQuDTO query) {
        BaseResponse<String> response = new BaseResponse<>();
        if (DataUtils.isListAvali(query.getMonitorTargetTagId())) {
            HashMap<String, List<String>> map1 = new HashMap<>();
            QueryEnvironmentListQuBasisDTO queryMonitorMetricListDoBO = new QueryEnvironmentListQuBasisDTO();
            queryMonitorMetricListDoBO.setLanguageCode("CN");
            queryMonitorMetricListDoBO.setMonitorTargetTagId(query.getMonitorTargetTagId());
            BaseResponse<List<QueryEnvironmentListDTO>> list = monitorFacade.queryMetricList(queryMonitorMetricListDoBO);
            if (list.getData() != null) {
                List<String> collect = list.getData().stream().map(QueryEnvironmentListDTO::getDataPointId).distinct().collect(Collectors.toList());
                List<String> collect1 = list.getData().stream().map(QueryEnvironmentListDTO::getMonitorMetricId).distinct().collect(Collectors.toList());
                List<String> collect2 = list.getData().stream().map(QueryEnvironmentListDTO::getMonitorTargetId).distinct().collect(Collectors.toList());
                map1.put("dataPointId", collect);
                map1.put("monitorMetricId", collect1);
                map1.put("monitorMetricTargetId", collect2);
            }
            String s = JSONUtils.jacksonToJson(map1);
            response.setData(s);
        }
        return response;
    }

    /**
     * 更新告警模板
     *
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/11/17 17:16
     */
    @Override
    public BaseResponse updateRule(QueryAllDataPointQuDTO query) {
        //查询所有项目点位id

        BaseResponse<List<QueryAllDataPointDTO>> queryAllDataPointDTO = monitorMetricFacade.queryDataPointId(query);
        log.info("查询dataPointList结果为：" + queryAllDataPointDTO);
        List<QueryAllDataPointDTO> dataPointList = queryAllDataPointDTO.getData();
        if (DataUtils.isListAvali(dataPointList)) {
            //按照tenantId进行分组
            Map<String, List<QueryAllDataPointDTO>> tenantIdMap = dataPointList.stream().collect(Collectors.groupingBy(QueryAllDataPointDTO::getTenantId));
            for (Map.Entry<String, List<QueryAllDataPointDTO>> tenantId : tenantIdMap.entrySet()) {
                log.info("租户id为：" + tenantId.getKey());
                //每个租户新建一个系统默认告警模板
                QueryAppIdQueryDoBO queryAppIdQueryDoBO = new QueryAppIdQueryDoBO();
                queryAppIdQueryDoBO.setTenantId(tenantId.getKey());
                QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppIdQueryDoBO);
                if (queryAppIdBO != null && !StringUtils.isEmpty(queryAppIdBO.getAppId())) {
                    //查询租户名称
                    QueryTeantNameReqDoBO queryTeantNameReqDoBO = new QueryTeantNameReqDoBO();
                    ArrayList<String> id = new ArrayList<>();
                    id.add(tenantId.getKey());
                    queryTeantNameReqDoBO.setTenantIds(id);
                    queryTeantNameReqDoBO.setTenantId(tenantId.getKey());
                    queryTeantNameReqDoBO.setLanguageCode("CN");
                    log.info("userRepository入参：" + queryTeantNameReqDoBO);
                    List<QueryTeantNameResDoBO> queryTeantNameResDoBOS = userRepository.queryTenantNames(queryTeantNameReqDoBO);
                    log.info("userRepository出参：" + queryTeantNameResDoBOS);
                    String ruleId = null;
                    if (queryAppIdBO != null && StringUtils.isEmpty(queryAppIdBO.getDefaultAlarmRuleId())) {
                        //查询appId
                        AlarmRuleInsertBO insert = new AlarmRuleInsertBO();
                        insert.setAppId(queryAppIdBO.getAppId());
                        insert.setCallbackUrl(callbackUrl);
                        insert.setCallbackToken(callbackToken);
                        insert.setAlarmChannel("callback");
                        insert.setAlarmCycle("0");
                        if (!DataUtils.isListAvali(queryTeantNameResDoBOS)) {
                            insert.setAlarmRuleName("sentry默认告警模板-" + tenantId.getKey());
                        } else {
                            insert.setAlarmRuleName("sentry默认告警模板-" + queryTeantNameResDoBOS.get(0).getTenantName());
                        }
                        log.info("addAlarmRule入参：" + insert);
                        ruleId = godzillaServerRepository.addAlarmRule(insert);
                        UpdateAppIdQuDTO updateAppIdQuDTO = new UpdateAppIdQuDTO();
                        updateAppIdQuDTO.setTenantId(tenantId.getKey());
                        updateAppIdQuDTO.setRuleId(ruleId);
                        monitorRepository.updateAppId(updateAppIdQuDTO);
                    } else {
                        ruleId = queryAppIdBO.getDefaultAlarmRuleId();
                    }
                    //查询告警规则
                    AlarmRuleListReqBO alarmRuleListReqBO = new AlarmRuleListReqBO();
                    alarmRuleListReqBO.setAppId(queryAppIdBO.getAppId());
                    alarmRuleListReqBO.setPageSize(9999);
                    alarmRuleListReqBO.setPageNum(1);
                    PageDTO<AlarmRuleListRespBO> alarmRuleListRespBOPageDTO = godzillaServerRepository.queryAlarmRuleList(alarmRuleListReqBO);
                    if (alarmRuleListRespBOPageDTO != null) {
                        List<AlarmRuleBO> resultList = IFWBeanCopyUtil.mapAsList(alarmRuleListRespBOPageDTO.getResult(), AlarmRuleBO.class);
                        //把所有告警规则更改成无callback的回调
                        for (AlarmRuleBO rule : resultList) {
                            if (!rule.getAlarmRuleId().equals(ruleId)) {
                                if (!StringUtils.isEmpty(rule.getAlarmChannel())) {
                                    //更新告警规则
                                    AlarmRuleInsertBO alarmRuleInsertBO = new AlarmRuleInsertBO();
                                    alarmRuleInsertBO.setAlarmRuleId(rule.getAlarmRuleId());
                                    alarmRuleInsertBO.setAlarmRuleName(rule.getAlarmRuleName());
                                    String[] split = rule.getAlarmChannel().split(",");
                                    ArrayList<String> alarmChannel = new ArrayList<>();
                                    for (String type : split) {
                                        if (!"callback".equals(type)) {
                                            alarmChannel.add(type);
                                        }
                                    }
                                    if (DataUtils.isListAvali(alarmChannel)) {
                                        alarmRuleInsertBO.setAlarmChannel(String.join(",", alarmChannel));
                                    } else {
                                        alarmRuleInsertBO.setAlarmChannel(null);
                                    }
                                    alarmRuleInsertBO.setSmsPhoneNumbers(rule.getSmsPhoneNumbers());
                                    alarmRuleInsertBO.setEmailToAddresses(rule.getEmailToAddresses());
                                    alarmRuleInsertBO.setVoiceToPhoneNumber(rule.getVoiceToPhoneNumber());
                                    alarmRuleInsertBO.setCallbackUrl(null);
                                    alarmRuleInsertBO.setCallbackToken(null);
                                    alarmRuleInsertBO.setAppId(queryAppIdBO.getAppId());
                                    alarmRuleInsertBO.setValidTime(rule.getValidTime());
                                    alarmRuleInsertBO.setAlarmCycle(rule.getAlarmCycle());
                                    godzillaServerRepository.updateAlarmRule(alarmRuleInsertBO);
                                }
                            }
                        }
                    }
                    for (QueryAllDataPointDTO dataPointDTO : tenantId.getValue()) {
                        QueryRuleAndStartBO queryRuleAndStartBO = new QueryRuleAndStartBO();
                        queryRuleAndStartBO.setDataPointId(dataPointDTO.getDataPointId());
                        QueryRuleAndStartDoBO ruleAndStart = godzillaServerRepository.queryRuleAndStart(queryRuleAndStartBO);
                        if (ruleAndStart != null) {
                            ArrayList<String> ruleList = new ArrayList<>();
                            if (!StringUtils.isEmpty(ruleAndStart.getAlarmRuleId())) {
                                String[] split = ruleAndStart.getAlarmRuleId().split(",");
                                for (String rule : split) {
                                    if (!ruleId.equals(rule)) {
                                        ruleList.add(rule);
                                    }
                                }
                            }
                            ruleList.add(ruleId);
                            DatapointAndAlarmRuleBindReqBO datapointAndAlarmRuleBindReqBO = new DatapointAndAlarmRuleBindReqBO();
                            datapointAndAlarmRuleBindReqBO.setAliasEnableAlarm(ruleAndStart.getAliasEnableAlarm());
                            datapointAndAlarmRuleBindReqBO.setAlarmRuleIds(String.join(",", ruleList));
                            datapointAndAlarmRuleBindReqBO.setDataPointId(dataPointDTO.getDataPointId());
                            godzillaServerRepository.bindDatapointAndAlarmRule(datapointAndAlarmRuleBindReqBO);
                        }
                    }
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String a = "sms,callback";
        String[] split = a.split(",");
        for (String s : split) {
            System.out.println(s);

        }
        short s1 = 1;
    }

}
