package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWUUIDUtils;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.asset.dto.dashboard.*;
import com.ifourthwall.dbm.asset.facade.DashboardFacade;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardDoBO;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardQuDoBO;
import com.ifourthwall.dbm.sentry.config.AssetTagConfig;
import com.ifourthwall.dbm.sentry.domain.DashboardRepository;
import com.ifourthwall.dbm.sentry.service.DashboardService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: YangPeng
 * @Date: 2020/6/29 15:43
 * @Description:
 */
@Slf4j
@Service("DashboardServiceImpl")
public class DashboardServiceImpl implements DashboardService {

    @Reference(version = "1.0.0")
    private DashboardFacade dashboardFacade;

    @Autowired
    private DashboardRepository dashboardRepository;

    @Autowired
    private AssetTagConfig assetTagIn;


    /**
     * 新增仪表盘
     *
     * @param inseret
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     */
    @Override
    public BaseResponse insertDashboard(InsertDashboardDTO inseret, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(inseret.getTenantId(), user);
        inseret.setTenantId(tenantId);
        inseret.setCreateBy(user.getUserId());
        return dashboardFacade.insertDashboard(inseret);
    }

    /**
     * 修改仪表盘
     *
     * @param update
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     */
    @Override
    public BaseResponse updateDashboard(UpdateDashboardDTO update, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(update.getTenantId(), user);
        update.setTenantId(tenantId);
        update.setUpdateBy(user.getUserId());
        return dashboardFacade.updateDashboard(update);
    }

    /**
     * 删除仪表盘
     *
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     */
    @Override
    public BaseResponse deleteDashboard(DeleteDashboardDTO delete, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(delete.getTenantId(), user);
        delete.setTenantId(tenantId);
        return dashboardFacade.deleteDashboard(delete);
    }

    /**
     * 查询仪表盘
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     */
    @Override
    public BaseResponse<QueryDashboardDTO> queryDashboard(QueryDashboardQuDTO query, IFWUser user) {
        BaseResponse<QueryDashboardDTO> response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            QueryDashboardDoBO dashboardList = dashboardRepository.queryDashboard(IFWBeanCopyUtil.map(query, QueryDashboardQuDoBO.class));
            if (dashboardList != null) {
                response.setData(IFWBeanCopyUtil.map(dashboardList, QueryDashboardDTO.class));
            }
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 新增模块
     *
     * @param inseret
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     */
    @Override
    public BaseResponse insertPanel(InsertDashboardPanelDTO inseret, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(inseret.getTenantId(), user);
        inseret.setTenantId(tenantId);
        inseret.setCreateBy(user.getUserId());
        return dashboardFacade.insertPanel(inseret);
    }

    /**
     * 修改模块
     *
     * @param update
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     */
    @Override
    public BaseResponse updatePanel(UpdatePanelDTO update, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(update.getTenantId(), user);
        update.setTenantId(tenantId);
        update.setUpdateBy(user.getUserId());
        return dashboardFacade.updatePanel(update);
    }

    /**
     * 删除模块
     *
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     */
    @Override
    public BaseResponse deletePanel(DeletePanelDTO delete, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(delete.getTenantId(), user);
        delete.setTenantId(tenantId);
        return dashboardFacade.deletePanel(delete);
    }


    /**
     * 新增仪表盘-非自定义
     *
     * @param inseret
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/20 16:34
     */
    @Override
    public BaseResponse noCustomInsert(InsertDashboardAndPanelDTO inseret, IFWUser user) {
        BaseResponse response = new BaseResponse<>();
        try {
            String tenantId = CheckAccessUtils.judgeTenantId(inseret.getTenantId(), user);
            inseret.setTenantId(tenantId);
            //dashboard基础数据



//            for (Integer type : inseret.getCreateType()) {
//                //json
//                DashboardJsonDTO dashboardJsonDTO = new DashboardJsonDTO();
//                //panel基础数据
//                InsertPanelDTO panelInsertInfo = new InsertPanelDTO();
//                String panelId = IFWUUIDUtils.randomUUID();
//                panelInsertInfo.setDashboardPanelId(panelId);
//                ArrayList<DashboardPanelJsonDTO> dashboardPanelJsonDTOS = new ArrayList<>();
//                DashboardPanelJsonDTO assetTagPanelOne = new DashboardPanelJsonDTO();
//                DashboardPanelJsonDTO assetTagPanelTwo = new DashboardPanelJsonDTO();
//                DashboardPanelJsonDTO assetTagPanelThree = new DashboardPanelJsonDTO();
//                if (type == 1) {
//                    dashboardJsonDTO.setPanelId(1);
//                    assetTagPanelOne.setUri(assetTagUri);
//                    //设备入参json
//                    Map<String, String> assetTagInInfo = assetTagIn.getIn();
//                    log.info("数据：" + assetTagInInfo);
//                    HashMap<String, String> assetIn = new HashMap<>();
//                    for (Map.Entry<String, String> assetTag : assetTagInInfo.entrySet()) {
//                        assetIn.put(assetTag.getKey(),assetTag.getValue());
//                    }
//                    assetTagPanelOne.setParameterIn(assetIn);
//                    assetTagPanelOne.setParameterType(1);
//                    //设备出参json
//                    Map<String, String> assetTagOutInfo = assetTagIn.getOut();
//                    HashMap<String, String> assetOut = new HashMap<>();
//                    for (Map.Entry<String, String> assetTagOut : assetTagOutInfo.entrySet()) {
//                        assetOut.put(assetTagOut.getKey(),assetTagOut.getValue());
//                    }
//                    assetTagPanelOne.setParameterOut(assetOut);
//                    dashboardPanelJsonDTOS.add(assetTagPanelOne);
//                    //第二个模块
//                    dashboardPanelJsonDTOS.add(assetTagPanelTwo);
//                    //第三个模块
//                    dashboardPanelJsonDTOS.add(assetTagPanelThree);
//
//                    dashboardJsonDTO.setPanelInfo(dashboardPanelJsonDTOS);
//                    String resultJson = JSONUtils.jacksonToJson(dashboardJsonDTO);
//                    log.info("创建出的json：" + resultJson);
//                    panelInsertInfo.setDashboardPanelJson(resultJson);
//                }
//                if (type == 2) {
//                    dashboardJsonDTO.setPanelId(2);
//                    //新增人员
//                }
//                if (type == 3) {
//                    dashboardJsonDTO.setPanelId(3);
//                    //新增任务
//                }
//                insertList.add(panelInsertInfo);
//            }
//            insertInfo.setPanelInfo(insertList);
            BaseResponse result = dashboardFacade.insertNoCustom(inseret);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    /**
     * 查询仪表盘（不包括panel）
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo < com.ifourthwall.dbm.asset.dto.dashboard.DashboardPanelDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/21 15:27
     */
    @Override
    public BaseResponse<IFWPageInfo<DashboardPanelDTO>> queryDashboardPanel(QueryDashboardPanelQuDTO query, IFWUser user) {
        String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
        query.setTenantId(tenantId);
        return dashboardFacade.queryDashboardPanel(query);
    }


}
