package com.ifourthwall.dbm.sentry.service;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.SeerQueryTagQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.*;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageQuDTO;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/12/28 09:55
 * @Description:
 */
public interface SentryService {

    /**
     * 折线图统计-设备异常数
     * @Author: YangPeng
     * @Date: 2020/12/28 10:05
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<List<QueryLineChartDTO>> queryLineChart(QueryLineChartQuDTO query, IFWUser user);

    /**
     * 告警次数排行
     * @Author: YangPeng
     * @Date: 2021/1/8 10:49
     * @param rankingQuDTO
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateDTO>
     * @throws
     */
    BaseResponse<AlertNumberRankingByDateDTO> alertNumberRankingByDate(AlertNumberRankingByDateQuDTO rankingQuDTO, IFWUser user);

    /**
     * 折线图统计-设备返修率
     * @Author: YangPeng
     * @Date: 2021/1/11 14:20
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.seer.QueryLineChartRepairDTO>>
     * @throws
     */
    BaseResponse<List<QueryLineChartRepairDTO>> queryLineChartRepair(QueryLineChartRepairQuDTO query, IFWUser user);

    /**
     * 监测设备占比
     * @Author: YangPeng
     * @Date: 2021/1/12 14:30
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO>
     * @throws
     */
    BaseResponse<MonitorPercentageDTO> monitorPercentage(MonitorPercentageQuDTO query, IFWUser user);

    /**
     * seer设备统计折线图
     * @Author: YangPeng
     * @Date: 2021/1/19 11:35
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.QuerySeerLineChartDTO>
     * @throws
     */
    BaseResponse<QuerySeerLineChartDTO> querySeerLineChart(QuerySeerLineChartQuDTO query, IFWUser user);
}
