package com.ifourthwall.dbm.sentry.service;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.seer.*;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoQuDTO;
import com.ifourthwall.dbm.sentry.dto.DataPointDTO;
import com.ifourthwall.dbm.sentry.dto.DataPointQuDTO;
import com.ifourthwall.dbm.sentry.dto.QueryInfoByDataPointDTO;
import com.ifourthwall.dbm.sentry.dto.QueryMetricIdDTO;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:50
 * @Description:
 */
public interface SeerService {

    /**
     * seer空间标签
     * @Author: YangPeng
     * @Date: 2020/4/24 15:08
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.SeerQueryTagDTO>
     * @throws
     */
    BaseResponse<List<SeerQueryTagDTO>> seerQueryTag(SeerQueryTagQuDTO query, IFWUser user);

    /**
     * 根据空间标签查询指标统计
     * @Author: YangPeng
     * @Date: 2020/4/28 20:32
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.SeerQueryTagDTO>
     * @throws
     */
    BaseResponse<QueryIndexStatisticsDTO> queryIndexStatistics(QueryIndexStatisticsQuDTO query, IFWUser user);


    /**
     * 根据空间标签查询排行
     * @Author: YangPeng
     * @Date: 2020/4/29 18:17
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryIndexRankingDTO>
     * @throws
     */
    BaseResponse<List<QueryIndexRankingDTO>> queryIndexRanking(@Valid @RequestBody QueryIndexRankingQuDTO query,IFWUser user);

    /**
     * 环境统计
     * @Author: YangPeng
     * @Date: 2020/7/22 15:40
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentDTO>
     * @throws
     */
    BaseResponse<QueryEnvironmentDTO> queryEnvironment(QueryEnvironmentBasisQuDTO query, IFWUser user);

    /**
     * 环境统计列表
     * @Author: YangPeng
     * @Date: 2020/7/22 16:26
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO>>
     * @throws
     */
    BaseResponse<List<EnvironmentListDTO>> queryEnvironmentList(QueryEnvironmentListQuDTO query, IFWUser user);

    /**
     * 门磁-空间安全监测
     * @Author: YangPeng
     * @Date: 2020/7/24 16:27
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.QueryInductionDTO>
     * @throws
     */
    BaseResponse<QueryInductionDTO> queryInduction(QueryInductionQuDTO query, IFWUser user);

    /**
     * 门磁-空间列表
     * @Author: YangPeng
     * @Date: 2020/7/24 16:27
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.seer.QueryInductionListDTO>>
     * @throws
     */
    BaseResponse<List<QueryInductionListDTO>> queryInductionList(QueryInductionListQuDTO query, IFWUser user);

    /**
     * 能耗-能耗统计
     * @Author: YangPeng
     * @Date: 2020/7/27 10:41
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsDTO>
     * @throws
     */
    BaseResponse<QueryEnergyStatisticsDTO> queryEnergyStatistics(QueryEnergyStatisticsQuDTO query, IFWUser user);

    /**
     * 能耗-能耗对比曲线
     * @Author: YangPeng
     * @Date: 2020/7/27 14:11
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphDTO>
     * @throws
     */
    BaseResponse<QueryEnergyComparedGraphDTO> queryEnergyComparedGraph(QueryEnergyComparedGraphQuDTO query, IFWUser user);

    /**
     * 上汽-环境统计
     * @Author: YangPeng
     * @Date: 2020/7/27 16:19
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO>>
     * @throws
     */
    BaseResponse<List<QuerySqEnvironmentInfoDTO>> querySqEnvironmentInfo(QuerySqEnvironmentInfoQuDTO query, IFWUser user);


    BaseResponse sqDepositSenrtyInfo(SqDepositSenrtyInfoDTO query, IFWUser user);

    BaseResponse seerTagMove(SeerTagMoveDTO query, IFWUser user);

    /**
     * 根据标签查询
     * @Author: YangPeng
     * @Date: 2020/9/22 15:20
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.QueryTagInfoListQuDTO>>
     * @throws
     */
    BaseResponse<List<QueryTagInfoListDTO>> queryTagInfoList(QueryTagInfoListQuDTO query);


    /**
     * 根据监控指标id查询监控信息
     * @Author: YangPeng
     * @Date: 2020/9/24 16:24
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.QueryMonitorListDTO>>
     * @throws
     */
    BaseResponse<List<QueryMonitorListDTO>> queryMetricId(QueryMetricIdDTO query);

    /**
     * 根据dataPointId查询哥斯拉信息
     * @Author: YangPeng
     * @Date: 2020/10/21 14:48
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.sentry.dto.DataPointDTO>>
     * @throws
     */
    BaseResponse<List<QueryInfoByDataPointDTO>> queryByDataPoint(QueryMetricIdDTO query);
}
