package com.ifourthwall.dbm.sentry.service;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardAndPanelDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListQuDTO;
import com.ifourthwall.dbm.sentry.bo.UpMonitorRecordDoBO;
import com.ifourthwall.dbm.sentry.bo.UpdateTaskIdHandlerBO;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:50
 * @Description:
 */
public interface MonitorService {

    /**
     * 新增/修改监控（不包括指标）
     *
     * @param upInsertMonitor
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/11 10:27
     */
    BaseResponse upInsertMonitor(UpInsertMonitorBasisDTO upInsertMonitor, IFWUser user);

    /**
     * 更新哥斯拉信息
     *
     * @param upInsertMonitor
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/16 17:08
     */
    BaseResponse upInsertIndex(UpInsertMonitorBasisDTO upInsertMonitor, IFWUser user);

    /**
     * 查询监控信息
     *
     * @param monitorInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.sentry.dto.QueryMonitorInfoDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/12 11:03
     */
    BaseResponse<QueryMonitorInfoDTO> queryMonitorInfo(QueryMonitorInfoQueryBasisDTO monitorInfo, IFWUser user);

    /**
     * 查询监控列表
     *
     * @param monitorList
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.sentry.dto.PageDTO < com.ifourthwall.dbm.sentry.dto.QueryMonitorListDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/12 15:40
     */
    BaseResponse<PageDTO<QueryMonitorListDTO>> queryMonitorList(QueryMonitorListQueryDTO monitorList, IFWUser user);

    /**
     * 查询监控翻译配置
     *
     * @param translationDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.sentry.dto.QueryMonitorTranslationDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/16 16:30
     */
    BaseResponse<QueryMonitorTranslationDTO> queryMonitorTranslation(TranslationDTO translationDTO);

    /**
     * 查询监控记录列表
     *
     * @param recording
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/19 9:49
     */
    BaseResponse<PageDTO<QueryRecordingListDTO>> queryRecordingList(QueryRecordingQueryBasisDTO recording, IFWUser user);


    /**
     * 接收哥斯拉告警信息(自动生成工单)
     *
     * @param
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/24 10:55
     */
    BaseResponse generateTaks();

    /**
     * 接收哥斯拉告警信息(获取工单参数，更新数据库)
     *
     * @param upMonitorRecordDTO
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/26 9:47
     */
    BaseResponse updateDataPoint(UpMonitorRecordDTO upMonitorRecordDTO);

    /**
     * 新增告警通知（透传哥斯拉）
     *
     * @param insetAlertNotice
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/26 10:20
     */
    BaseResponse insetAlertNotice(InsetAlertNoticeDTO insetAlertNotice, IFWUser user);

    /**
     * 告警列表
     *
     * @param
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/2 16:46
     */
    BaseResponse<PageDTO<AlertListDTO>> alertList(AlertListQueryDTO alertList,IFWUser user);

    /**
     * 编辑告警规则
     *
     * @param updateAlert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/2 17:15
     */
    BaseResponse updateAlert(UpAlertNoticeDTO updateAlert,IFWUser user);

    /**
     * 告警规则详情
     *
     * @param alertInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryAlertInfoDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/2 17:24
     */
    BaseResponse<QueryAlertInfoDTO> queryAlert(QueryAlertDTO alertInfo,IFWUser user);

    /**
     * 删除告警规则
     *
     * @param alertInfo
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/2 17:39
     */
    BaseResponse deleteAlert(QueryAlertDTO alertInfo,IFWUser user);

    /**
     * 获取AppId
     *
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/2 17:43
     */
    BaseResponse getAppId(GetAppIdDTO appIdDTO,IFWUser user);

    /**
     * 查询appid
     *
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/2 20:00
     */
    BaseResponse<QueryAppIdDTO> queryAppId(QueryAppIdQueryDTO query,IFWUser user);

    /**
     * 监控指标详情(sentry数据)
     *
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/3 18:18
     */
    BaseResponse<AlertIndexInfoDTO> sentryInfo(SentryInfoQuBasisDTO sentryInfo, IFWUser user);

    /**
     * 监控指标详情(哥斯拉数据)
     *
     * @param godzillaInfoQu
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.GodzillaInfoDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/1/4 18:14
     */
    BaseResponse<MetricValueRecordListDTO> godzillaInfo(GodzillaInfoQuDTO godzillaInfoQu, IFWUser user);


    /**
     * sentry统计信息
     *
     * @param sentryInfo
     * @param user
     * @return
     */
    BaseResponse<QuerySentryInfoDTO> querySentryInfo(QuerySentryInfoQueryDTO sentryInfo, IFWUser user);


    /**
     * sentry统计信息(设备统计)
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<QuerySentryInfoAssetDTO> querySentryInfoAsset(QuerySentryInfoQueryDTO sentryInfo,IFWUser user);

    /**
     * sentry统计信息（7日告警）
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<QuerySentryInfoSevenDayDTO> querySentryInfoSevenDay(QuerySentryInfoQueryDTO sentryInfo,IFWUser user);


    /**
     * sentry统计信息（告警排行）
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<SentryInfoRankingDTO> querySentryInfoRanking(QuerySentryInfoQueryDTO sentryInfo,IFWUser user);

    /**
     * sentry统计信息（设备完好率）
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<SentryInfoIntactDTO> querySentryInfoIntact(QuerySentryInfoQueryDTO sentryInfo,IFWUser user);

    /**
     * seer系统统计列表
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<IFWPageInfo<SeerTagListDTO>> seerTagList(QuerySentryInfoQueryDTO sentryInfo,IFWUser user);


    /**
     * sentry实时监控图（共用）-检测设备总数、故障排行
     *
     * @param rankingQuDTO
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentryMonitorRankingDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/3/9 10:11
     */
    BaseResponse<SentryMonitorRankingDTO> sentryMonitor(SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user);

    /**
     * sentry实时监控图-故障排行
     *
     * @param rankingQuDTO
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.sentryRankDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/3/12 17:46
     */
    BaseResponse<SentryRankDTO> sentryRanking(SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user);

    /**
     * sentry实时监控图-系统故障
     *
     * @param tagQuery
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.TagInfoDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 16:42
     */
    BaseResponse<List<TagInfoDTO>> tagInfo(TagInfoQuDTO tagQuery, IFWUser user);

    /**
     * sentry实时监控图-系统故障百分比
     * @Author: YangPeng
     * @Date: 2020/3/17 17:08
     * @param null
     * @return
     * @throws
     */
    BaseResponse<TagFaultPercentDTO> tagFaultPercent(TagFaultPercentQuDTO percentQuery, IFWUser user);

    /**
     * sentry实时监控图-空间筛选
     * @Author: YangPeng
     * @Date: 2020/3/18 11:17
     * @param spaceQu
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.MonitorSpaceDTO>>
     * @throws
     */
    BaseResponse<List<MonitorSpaceDTO>> monitorSpace(MonitorSpaceQuDTO spaceQu, IFWUser user);

    /**
     * 新增监控对象标签
     * @Author: YangPeng
     * @Date: 2020/4/1 9:41
     * @param null
     * @return
     * @throws
     */
    BaseResponse insertTag(InsertTagQuDTO insertTag, IFWUser user);


    /**
     * 修改监控对象标签
     * @Author: YangPeng
     * @Date: 2020/4/1 9:42
     * @param updateTag
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateTag(UpdateTagQuDTO updateTag, IFWUser user);

    /**
     * 删除监控对象标签
     * @Author: YangPeng
     * @Date: 2020/4/1 9:42
     * @param null
     * @return
     * @throws
     */
    BaseResponse deleteTag(DeleteTagQuDTO deleteTag, IFWUser user);

    /**
     * 查询调用授权数量
     * @Author: YangPeng
     * @Date: 2020/4/1 11:38
     * @param appId
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.TransferNumberDTO>
     * @throws
     */
    BaseResponse<TransferNumberDTO> transferNumber(TransferNumberQuDTO appId, IFWUser user);

    /**
     * 删除监控
     * @Author: YangPeng
     * @Date: 2020/4/1 14:55
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteMonitor(DeleteMonitorDTO delete, IFWUser user);

    /**
     * 查询监控对象标签
     * @Author: YangPeng
     * @Date: 2020/4/1 16:41
     * @param queryList
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.QueryMonitorTagListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryMonitorTagListDTO>> queryTagList(QueryMonitorTagListQuDTO queryList, IFWUser user);

    /**
     * sentry实时监控图-告警次数排行
     * @Author: YangPeng
     * @Date: 2020/4/3 11:34
     * @param null
     * @return
     * @throws
     */
    BaseResponse<alertNumberRanking> alertNumberRanking(SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user);

    /**
     *sentry实时监控图首页-监控设备统计
     * @Author: YangPeng
     * @Date: 2020/4/3 15:18
     * @param null
     * @return
     * @throws
     */
    BaseResponse<monitorSeerInfoDTO> monitorSeerInfo(monitorSeerInfoQuDTO query, IFWUser user);

    /**
     * seer查询sentry监控
     * @Author: YangPeng
     * @Date: 2020/4/16 17:57
     * @param null
     * @return
     * @throws
     */
    BaseResponse<SeerQuerySentryInfoDTO> seerQuerySentryInfo(SeerQuerySentryInfoQuDTO query, IFWUser user);

    /**
     * 查询是否引用模板
     * @Author: YangPeng
     * @Date: 2020/4/17 18:10
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Boolean>
     * @throws
     */
    BaseResponse<Boolean> sentryQueryTask(SentryQueryTaskQuDTO query, IFWUser user);

    /**
     * 查询用电用水信息
     * @Author: YangPeng
     * @Date: 2020/4/22 19:08
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryAllByStatisticsDTO>
     * @throws
     */
    BaseResponse<QueryAllByStatisticsDTO> queryAllByStatistics(QueryAllByStatisticsQuDTO query, IFWUser user);


    BaseResponse<queryDataPointIdDTO> queryDataPointId(queryDataPointIdQuDTO upMonitorRecordDTO);



//    BaseResponse inserttt(InsertDashboardAndPanelDTO upMonitorRecordDTO);
}
