package com.ifourthwall.dbm.sentry.service;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryCreateTaskDTO;
import com.ifourthwall.dbm.sentry.bo.QueryByDataPointDTO;
import com.ifourthwall.dbm.sentry.bo.QueryByDataPointQuBO;
import com.ifourthwall.dbm.sentry.dto.QueryByDataPointQuDTO;

/**
 * @Author: YangPeng
 * @Date: 2020/9/4 09:52
 * @Description:
 */
public interface MonitorMetricService {

    /**
     * 检查点位是否又被使用
     * @Author: YangPeng
     * @Date: 2020/9/4 9:52
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdDTO>
     * @throws
     */
    BaseResponse<CheckDataPointIdDTO> checkDataPointId(CheckDataPointIdQuDTO query, IFWUser user);

    /**
     * 通过点位查看信息
     * @Author: YangPeng
     * @Date: 2020/9/16 18:11
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.sentry.bo.QueryByDataPointBO>
     * @throws
     */
    BaseResponse<QueryByDataPointDTO> queryByDataPoint(QueryByDataPointQuDTO query, IFWUser user);

    /**
     * 手动发起工单
     * @Author: YangPeng
     * @Date: 2020/10/26 10:19
     * @param create
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse sentryCreateTask(SentryCreateTaskDTO create, IFWUser user);
}
