package com.ifourthwall.dbm.sentry.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/9/16 18:07
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryByDataPointQuDTO implements Serializable {

    @ApiModelProperty("数据点")
    @NotNull(message = "数据点不能为空")
    private String dataPointId;

    @NotNull(message = "开始时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @NotNull(message = "结束时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;
}
