package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.sentry.bo.QueryUserNameQueryBO;
import com.ifourthwall.dbm.sentry.bo.UserNameDTO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameReqDoBO;
import com.ifourthwall.dbm.sentry.bo.obj.QueryTeantNameResDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import com.ifourthwall.dbm.user.dto.*;
import com.ifourthwall.dbm.user.facade.TenantFacade;
import com.ifourthwall.dbm.user.facade.TenantPurchaseServiceFacade;
import com.ifourthwall.dbm.user.facade.UserFacade;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/6 15:49
 * @Description:
 */
@Service("UserRepository")
@Slf4j
public class UserRepository {

    @Reference(version = "1.0.0")
    private UserFacade userFacade;

    @Reference(version = "1.0.0")
    private TenantFacade tenantFacade;

    @Reference(version = "1.0.0")
    private TenantPurchaseServiceFacade tenantPurchaseServiceFacade;

    /**
     * 查询人名
     * @Author: YangPeng
     * @Date: 2019/12/6 15:51
     * @param ids
     * @return
     * @throws
     */
    public List<UserNameDTO> queryUserName(QueryUserNameQueryBO ids){
        ArrayList<UserNameDTO> resultList = new ArrayList<>();
        QueryRealNameReqDTO queryUser = new QueryRealNameReqDTO();
        queryUser.setUserIds(ids.getUserIds());
        queryUser.setTenantId(ids.getTenantId());
        queryUser.setLanguageCode("CN");
        log.info("接口 queryUserName ,接受参数:{}", ids);
        BaseResponse<List<QueryRealNameResDTO>> response = userFacade.queryRealNameByUserIds(queryUser);
        log.info("接口 queryUserName ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())) {
            for (QueryRealNameResDTO userInfo : response.getData()) {
                UserNameDTO resultDTO = new UserNameDTO();
                resultDTO.setUserId(userInfo.getUserId());
                resultDTO.setUserName(userInfo.getRealName());
                resultList.add(resultDTO);
            }
        }
        return resultList;
    }

    /**
     * 查询是否购买服务
     * @Author: YangPeng
     * @Date: 2020/9/16 10:00
     * @param ids
     * @return boolean
     * @throws
     */
    public boolean queryTenantWhetherPurchaseService(ServiceWetherPurchaseReqDTO ids){
        log.info("接口 queryUserName ,接受参数:{}", ids);
        BaseResponse<ServiceWetherPurchaseResDTO> response = tenantPurchaseServiceFacade.queryTenantWhetherPurchaseService(ids);
        log.info("接口 queryUserName ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() == null) {
            return false;
        }
        return true;
    }

    /**
     * 查询tenantName
     * @Author: YangPeng
     * @Date: 2020/4/8 15:23
     * @param queryTeantName
     * @return java.util.List<com.ifourthwall.dbm.object.bo.QueryTeantNameResDoBO>
     * @throws
     */
    public List<QueryTeantNameResDoBO> queryTenantNames(QueryTeantNameReqDoBO queryTeantName){
        ArrayList<QueryTeantNameResDoBO> resultList = new ArrayList<>();
        log.info("接口 queryTenantNames ,接受参数:{}", queryTeantName);
        BaseResponse<List<QueryTeantNameResDTO>> response = tenantFacade.queryTenantNames(IFWBeanCopyUtil.map(queryTeantName, QueryTeantNameReqDTO.class));
        log.info("接口 queryTenantNames ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())) {
            for (QueryTeantNameResDTO tenantInfo : response.getData()) {
                QueryTeantNameResDoBO resultDTO = new QueryTeantNameResDoBO();
                resultDTO.setTenantId(tenantInfo.getTenantId());
                resultDTO.setTenantName(tenantInfo.getTenantName());
                resultList.add(resultDTO);
            }
            return resultList;
        }
        return null;
    }

}
