package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.dbm.project.dto.project.QueryCountryIdDTO;
import com.ifourthwall.dbm.project.dto.project.QueryCountryIdQuDTO;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.project.dto.*;
import com.ifourthwall.dbm.project.facade.ProjectFacade;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

/**
 * @Author: YangPeng
 * @Date: 2019/12/4 14:02
 * @Description:
 */
@Slf4j
@Repository("ProjectRepository")
public class ProjectRepository {


    @Reference(version = "1.0.0")
    private ProjectFacade projectFacade;


    public QueryProjectPagePO getProjectSpaceInfo(GetProjectSpaceInfoQueryBO projectSpaceInfo) {
        QueryProjectPagePO resultPO = new QueryProjectPagePO();
        GetSonSpaceBO result = new GetSonSpaceBO();
        log.info("接口 getProjectSpaceInfo ,接受参数:{}", projectSpaceInfo);
        GetProjectSpaceInfoQueryDTO querySpaceInfo = new GetProjectSpaceInfoQueryDTO();
        BeanUtils.copyProperties(projectSpaceInfo,querySpaceInfo);
        BaseResponse<QueryProjectPageDTO> response = projectFacade.getProjectSpaceInfo(querySpaceInfo);
        log.info("接口 getProjectSpaceInfo ,返回结果:{}", response);
        if (!response.isFlag()){
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null){
            BeanUtils.copyProperties(response.getData(),resultPO);
            return resultPO;
        }
        return resultPO;
    }

    /**
     * 通过项目id查询项目所属国家
     * @Author: YangPeng
     * @Date: 2020/10/12 15:46
     * @param query
     * @return com.ifourthwall.dbm.project.dto.project.QueryCountryIdDTO
     * @throws
     */
    public QueryCountryIdDTO queryCountryId(QueryCountryIdQuDTO query) {
        log.info("接口 queryCountryId ,接受参数:{}", query);
        BaseResponse<QueryCountryIdDTO> response = projectFacade.queryCountryId(query);
        log.info("接口 queryCountryId ,返回结果:{}", response);
        if (!response.isFlag()){
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null){
            return response.getData();
        }
        return null;
    }
}
