package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryInsertAlertIdDTO;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.asset.facade.MonitorReadingFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.meter.QueryMetricByAssetDoBO;
import com.ifourthwall.dbm.sentry.bo.meter.QueryMetricByAssetQuDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/12/4 10:37
 * @Description:
 */
@Slf4j
@Repository("MonitorReadingRepository")
public class MonitorReadingRepository {


    @Reference(version = "1.0.0")
    private MonitorReadingFacade readingFacade;

    /**
     * 根据资产查询监控指标
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     * @param monitorInfo
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     */
    public List<QueryMetricByAssetDoBO> queryMetricByAsset(QueryMetricByAssetQuDoBO monitorInfo){
        //组装请求参数
        log.info("接口 queryMetricByAsset ,接受参数:{}", monitorInfo);
        BaseResponse<List<QueryMetricByAssetDTO>> response = readingFacade.queryMetricByAsset(IFWBeanCopyUtil.map(monitorInfo, QueryMetricByAssetQuDTO.class));
        log.info("接口 queryMetricByAsset ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())){
            return IFWBeanCopyUtil.mapAsList(response.getData(),QueryMetricByAssetDoBO.class);
        }
        return null;
    }


    /**
     * 手动发起工单
     * @Author: YangPeng
     * @Date: 2020/10/26 11:04
     * @param insertAlertIdDTO
     * @return void
     * @throws
     */
    public void insertAlertId(SentryInsertAlertIdDTO insertAlertIdDTO) {
        log.info("接口 insertAlertId ,接受参数:{}", insertAlertIdDTO);
        BaseResponse response = readingFacade.insertAlertId(insertAlertIdDTO);
        log.info("接口 insertAlertId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
    }
}
