package com.ifourthwall.dbm.sentry.domain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.asset.dto.AlertRulesDTO;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.UpInGodzillaMonitor;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.alarm.*;
import com.ifourthwall.dbm.sentry.bo.app.AppRespBO;
import com.ifourthwall.dbm.sentry.bo.app.AppReqBO;
import com.ifourthwall.dbm.sentry.bo.godzilla.QueryMaxMinBO;
import com.ifourthwall.dbm.sentry.bo.godzilla.QueryMaxMinQuBO;
import com.ifourthwall.dbm.sentry.bo.godzilla.QueryRuleBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @Author: hao.dai
 * @Date: 2020/1/2 15:56
 * @Description:
 */
@Component
@Slf4j
public class GodzillaServerRepository {

    @Value("${godzilla.token}")
    private String godzillaToken;

    @Value("${query.alarm.rule.list}")
    private String queryAlarmRuleList;

    @Value("${add.alarm.rule}")
    private String addAlarmRule;

    @Value("${update.alarm.rule.list}")
    private String updateAlarmRule;

    @Value("${query.alarm.rule.detail}")
    private String queryAlarmRuleDetail;

    @Value("${delete.alarm.rule}")
    private String deleteAlarmRule;

    @Value("${query.datapoint.max.and.min}")
    private String queryMaxAndMin;

    @Value("${datapoint.rule.update}")
    private String updateRuleDataPoint;

    @Value("${datapoint.rule.delete}")
    private String deleteRuleDataPoint;

    @Value("${query.metric.value.record.list}")
    private String queryMetricValueRecordList;

    @Value("${create.app}")
    private String createApp;

    @Value("${update.data.point.name}")
    private String updateDataPointName;

    @Value("${update.max.and.min}")
    private String insertMaxAndMin;

    @Value("${bind.datapoint.and.alarm.rule}")
    private String bindDatapointAndAlarmRule;

    @Value("${query.rule.and.start}")
    private String queryRuleAndStart;

    @Value("${transfer.number}")
    private String transferNumber;


    /**
     * 哥斯拉透传okHttp专用
     *
     * @Author: YangPeng
     * @Date: 2019/12/30 17:51
     * @param null
     * @return
     * @throws
     */
    public static final MediaType JSON
            = MediaType.get("application/json; charset=utf-8");
    private static final OkHttpClient client = new OkHttpClient.Builder()
            .connectTimeout(1, TimeUnit.SECONDS).build();

    /**
     * 封装发送数据
     */
    public Request synPost(String url, String json, String token) {
        if (StringUtils.isBlank(url)) {
            throw new RuntimeException("url不能为空");
        }
        RequestBody body = RequestBody.create(JSON, json);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (StringUtils.isNotBlank(token)) {
            builder.header("Authorization", token);
        }
        builder.method("POST", body);
        Request request = builder.build();
        return request;
    }

    private Map<String, Object> synSend(String url, String json, String token) {
        Request request = synPost(url, json, token);
        log.info("即将发送URL:{}", url);
        Response response = null;
        try {
            response = client.newCall(request).execute();
            String content = response.body().string();
            log.info("发送URL:{}成功,返回的数据:{}", url, content);
            Map<String, Object> result = JSONUtils.jacksonFromJson(content, HashMap.class);
            return result;
        } catch (IOException e) {
            log.error("发送失败，原因：", e);
            throw new RuntimeException(e);
        }
    }

    private void handleFailedResult(Map<String, Object> result, String errorMsg, String errorCode) {
        if (!(Boolean) result.get("flag")) {
            log.warn("调用godzilla接口失败,错误原因:{},错误编码:{}", result.get("msg"), result.get("code"));
            throw new BizException(errorMsg, errorCode);
        }
    }


    /**
     * 告警规则列表查询
     */
    public PageDTO<AlarmRuleListRespBO> queryAlarmRuleList(AlarmRuleListReqBO alarmRuleListReqBO) {
        PageDTO<AlarmRuleListRespBO> resultPage = new PageDTO<>();
        log.info("告警规则详情告警规则列表查询，请求参数{}", alarmRuleListReqBO);
        String sentInfo = JSONUtils.jacksonToJson(alarmRuleListReqBO);
        log.info("json:" + sentInfo);
        Map<String, Object> result = synSend(queryAlarmRuleList, sentInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.QUERY_OF_ALARM_RULE_LIST_FAILED.getDesc(), PlatformCodeEnum.QUERY_OF_ALARM_RULE_LIST_FAILED.getCode());
        if (result.get("data") != null) {
            Map<String, Object> data = (Map<String, Object>) result.get("data");
            if (data.get("alarmRuleList") != null) {
                List<AlarmRuleListRespBO> alarmRuleList = (List<AlarmRuleListRespBO>) data.get("alarmRuleList");
                Integer pageNum = (Integer) data.get("pageNum");
                Integer pageSize = (Integer) data.get("pageSize");
                Integer total = (Integer) data.get("total");
                resultPage.setResult(alarmRuleList);
                resultPage.setPageNum(pageNum);
                resultPage.setPageSize(pageSize);
                resultPage.setTotal(total);
                return resultPage;
            }
        }
        return null;
    }

    /**
     * 增加告警规则
     *
     * @param alarmRuleBO
     */
    public String addAlarmRule(AlarmRuleInsertBO alarmRuleBO) {
        log.info("增加告警规则，请求参数{}", alarmRuleBO);
        String sendInfo = JSONUtils.jacksonToJson(alarmRuleBO);
        log.info("json:" + sendInfo);
        Map<String, Object> result = synSend(addAlarmRule, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.INSERT_FAILURE.getDesc(), PlatformCodeEnum.INSERT_FAILURE.getCode());
        Map data = (Map) result.get("data");
        if (data != null) {
            String releId = (String)data.get("alarmRuleId");
            if (!StringUtils.isEmpty(releId)){
                return releId;
            }
        }
        return null;
    }

    /**
     * 编辑告警规则
     *
     * @param alarmRuleBO
     */
    public void updateAlarmRule(AlarmRuleInsertBO alarmRuleBO) {
        log.info("编辑告警规则，请求参数{}", alarmRuleBO);
        String sentInfo = JSONUtils.jacksonToJson(alarmRuleBO);
        log.info("json:" + sentInfo);
        Map<String, Object> result = synSend(updateAlarmRule, sentInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.UPDATE_FAILURE.getDesc(), PlatformCodeEnum.UPDATE_FAILURE.getCode());
    }

    /**
     * 告警规则详情
     *
     * @param alarmRuleId
     * @return
     */
    public AlarmRuleBO queryAlarmRuleDetail(QueryAlarmRuleDetailBO alarmRuleId) {
        AlarmRuleBO resultDTO = new AlarmRuleBO();
        log.info("告警规则详情，请求参数{}", alarmRuleId);
        String sentInfo = JSONUtils.jacksonToJson(alarmRuleId);
        log.info("json:" + sentInfo);
        Map<String, Object> result = synSend(queryAlarmRuleDetail, sentInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.FAILED_TO_VIEW_ALARM_RULE_DETAILS.getDesc(), PlatformCodeEnum.FAILED_TO_VIEW_ALARM_RULE_DETAILS.getCode());
        Map data = (Map) result.get("data");
        if (data != null) {
            resultDTO.setAlarmRuleId((String) data.get("alarmRuleId"));
            resultDTO.setAlarmRuleName((String) data.get("alarmRuleName"));
            resultDTO.setAlarmChannel((String) data.get("alarmChannel"));
            resultDTO.setSmsPhoneNumbers((String) data.get("smsPhoneNumbers"));
            resultDTO.setEmailToAddresses((String) data.get("emailToAddresses"));
            resultDTO.setVoiceToPhoneNumber((String) data.get("voiceToPhoneNumber"));
            resultDTO.setCallbackUrl((String) data.get("callbackUrl"));
            resultDTO.setCallbackToken((String) data.get("callbackToken"));
            resultDTO.setAppId((String) data.get("appId"));
            resultDTO.setValidTime((String) data.get("validTime"));
            resultDTO.setAlarmCycle((String) data.get("alarmCycle"));
            return resultDTO;
        }
        return null;
    }

    /**
     * 删除告警规则
     *
     * @param alarmRuleId
     */
    public void deleteAlarmRule(String alarmRuleId) {
        DeleteAlarmRuleBO deleteAlarmRuleBO = new DeleteAlarmRuleBO();
        log.info("删除告警规则，请求参数{}", alarmRuleId);
        deleteAlarmRuleBO.setAlarmRuleId(alarmRuleId);
        String sentInfo = JSONUtils.jacksonToJson(deleteAlarmRuleBO);
        Map<String, Object> result = synSend(deleteAlarmRule, sentInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.DELETE_FAILURE.getDesc(), PlatformCodeEnum.DELETE_FAILURE.getCode());
    }

    /**
     * 检测指标数据记录查询
     *
     * @param metricValueRecordListReq
     * @return
     */
    public MetricValueRecordListBO queryMetricValueRecordList(MetricValueRecordListReqBO metricValueRecordListReq) {
        MetricValueRecordListBO resultList = new MetricValueRecordListBO();
        log.info("检测指标数据记录查询，请求参数{}", metricValueRecordListReq);
        String sentInfo = JSONUtils.jacksonToJson(metricValueRecordListReq);
        log.info("json:" + sentInfo);
        Map<String, Object> result = synSend(queryMetricValueRecordList, sentInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.QUERY_OF_TEST_INDICATOR_DATA_RECORD_FAILED.getDesc(), PlatformCodeEnum.QUERY_OF_TEST_INDICATOR_DATA_RECORD_FAILED.getCode());
        if (result.get("data") != null) {
            Map<String, List<Map<String, String>>> data = (Map<String, List<Map<String, String>>>) result.get("data");
            List<Map<String, String>> collectDataList = data.get("collectDataList");
            List<Map<String, String>> alarmRecordList = data.get("alarmRecordList");
            if (DataUtils.isListAvali(collectDataList)) {
                ArrayList<GodzillaInfoBO> resultList1 = new ArrayList<>();
                for (Map<String, String> resultInfo : collectDataList) {
                    GodzillaInfoBO resultDTO = new GodzillaInfoBO();
                    resultDTO.setDataPointId(resultInfo.get("dataPointId"));
                    resultDTO.setTime(resultInfo.get("time"));
                    resultDTO.setValue(resultInfo.get("dataValue"));
                    resultDTO.setAlarmMax(resultInfo.get("alarm_max"));
                    resultDTO.setAlarmMin(resultInfo.get("alarm_min"));
                    resultDTO.setEnableAlarm(resultInfo.get("enable_alarm"));
                    resultDTO.setUserName(resultInfo.get("userName"));
                    resultDTO.setRemark(resultInfo.get("remark"));
                    resultList1.add(resultDTO);
                }
                resultList.setCollectDataList(resultList1);
            }
            if (DataUtils.isListAvali(alarmRecordList)) {
                ArrayList<GodzillaInfoTwoBO> resultList2 = new ArrayList<>();
                for (Map<String, String> resultInfo : alarmRecordList) {
                    GodzillaInfoTwoBO godzillaInfoTwoBO = new GodzillaInfoTwoBO();
                    godzillaInfoTwoBO.setDataPointId(resultInfo.get("dataPointId"));
                    godzillaInfoTwoBO.setTime(resultInfo.get("time"));
                    godzillaInfoTwoBO.setValue(resultInfo.get("value"));
                    godzillaInfoTwoBO.setMessage(resultInfo.get("message"));
                    godzillaInfoTwoBO.setDataPointStatus(resultInfo.get("dataPointStatus"));
                    resultList2.add(godzillaInfoTwoBO);
                }
                resultList.setAlarmRecordList(resultList2);
            }
            return resultList;
        }
        return null;
    }

    //告警记录查询 不需要哥斯拉提供
//    public AlarmRecordRespBO queryAlarmRecordList(AlarmRecordReqBO alarmRecordReqBO) {
//
//        return null;
//    }

    //创建app返回appId
    public AppRespBO createApp(AppReqBO appReqBO) {
        AppRespBO resultDTO = new AppRespBO();
        log.info("创建app，请求参数{}", appReqBO);
        String sentInfo = JSONUtils.jacksonToJson(appReqBO);
        Map<String, Object> result = synSend(createApp, sentInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.GODZILLA_FAILED_TO_GET_APPID.getDesc(), PlatformCodeEnum.GODZILLA_FAILED_TO_GET_APPID.getCode());
        if (result.get("data") != null) {
            Map<Object, Object> data = (Map<Object, Object>) result.get("data");
            String appid = (String) data.get("appId");
            resultDTO.setAppId(appid);
            return resultDTO;
        }
        return null;
    }

    //设置datapoint名称（不包括最大值最小值）
    public void updateDataPointName(UpInGodzillaMonitor upInGodzillaMonitor) {
        String sendInfo = JSONUtils.jacksonToJson(upInGodzillaMonitor);
        log.info("设置datapoint名称，请求参数{}", upInGodzillaMonitor);
        Map<String, Object> result = synSend(updateDataPointName, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }


    //增加最大值最小值
    public void addMaxAndMin(AddMaxAndMinBO updateMaxAndMinBO) {
        String sendInfo = JSONUtils.jacksonToJson(updateMaxAndMinBO);
        log.info("设置最大值最小值，请求参数{}", updateMaxAndMinBO);
        Map<String, Object> result = synSend(insertMaxAndMin, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }


    //删除最大值最小值
    public void deleteMaxAndMin(DeleteMaxAndMinBO delete) {
        String sendInfo = JSONUtils.jacksonToJson(delete);
        log.info("设置最大值最小值，请求参数{}", delete);
        Map<String, Object> result = synSend(deleteRuleDataPoint, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }


    //更新最大值最小值
    public void updateMaxAndMin(UpdateMaxAndMinBO updateMaxAndMinBO) {
        String sendInfo = JSONUtils.jacksonToJson(updateMaxAndMinBO);
        log.info("设置最大值最小值，请求参数{}", updateMaxAndMinBO);
        Map<String, Object> result = synSend(updateRuleDataPoint, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }


    //查询最大值最小值
    public List<QueryRuleBO> queryRule(QueryRuleAndStartBO queryRuleAndStartBO) {
        String sendInfo = JSONUtils.jacksonToJson(queryRuleAndStartBO);
        log.info("设置最大值最小值，请求参数{}", queryRuleAndStartBO);
        Map<String, Object> resultOne = synSend(queryMaxAndMin, sendInfo, godzillaToken);
        if (resultOne.get("data") != null) {
            List<Map<Object, Object>> dataOne = (List<Map<Object, Object>>) resultOne.get("data");
            if (DataUtils.isListAvali(dataOne)) {
                ArrayList<QueryRuleBO> alertList = new ArrayList<QueryRuleBO>();
                for (Map<Object, Object> objectObjectMap : dataOne) {
                    QueryRuleBO alertRulesDTO = new QueryRuleBO();
                    String alarmMaximumValue = (String) objectObjectMap.get("alarmMaximumValue");
                    String alarmMinimumValue = (String) objectObjectMap.get("alarmMinimumValue");
                    Integer compareDuration = (Integer) objectObjectMap.get("compareDuration");
                    String compareTarget = (String) objectObjectMap.get("compareTarget");
                    String dataPointAlarmTriggerRuleId = (String) objectObjectMap.get("dataPointAlarmTriggerRuleId");
                    alertRulesDTO.setAlarmMaximumValue(alarmMaximumValue);
                    alertRulesDTO.setAlarmMinimumValue(alarmMinimumValue);
                    alertRulesDTO.setCompareDuration(compareDuration);
                    alertRulesDTO.setCompareTarget(compareTarget);
                    alertRulesDTO.setDataPointAlarmTriggerRuleId(dataPointAlarmTriggerRuleId);
                    alertList.add(alertRulesDTO);
                }
                return alertList;
            }
        }
        return null;
    }

    //修改告警规则
    public void bindDatapointAndAlarmRule(DatapointAndAlarmRuleBindReqBO datapointAndAlarmRuleBindReqBO) {
        log.info("修改告警规则，请求参数{}", datapointAndAlarmRuleBindReqBO);
        String sendInfo = JSONUtils.jacksonToJson(datapointAndAlarmRuleBindReqBO);
        System.out.println("json:" + sendInfo);
        Map<String, Object> result = synSend(bindDatapointAndAlarmRule, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.BINDING_FAILED.getDesc(), PlatformCodeEnum.BINDING_FAILED.getCode());
    }


    //根据dataPoint查询哥斯拉相关数据（绑定告警规则、是否开启）
    public QueryRuleAndStartDoBO queryRuleAndStart(QueryRuleAndStartBO queryRuleAndStartBO) {
        QueryRuleAndStartDoBO resultDTO = new QueryRuleAndStartDoBO();
        log.info("根据dataPoint查询哥斯拉相关数据，请求参数{}", queryRuleAndStartBO);
        String sendInfo = JSONUtils.jacksonToJson(queryRuleAndStartBO);
        System.out.println("json:" + sendInfo);
        Map<String, Object> result = synSend(queryRuleAndStart, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.FAILED_TO_QUERY_GODZILLA_RELATED_DATA_ACCORDING_TO_DATAPOINT.getDesc(), PlatformCodeEnum.FAILED_TO_QUERY_GODZILLA_RELATED_DATA_ACCORDING_TO_DATAPOINT.getCode());
        if (result.get("data") != null) {
            Map<Object, Object> data = (Map<Object, Object>) result.get("data");
            String alarmRuleName = (String) data.get("alarmRuleNames");
            String alarmRuleId = (String) data.get("alarmRuleIds");
            String aliasEnableAlarm = (String) data.get("aliasEnableAlarm");
            String currentValue = (String) data.get("currentValue");
            if (!StringUtils.isEmpty(currentValue)){
               String currentValueLast =  Double.valueOf(currentValue).doubleValue() + "";
               resultDTO.setCurrentValue(currentValueLast);
            }
            String unit = (String) data.get("unit");
            resultDTO.setAlarmRuleName(alarmRuleName);
            resultDTO.setAlarmRuleId(alarmRuleId);
            resultDTO.setAliasEnableAlarm(aliasEnableAlarm);
            resultDTO.setUnit(unit);
            //查询最大值最小值
            Map<String, Object> resultOne = synSend(queryMaxAndMin, sendInfo, godzillaToken);
            if (resultOne.get("data") != null) {
                List<Map<Object, Object>> dataOne = (List<Map<Object, Object>>) resultOne.get("data");
                if (DataUtils.isListAvali(dataOne)) {
                    ArrayList<AlertRulesDTO> alertList = new ArrayList<AlertRulesDTO>();
                    for (Map<Object, Object> objectObjectMap : dataOne) {
                        AlertRulesDTO alertRulesDTO = new AlertRulesDTO();
                        Map<Object, Object> query = dataOne.get(0);
                        String alarmMaximumValue = (String) query.get("alarmMaximumValue");
                        String alarmMinimumValue = (String) query.get("alarmMinimumValue");
                        Integer compareDuration = (Integer) query.get("compareDuration");
                        String compareTarget = (String) query.get("compareTarget");
                        alertRulesDTO.setAlarmMaximumValue(alarmMaximumValue);
                        alertRulesDTO.setAlarmMinimumValue(alarmMinimumValue);
                        alertRulesDTO.setCompareDuration(compareDuration);
                        alertRulesDTO.setCompareTarget(compareTarget);
                        alertList.add(alertRulesDTO);
                    }
                    resultDTO.setAlarmInfo(alertList);
                    return resultDTO;
                }
            }
            return resultDTO;
        }
        return null;
    }


    public TransferNumberDoBO transferNumber(TransferNumberQuDoBO appId) {
        TransferNumberDoBO resultDTO = new TransferNumberDoBO();
        log.info("查询调用次数，请求参数{}", appId);
        String sendInfo = JSONUtils.jacksonToJson(appId);
        System.out.println("json:" + sendInfo);
        Map result = synSend(transferNumber, sendInfo, godzillaToken);
        handleFailedResult(result, PlatformCodeEnum.QUERY_CALLS_FAILED.getDesc(), PlatformCodeEnum.QUERY_CALLS_FAILED.getCode());
        if (result.get("data") != null) {
            Map data = (Map) result.get("data");
            Integer apiInvocationMaxCountPerDay = (Integer) data.get("apiInvocationMaxCountPerDay");
            Integer apiInvocationCurrentCountPerDay = (Integer) data.get("apiInvocationCurrentCountPerDay");
            Integer notificationCallbackMaxCount = (Integer) data.get("notificationCallbackMaxCount");
            Integer notificationCallbackCurrentCount = (Integer) data.get("notificationCallbackCurrentCount");
            Integer notificationEmailMaxCount = (Integer) data.get("notificationEmailMaxCount");
            Integer notificationEmailCurrentCount = (Integer) data.get("notificationEmailCurrentCount");
            Integer notificationSmsMaxCount = (Integer) data.get("notificationSmsMaxCount");
            Integer notificationSmsCurrentCount = (Integer) data.get("notificationSmsCurrentCount");
            Integer notificationVoiceMaxCount = (Integer) data.get("notificationVoiceMaxCount");
            Integer notificationVoiceCurrentCount = (Integer) data.get("notificationVoiceCurrentCount");
            if (apiInvocationMaxCountPerDay == null) {
                resultDTO.setApiNumber(0);
            } else {
                resultDTO.setApiNumber(apiInvocationMaxCountPerDay);
            }
            if (apiInvocationCurrentCountPerDay == null) {
                resultDTO.setApiUseNumber(0);
            } else {
                resultDTO.setApiUseNumber(apiInvocationCurrentCountPerDay);
            }
            if (notificationCallbackMaxCount == null) {
                resultDTO.setCallbackNumber(0);
            } else {
                resultDTO.setCallbackNumber(notificationCallbackMaxCount);
            }
            if (notificationCallbackCurrentCount == null) {
                resultDTO.setCallbackUseNumber(0);
            } else {
                resultDTO.setCallbackUseNumber(notificationCallbackCurrentCount);
            }
            if (notificationEmailMaxCount == null) {
                resultDTO.setEmailNumber(0);
            } else {
                resultDTO.setEmailNumber(notificationEmailMaxCount);
            }
            if (notificationEmailCurrentCount == null) {
                resultDTO.setEmailUseNumber(0);
            } else {
                resultDTO.setEmailUseNumber(notificationEmailCurrentCount);
            }
            if (notificationSmsMaxCount == null) {
                resultDTO.setSmsNumber(0);
            } else {
                resultDTO.setSmsNumber(notificationSmsMaxCount);
            }
            if (notificationSmsCurrentCount == null) {
                resultDTO.setSmsUseNumber(0);
            } else {
                resultDTO.setSmsUseNumber(notificationSmsCurrentCount);
            }
            if (notificationVoiceMaxCount == null) {
                resultDTO.setVoiceNumber(0);
            } else {
                resultDTO.setVoiceNumber(notificationVoiceMaxCount);
            }
            if (notificationVoiceCurrentCount == null) {
                resultDTO.setVoiceUseNumber(0);
            } else {
                resultDTO.setVoiceUseNumber(notificationVoiceCurrentCount);
            }
        } else {
            resultDTO.setApiNumber(0);
            resultDTO.setApiUseNumber(0);
            resultDTO.setCallbackNumber(0);
            resultDTO.setCallbackUseNumber(0);
            resultDTO.setEmailNumber(0);
            resultDTO.setEmailUseNumber(0);
            resultDTO.setSmsNumber(0);
            resultDTO.setSmsUseNumber(0);
            resultDTO.setVoiceNumber(0);
            resultDTO.setVoiceUseNumber(0);
        }
        return resultDTO;
    }

}
