package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.security.dto.QueryAlarmRecordDTO;
import com.ifourthwall.dbm.security.dto.QueryAlarmRecordQuDTO;
import com.ifourthwall.dbm.security.dto.QueryCameraListDTO;
import com.ifourthwall.dbm.security.dto.QueryCameraListQuDTO;
import com.ifourthwall.dbm.security.facade.CameraFacade;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordDoBO;
import com.ifourthwall.dbm.sentry.bo.camera.QueryAlarmRecordQuDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

/**
 * @Author: hao.dai
 * @Date: 2019/12/4 10:37
 * @Description:
 */
@Slf4j
@Repository("CameraRepository")
public class CameraRepository {


    @Reference(version = "1.0.0")
    private CameraFacade cameraFacade;

    /**
     * 查询摄像头列表
     * @Author: YangPeng
     * @Date: 2020/10/21 16:57
     * @param query
     * @return com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.security.dto.QueryCameraListDTO>
     * @throws
     */
    public IFWPageInfo<QueryCameraListDTO> queryCameraList(QueryCameraListQuDTO query) {
        log.info("接口 queryCameraList ,接受参数:{}", query);
        BaseResponse<IFWPageInfo<QueryCameraListDTO>> response = cameraFacade.queryCameraList(query);
        log.info("接口 queryCameraList ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData().getList())){
            return response.getData();
        }
        return null;
    }

    /**
     * 查询摄像头告警记录
     *
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.security.dto.QueryAlarmRecordDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/5/6 16:45
     */
    public IFWPageInfo<QueryAlarmRecordDoBO> queryAlarmRecord(QueryAlarmRecordQuDoBO map) {
        IFWPageInfo<QueryAlarmRecordDoBO> resultPage = new IFWPageInfo<>();
        log.info("接口 queryAlarmRecord ,接受参数:{}", map);
        BaseResponse<IFWPageInfo<QueryAlarmRecordDTO>> response = cameraFacade.queryAlarmRecord(IFWBeanCopyUtil.map(map, QueryAlarmRecordQuDTO.class));
        log.info("接口 queryAlarmRecord ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData().getList())){
            BeanUtils.copyProperties(response.getData(),resultPage,"list");
            resultPage.setList(IFWBeanCopyUtil.mapAsList(response.getData().getList(),QueryAlarmRecordDoBO.class));
            return resultPage;
        }
        return null;
    }


}
