package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListQuDTO;
import com.ifourthwall.dbm.asset.facade.AssetAppFacade;
import com.ifourthwall.dbm.asset.facade.AssetFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/12/4 10:37
 * @Description:
 */
@Slf4j
@Repository("AssetRepository")
public class AssetRepository {


    @Reference(version = "1.0.0")
    private AssetFacade assetFacade;

    @Reference(version = "1.0.0")
    private AssetAppFacade assetAppFacade;

    /**
     * 查询资产信息
     *
     * @param assetInfo
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     */
    public QueryAssetInfoDoBO queryAssetInfo(AssetInfoQueryDoBO assetInfo) {
        QueryAssetInfoDoBO resultBO = new QueryAssetInfoDoBO();
        //组装请求参数
        QueryAssetInfoQueryDTO queryAsset = new QueryAssetInfoQueryDTO();
        BeanUtils.copyProperties(assetInfo, queryAsset);
        log.info("接口 queryAssetInfo ,接受参数:{}", assetInfo);
        BaseResponse<QueryAssetInfoDTO> response = assetFacade.queryAssetInfo(queryAsset);
        log.info("接口 queryAssetInfo ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            BeanUtils.copyProperties(response.getData(), resultBO);
            return resultBO;
        }
        return resultBO;
    }

    /**
     * 查询资产列表
     *
     * @param assetList
     * @return com.github.pagehelper.PageInfo<com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryAssetInfoBO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     */
    public IFWPageInfo<QueryAssetInfoBO> queryAssetList(QueryAssetListQueryBO assetList) {
        IFWPageInfo<QueryAssetInfoBO> resultPage = new IFWPageInfo<>();
        log.info("接口 queryAssetList ,接受参数:{}", assetList);
        BaseResponse<IFWPageInfo<QueryAssetListDTO>> pageInfoBaseResponse = assetFacade.queryAssetList(IFWBeanCopyUtil.map(assetList, QueryAssetListQueryDTO.class));
        log.info("接口 queryAssetList ,返回结果:{}", pageInfoBaseResponse);
        if (!pageInfoBaseResponse.isFlag()) {
            throw new BizException(pageInfoBaseResponse.getRetMsg(), pageInfoBaseResponse.getRetCode());
        }
        BeanUtils.copyProperties(pageInfoBaseResponse.getData(), resultPage, "list");
        if (DataUtils.isListAvali(pageInfoBaseResponse.getData().getList())) {
            List<QueryAssetInfoBO> resultList = IFWBeanCopyUtil.mapAsList(pageInfoBaseResponse.getData().getList(), QueryAssetInfoBO.class);
            resultPage.setList(resultList);
            return resultPage;
        }
        return null;
    }

    /**
     * 更新资产状态
     * @Author: YangPeng
     * @Date: 2020/1/13 13:47
     * @param upInsertAsset
     * @return void
     * @throws
     */
    public void upAssetStatus(UpAssetStatusDoBO upInsertAsset) {
        log.info("接口 UpAssetStatusDoBO ,接受参数:{}", upInsertAsset);
        BaseResponse response = assetFacade.upAssetStatus(IFWBeanCopyUtil.map(upInsertAsset, UpAssetStatusDTO.class));
        log.info("接口 UpAssetStatusDoBO ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
    }


    /**
     * 查询资产系统列表
     * @Author: YangPeng
     * @Date: 2020/4/3 14:15
     * @param assetTag
     * @return com.ifourthwall.dbm.asset.dto.PageDTO<com.ifourthwall.dbm.sentry.bo.QueryAssetInfoDoBO>
     * @throws
     */
    public PageDTO<QueryTagListDoBO> queryAssetTag(QueryTagListQuDoBO assetTag) {
        PageDTO<QueryTagListDoBO> resultPage = new PageDTO<>();
        //组装请求参数
        QueryTagListQuDTO queryAssetTag = new QueryTagListQuDTO();
        BeanUtils.copyProperties(assetTag, queryAssetTag);
        log.info("接口 queryAssetList ,接受参数:{}", assetTag);
        BaseResponse<PageDTO<QueryTagListDTO>> response = assetFacade.queryTagList(queryAssetTag);
        log.info("接口 queryAssetList ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData().getResult())) {
            BeanUtils.copyProperties(response.getData(),resultPage,"result");
            resultPage.setResult(IFWBeanCopyUtil.mapAsList(response.getData().getResult(),QueryTagListDoBO.class));
        }
        return resultPage;
    }

    /**
     * 查询翻译
     * @Author: YangPeng
     * @Date: 2020/6/17 16:57
     * @param translation
     * @return com.ifourthwall.dbm.sentry.bo.AllTranslationDoBO
     * @throws
     */
    public AllTranslationDoBO allTranslation(TranslationDoBO translation) {
        log.info("接口 translation ,接受参数:{}", translation);
        BaseResponse<AllTranslationDTO> response = assetFacade.allTranslation(IFWBeanCopyUtil.map(translation,TranslationDTO.class));
        log.info("接口 translation ,返回结果:{}", response);
        return IFWBeanCopyUtil.map(response.getData(),AllTranslationDoBO.class);
    }

    /**
     * 通过资产查询资产及抄表信息
     * @Author: YangPeng
     * @Date: 2020/8/31 10:12
     * @param assetList
     * @return java.util.List<com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO>
     * @throws
     */
    public List<QueryAssetAppListDTO> queryAssetAppList(QueryAssetAppListQuDTO assetList) {
        log.info("接口 queryAssetAppList ,接受参数:{}", assetList);
        BaseResponse<List<QueryAssetAppListDTO>> response = assetAppFacade.queryAssetAppList(assetList);
        log.info("接口 queryAssetAppList ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())) {
            return response.getData();
        }
        return null;
    }
}
