package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.seer.*;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyComparedGraphQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsDTO;
import com.ifourthwall.dbm.asset.dto.seer.energy.QueryEnergyStatisticsQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateDTO;
import com.ifourthwall.dbm.asset.dto.sentry.AlertNumberRankingByDateQuDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageDTO;
import com.ifourthwall.dbm.asset.dto.sentry.MonitorPercentageQuDTO;
import com.ifourthwall.dbm.sentry.service.SeerService;
import com.ifourthwall.dbm.sentry.service.SentryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "Sentry统计相关接口", value = "SentryController")
@RequestMapping("/dbm/sentry/statistics")
public class SentryController {

    @Resource(name = "SentryServiceImpl")
    private SentryService sentryService;

    @ApiOperation(value = "折线图统计-设备异常数",notes = "杨鹏")
    @PostMapping("/query/line/chart")
    public ResponseEntity<BaseResponse<List<QueryLineChartDTO>>> queryLineChart(@Valid @RequestBody QueryLineChartQuDTO query, IFWUser user){
        log.info("接口 /dbm/sentry/statistics/query/line/chart 接受参数:{}",query);
        BaseResponse<List<QueryLineChartDTO>> response = sentryService.queryLineChart(query,user);
        log.info("接口 /dbm/sentry/statistics/query/line/chart 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "折线图统计-设备返修率",notes = "杨鹏")
    @PostMapping("/query/line/chart/repair")
    public ResponseEntity<BaseResponse<List<QueryLineChartRepairDTO>>> queryLineChartRepair(@Valid @RequestBody QueryLineChartRepairQuDTO query, IFWUser user){
        log.info("接口 /dbm/sentry/statistics/query/line/chart/repair 接受参数:{}",query);
        BaseResponse<List<QueryLineChartRepairDTO>> response = sentryService.queryLineChartRepair(query,user);
        log.info("接口 /dbm/sentry/statistics/query/line/chart/repair 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "告警次数排行",notes = "杨鹏")
    @PostMapping("/query/asset/number/rank")
    public ResponseEntity<BaseResponse<AlertNumberRankingByDateDTO>> alertNumberRankingByDate(@RequestBody @Valid AlertNumberRankingByDateQuDTO rankingQuDTO, IFWUser user){
        log.info("接口 /dbm/sentry/statistics/query/asset/number/rank 接受参数:{}",rankingQuDTO);
        BaseResponse<AlertNumberRankingByDateDTO> response = sentryService.alertNumberRankingByDate(rankingQuDTO,user);
        log.info("接口 /dbm/sentry/statistics/query/asset/number/rank 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "监测设备占比",notes = "杨鹏")
    @PostMapping("/query/asset/percentage")
    public ResponseEntity<BaseResponse<MonitorPercentageDTO>> monitorPercentage(@RequestBody @Valid MonitorPercentageQuDTO query, IFWUser user){
        log.info("接口 /dbm/sentry/statistics/query/asset/percentage 接受参数:{}",query);
        BaseResponse<MonitorPercentageDTO> response = sentryService.monitorPercentage(query,user);
        log.info("接口 /dbm/sentry/statistics/query/asset/percentage 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "seer设备统计折线图",notes = "杨鹏")
    @PostMapping("/query/seer/line/chart")
    public ResponseEntity<BaseResponse<QuerySeerLineChartDTO>> querySeerLineChart(@RequestBody @Valid QuerySeerLineChartQuDTO query, IFWUser user){
        log.info("接口 /dbm/sentry/statistics/query/seer/line/chart 接受参数:{}",query);
        BaseResponse<QuerySeerLineChartDTO> response = sentryService.querySeerLineChart(query,user);
        log.info("接口 /dbm/sentry/statistics/query/seer/line/chart 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }
}
