package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.seer.*;
import com.ifourthwall.dbm.asset.dto.seer.energy.*;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoDTO;
import com.ifourthwall.dbm.asset.dto.seer.sq.QuerySqEnvironmentInfoQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorService;
import com.ifourthwall.dbm.sentry.service.SeerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "Seer相关接口", value = "SeerController")
@RequestMapping("/dbm/sentry/seer")
public class SeerController {

    @Resource(name = "SeerServiceImpl")
    private SeerService seerService;

    @ApiOperation(value = "seer空间标签",notes = "杨鹏")
    @PostMapping("/query/tag")
    public ResponseEntity<BaseResponse<List<SeerQueryTagDTO>>> seerQueryTag(@Valid @RequestBody SeerQueryTagQuDTO query, IFWUser user){
        log.info("接口 seerQueryTag 接受参数:{}",query);
        BaseResponse response = seerService.seerQueryTag(query,user);
        log.info("接口 seerQueryTag 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

//    @ApiOperation(value = "根据标签查询指标统计",notes = "杨鹏")
//    @PostMapping("/query/index/statistics")
//    public ResponseEntity<BaseResponse<QueryIndexStatisticsDTO>> queryIndexStatistics(@Valid @RequestBody QueryIndexStatisticsQuDTO query, IFWUser user){
//        log.info("接口 queryIndexStatistics 接受参数:{}",query);
//        BaseResponse response = seerService.queryIndexStatistics(query,user);
//        log.info("接口 queryIndexStatistics 返回参数:{}",response);
//        return ResponseEntity.ok(response);
//    }

    @ApiOperation(value = "根据标签查询排行",notes = "杨鹏")
    @PostMapping("/query/index/rank")
    public ResponseEntity<BaseResponse<List<QueryIndexRankingDTO>>> queryIndexRanking(@Valid @RequestBody QueryIndexRankingQuDTO query,IFWUser user){
        log.info("接口 queryIndexRanking 接受参数:{}");
        BaseResponse response = seerService.queryIndexRanking(query,user);
        log.info("接口 queryIndexRanking 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "环境统计",notes = "杨鹏")
    @PostMapping("/query/environment")
    public ResponseEntity<BaseResponse<QueryEnvironmentDTO>> queryEnvironment(@Valid @RequestBody QueryEnvironmentBasisQuDTO query, IFWUser user){
        log.info("接口 queryEnvironment 接受参数:{}");
        BaseResponse<QueryEnvironmentDTO> response = seerService.queryEnvironment(query,user);
        log.info("接口 queryEnvironment 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "环境统计列表",notes = "杨鹏")
    @PostMapping("/query/environment/list")
    public ResponseEntity<BaseResponse<List<EnvironmentListDTO>>> queryEnvironmentList(@Valid @RequestBody QueryEnvironmentListQuDTO query, IFWUser user){
        log.info("接口 queryEnvironmentList 接受参数:{}",query);
        BaseResponse<List<EnvironmentListDTO>> response = seerService.queryEnvironmentList(query,user);
        log.info("接口 queryEnvironmentList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "门磁-空间安全监测",notes = "杨鹏")
    @PostMapping("/query/induction/info")
    public ResponseEntity<BaseResponse<QueryInductionDTO>> queryInduction(@Valid @RequestBody QueryInductionQuDTO query, IFWUser user){
        log.info("接口 queryInduction 接受参数:{}",query);
        BaseResponse<QueryInductionDTO> response = seerService.queryInduction(query,user);
        log.info("接口 queryInduction 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "门磁-空间列表",notes = "杨鹏")
    @PostMapping("/query/induction/list")
    public ResponseEntity<BaseResponse<List<QueryInductionListDTO>>> queryInductionList(@Valid @RequestBody QueryInductionListQuDTO query, IFWUser user){
        log.info("接口 queryInductionList 接受参数:{}",query);
        BaseResponse<List<QueryInductionListDTO>> response = seerService.queryInductionList(query,user);
        log.info("接口 queryInductionList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "能耗-能耗统计",notes = "杨鹏")
    @PostMapping("/query/energy/statistics")
    public ResponseEntity<BaseResponse<QueryEnergyStatisticsDTO>> queryEnergyStatistics(@Valid @RequestBody QueryEnergyStatisticsQuDTO query, IFWUser user){
        log.info("接口 queryEnergyStatistics 接受参数:{}",query);
        BaseResponse<QueryEnergyStatisticsDTO> response = seerService.queryEnergyStatistics(query,user);
        log.info("接口 queryEnergyStatistics 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "能耗-能耗对比曲线",notes = "杨鹏")
    @PostMapping("/query/energy/compared/graph")
    public ResponseEntity<BaseResponse<QueryEnergyComparedGraphDTO>> queryEnergyComparedGraph(@Valid @RequestBody QueryEnergyComparedGraphQuDTO query, IFWUser user){
        log.info("接口 queryEnergyComparedGraph 接受参数:{}",query);
        BaseResponse<QueryEnergyComparedGraphDTO> response = seerService.queryEnergyComparedGraph(query,user);
        log.info("接口 queryEnergyComparedGraph 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

//    @ApiOperation(value = "能耗-能耗对比",notes = "杨鹏")
//    @PostMapping("/query/energy/compared")
//    public ResponseEntity<BaseResponse<List<QueryInductionListDTO>>> queryEnergyCompared(@Valid @RequestBody QueryInductionListQuDTO query, IFWUser user){
//        log.info("接口 queryEnergyCompared 接受参数:{}");
//        BaseResponse<List<QueryInductionListDTO>> response = seerService.queryEnergyCompared(query,user);
//        log.info("接口 queryEnergyCompared 返回参数:{}",response);
//        return ResponseEntity.ok(response);
//    }
//
//    @ApiOperation(value = "能耗-重点设备能耗",notes = "杨鹏")
//    @PostMapping("/query/energy/focus/asset/info")
//    public ResponseEntity<BaseResponse<List<QueryInductionListDTO>>> queryEnergyFocusAssetInfo(@Valid @RequestBody QueryInductionListQuDTO query, IFWUser user){
//        log.info("接口 queryEnergyFocusAssetInfo 接受参数:{}");
//        BaseResponse<List<QueryInductionListDTO>> response = seerService.queryEnergyFocusAssetInfo(query,user);
//        log.info("接口 queryEnergyFocusAssetInfo 返回参数:{}",response);
//        return ResponseEntity.ok(response);
//    }

    @ApiOperation(value = "上汽-环境统计",notes = "杨鹏")
    @PostMapping("/sq/query/environment/info")
    public ResponseEntity<BaseResponse<List<QuerySqEnvironmentInfoDTO>>> querySqEnvironmentInfo(@Valid @RequestBody QuerySqEnvironmentInfoQuDTO query, IFWUser user){
        log.info("接口 querySqEnvironmentInfo 接受参数:{}",query);
        BaseResponse<List<QuerySqEnvironmentInfoDTO>> response = seerService.querySqEnvironmentInfo(query,user);
        log.info("接口 querySqEnvironmentInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "统计接口",notes = "杨鹏")
    @PostMapping("/sq/query/environment/line/chart")
    public ResponseEntity<BaseResponse> sqDepositSenrtyInfo(@Valid @RequestBody SqDepositSenrtyInfoDTO query, IFWUser user){
        log.info("接口 sqDepositSenrtyInfo 接受参数:{}",query);
        BaseResponse response = seerService.sqDepositSenrtyInfo(query,user);
        log.info("接口 sqDepositSenrtyInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


    @ApiOperation(value = "外部标签数据迁移",notes = "杨鹏")
    @PostMapping("/seer/tag/move")
    public ResponseEntity<BaseResponse> seerTagMove(@Valid @RequestBody SeerTagMoveDTO query, IFWUser user){
        log.info("接口 seerTagMove 接受参数:{}",query);
        BaseResponse response = seerService.seerTagMove(query,user);
        log.info("接口 seerTagMove 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

}
