package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorReadingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "抄表相关接口", value = "MonitorController")
@RequestMapping("/dbm/sentry")
public class MonitorReadingController {

    @Resource(name = "MonitorReadingServiceImpl")
    private MonitorReadingService monitorReadingService;


    @ApiOperation(value = "tracker离线包数据-抄表",notes = "杨鹏")
    @PostMapping("/query/tracker/offline")
    public ResponseEntity<BaseResponse<List<TrackerMeterReadingInfoDTO>>> trackerOfflineMeterReading(@Valid @RequestBody TrackerMeterReadingQuDTO trackerOffline,IFWUser user){
        log.info("接口 trackerOfflineMeterReading 接受参数:{}",trackerOffline);
        BaseResponse<List<TrackerMeterReadingInfoDTO>> response = monitorReadingService.trackerOfflineMeterReading(trackerOffline,user);
        log.info("接口 trackerOfflineMeterReading 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


    @ApiOperation(value = "根据资产查询绑定指标",notes = "杨鹏")
    @PostMapping("/query/metric/by/asset")
    public ResponseEntity<BaseResponse<List<QueryMetricByAssetDTO>>> queryMetricByAsset(@Valid @RequestBody QueryMetricByAssetQuDTO queryMetricByAsset, IFWUser user){
        log.info("接口 queryMetricByAsset 接受参数:{}",queryMetricByAsset);
        BaseResponse<List<QueryMetricByAssetDTO>> response = monitorReadingService.queryMetricByAsset(queryMetricByAsset,user);
        log.info("接口 queryMetricByAsset 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


}
