package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.CheckDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryCreateTaskDTO;
import com.ifourthwall.dbm.sentry.bo.QueryByDataPointDTO;
import com.ifourthwall.dbm.sentry.bo.QueryByDataPointQuBO;
import com.ifourthwall.dbm.sentry.dto.QueryByDataPointQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorMetricService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @Author: YangPeng
 * @Date: 2020/9/4 09:43
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "sentry-点位相关接口", value = "MonitorMetricController")
@RequestMapping("/dbm/sentry/metric")
public class MonitorMetricController {

    @Resource(name = "MonitorMetricServiceImpl")
    private MonitorMetricService metricService;

    @ApiOperation(value = "检查点位是否又被使用",notes = "杨鹏")
    @PostMapping("/check/datapoint")
    public ResponseEntity<BaseResponse<CheckDataPointIdDTO>> checkDataPointId(@RequestBody @Valid CheckDataPointIdQuDTO query, IFWUser user){
        log.info("接口 checkDataPointId 接受参数:{}",query);
        BaseResponse<CheckDataPointIdDTO> response = metricService.checkDataPointId(query,user);
        log.info("接口 checkDataPointId 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "通过点位查看信息",notes = "杨鹏")
    @PostMapping("/query/by/data/point")
    public ResponseEntity<BaseResponse<QueryByDataPointDTO>> queryByDataPoint(@Valid @RequestBody QueryByDataPointQuDTO query, IFWUser user){
        log.info("接口 queryByDataPoint 接受参数:{}",query);
        BaseResponse<QueryByDataPointDTO> response = metricService.queryByDataPoint(query,user);
        log.info("接口 queryByDataPoint 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "手动发起工单",notes = "杨鹏")
    @PostMapping("/create/task")
    public ResponseEntity<BaseResponse> sentryCreateTask(@Valid @RequestBody SentryCreateTaskDTO create, IFWUser user){
        log.info("接口 sentryCreateTask 接受参数:{}",create);
        BaseResponse response = metricService.sentryCreateTask(create,user);
        log.info("接口 sentryCreateTask 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }
}
