package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingInfoDTO;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingQuDTO;
import com.ifourthwall.dbm.asset.dto.godzilla.*;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetDTO;
import com.ifourthwall.dbm.asset.dto.meter.QueryMetricByAssetQuDTO;
import com.ifourthwall.dbm.sentry.service.MonitorGodzillaService;
import com.ifourthwall.dbm.sentry.service.MonitorReadingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "哥斯拉相关接口", value = "MonitorGodzillaController")
@RequestMapping("/dbm/sentry/godzilla")
public class MonitorGodzillaController {

    @Resource(name = "MonitorGodzillaServiceImpl")
    private MonitorGodzillaService monitorGodzillaService;

    @ApiOperation(value = "新增触发规则",notes = "杨鹏")
    @PostMapping("/add/rule")
    public ResponseEntity<BaseResponse> addMaxAndMin(@Valid @RequestBody AddMaxAndMinDTO add, IFWUser user){
        log.info("接口 addMaxAndMin 接受参数:{}",add);
        BaseResponse response = monitorGodzillaService.addMaxAndMin(add,user);
        log.info("接口 addMaxAndMin 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "修改触发规则",notes = "杨鹏")
    @PostMapping("/update/rule")
    public ResponseEntity<BaseResponse> updateMaxAndMin(@Valid @RequestBody UpdateMaxAndMinDTO update, IFWUser user){
        log.info("接口 updateMaxAndMin 接受参数:{}",update);
        BaseResponse response = monitorGodzillaService.updateMaxAndMin(update,user);
        log.info("接口 updateMaxAndMin 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "删除触发规则",notes = "杨鹏")
    @PostMapping("/delete/rule")
    public ResponseEntity<BaseResponse> deleteMaxAndMin(@Valid @RequestBody DeleteMaxAndMinDTO delete, IFWUser user){
        log.info("接口 deleteMaxAndMin 接受参数:{}",delete);
        BaseResponse response = monitorGodzillaService.deleteMaxAndMin(delete,user);
        log.info("接口 deleteMaxAndMin 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询触发规则",notes = "杨鹏")
    @PostMapping("/query/rule")
    public ResponseEntity<BaseResponse<List<QueryMaxAndMinDTO>>> queryMaxAndMin(@Valid @RequestBody QueryMaxAndMinQuDTO query, IFWUser user){
        log.info("接口 queryMaxAndMin 接受参数:{}",query);
        BaseResponse<List<QueryMaxAndMinDTO>> response = monitorGodzillaService.queryMaxAndMin(query,user);
        log.info("接口 queryMaxAndMin 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


}
