package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.dashboard.*;
import com.ifourthwall.dbm.sentry.service.DashboardDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "Sentry仪表盘数据查询接口", value = "DashboardController")
@RequestMapping("/dbm/sentry/dashboard/data")
public class DashboardDataController {

    @Resource(name = "DashboardDataServiceImpl")
    private DashboardDataService dashboardDataService;

    @ApiOperation(value = "Sentry仪表盘数据查询",notes = "杨鹏")
    @PostMapping("/query")
    public ResponseEntity<BaseResponse<DashboardQueryDataDTO>> queryData(@Valid @RequestBody DashboardQueryDataQuDTO inseret, IFWUser user){
        log.info("接口 queryData 接受参数:{}",inseret);
        BaseResponse<DashboardQueryDataDTO> response = dashboardDataService.queryData(inseret,user);
        log.info("接口 queryData 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


}
