package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.dashboard.*;
import com.ifourthwall.dbm.sentry.service.DashboardService;
import com.ifourthwall.dbm.sentry.service.SeerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "仪表盘相关接口", value = "DashboardController")
@RequestMapping("/dbm/sentry/dashboard")
public class DashboardController {

    @Resource(name = "DashboardServiceImpl")
    private DashboardService dashboardService;

    @ApiOperation(value = "新增仪表盘",notes = "杨鹏")
    @PostMapping("/insert")
    public ResponseEntity<BaseResponse> insertDashboard(@Valid @RequestBody InsertDashboardDTO inseret, IFWUser user){
        log.info("接口 insertDashboard 接受参数:{}",inseret);
        BaseResponse response = dashboardService.insertDashboard(inseret,user);
        log.info("接口 insertDashboard 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "修改仪表盘",notes = "杨鹏")
    @PostMapping("/update")
    public ResponseEntity<BaseResponse> updateDashboard(@Valid @RequestBody UpdateDashboardDTO update, IFWUser user){
        log.info("接口 updateDashboard 接受参数:{}",update);
        BaseResponse response = dashboardService.updateDashboard(update,user);
        log.info("接口 updateDashboard 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "删除仪表盘",notes = "杨鹏")
    @PostMapping("/delete")
    public ResponseEntity<BaseResponse> deleteDashboard(@Valid @RequestBody DeleteDashboardDTO delete, IFWUser user){
        log.info("接口 deleteDashboard 接受参数:{}",delete);
        BaseResponse response = dashboardService.deleteDashboard(delete,user);
        log.info("接口 deleteDashboard 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询仪表盘（不包括panel）",notes = "杨鹏")
    @PostMapping("/query")
    public ResponseEntity<BaseResponse<IFWPageInfo<DashboardPanelDTO>>> queryDashboardPanel(@Valid @RequestBody QueryDashboardPanelQuDTO query, IFWUser user){
        log.info("接口 queryDashboardPanel 接受参数:{}",query);
        BaseResponse<IFWPageInfo<DashboardPanelDTO>> response = dashboardService.queryDashboardPanel(query,user);
        log.info("接口 queryDashboardPanel 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询模块",notes = "杨鹏")
    @PostMapping("/query/info")
    public ResponseEntity<BaseResponse<QueryDashboardDTO>> queryDashboard(@Valid @RequestBody QueryDashboardQuDTO query, IFWUser user){
        log.info("接口 queryDashboard 接受参数:{}",query);
        BaseResponse<QueryDashboardDTO> response = dashboardService.queryDashboard(query,user);
        log.info("接口 queryDashboard 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "新增模块",notes = "杨鹏")
    @PostMapping("/panel/insert")
    public ResponseEntity<BaseResponse> insertPanel(@Valid @RequestBody InsertDashboardPanelDTO inseret, IFWUser user){
        log.info("接口 insertPanel 接受参数:{}",inseret);
        BaseResponse response = dashboardService.insertPanel(inseret,user);
        log.info("接口 insertPanel 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "修改模块",notes = "杨鹏")
    @PostMapping("/panel/update")
    public ResponseEntity<BaseResponse> updatePanel(@Valid @RequestBody UpdatePanelDTO update, IFWUser user){
        log.info("接口 updatePanel 接受参数:{}",update);
        BaseResponse response = dashboardService.updatePanel(update,user);
        log.info("接口 updatePanel 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "删除模块",notes = "杨鹏")
    @PostMapping("/panel/delete")
    public ResponseEntity<BaseResponse> deletePanel(@Valid @RequestBody DeletePanelDTO delete, IFWUser user){
        log.info("接口 deletePanel 接受参数:{}",delete);
        BaseResponse response = dashboardService.deletePanel(delete,user);
        log.info("接口 deletePanel 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "新增仪表盘-非自定义",notes = "杨鹏")
    @PostMapping("/non/custom/insert")
    public ResponseEntity<BaseResponse> noCustomInsert(@Valid @RequestBody InsertDashboardAndPanelDTO inseret, IFWUser user){
        log.info("接口 noCustomInsert 接受参数:{}",inseret);
        BaseResponse response = dashboardService.noCustomInsert(inseret,user);
        log.info("接口 noCustomInsert 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }
}
