package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.metric.QueryAllDataPointQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.EnvironmentListQuDTO;
import com.ifourthwall.dbm.sentry.dto.DataPointDTO;
import com.ifourthwall.dbm.sentry.dto.DataPointQuDTO;
import com.ifourthwall.dbm.sentry.dto.QueryInfoByDataPointDTO;
import com.ifourthwall.dbm.sentry.dto.QueryMetricIdDTO;
import com.ifourthwall.dbm.sentry.service.MonitorAlarmService;
import com.ifourthwall.dbm.sentry.service.SeerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: YangPeng
 * @Date: 2020/4/15 16:28
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "告警接收", value = "AlarmController")
@RequestMapping("/dbm/ig/sentry")
public class AlarmController {

    @Resource(name = "MonitorAlarmServiceImpl")
    private MonitorAlarmService alarmService;

    @Resource(name = "SeerServiceImpl")
    private SeerService seerService;

    @ApiOperation(value = "接收哥斯拉告警信息(插入基本数据)", notes = "杨鹏")
    @PostMapping("/get/data/point")
    public ResponseEntity<Map<String, Object>> getDataPoint(@RequestBody GetDataPointBasisOneQueryDTO dataPointBasis) {
        log.info("接口 getDataPoint 接受参数:{}", dataPointBasis);
        BaseResponse response = alarmService.getDataPoint(dataPointBasis);
        log.info("接口 getDataPoint 返回参数:{}", response);
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("flag", true);
        return ResponseEntity.ok(resultMap);
    }

//    @ApiOperation(value = "接收哥斯拉告警信息(自动生成工单)--弃用", notes = "杨鹏")
//    @PostMapping("/send/data/point")
//    public ResponseEntity<BaseResponse> generateTask() {
//        log.info("接口 generateTask 接受参数:{}");
//        BaseResponse response = monitorService.generateTaks();
//        log.info("接口 generateTask 返回参数:{}", response);
//        return ResponseEntity.ok(response);
//    }
//
//    @ApiOperation(value = "接收哥斯拉告警信息(获取工单参数，更新数据库)--弃用", notes = "杨鹏")
//    @PostMapping("/update/data/point")
//    public ResponseEntity<BaseResponse> updateDataPoint(UpMonitorRecordDTO upMonitorRecordDTO) {
//        log.info("接口 updateDataPoint 接受参数:{}", upMonitorRecordDTO);
//        BaseResponse response = monitorService.updateDataPoint(upMonitorRecordDTO);
//        log.info("接口 updateDataPoint 返回参数:{}", response);
//        return ResponseEntity.ok(response);
//    }

    @ApiOperation(value = "查询数据点信息", notes = "杨鹏")
    @PostMapping("/query/datapoint")
    public ResponseEntity<BaseResponse<String>> datapointInfo(@RequestBody EnvironmentListQuDTO query) {
        log.info("接口 datapointInfo 接受参数:{}", query);
        BaseResponse<String> response = alarmService.datapointInfo(query);
        log.info("接口 datapointInfo 返回参数:{}", response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "根据标签查询",notes = "杨鹏")
    @PostMapping("/query/tag/info/list")
    public ResponseEntity<BaseResponse<List<QueryTagInfoListDTO>>> queryTagInfoList(@Valid @RequestBody QueryTagInfoListQuDTO query){
        log.info("接口 queryTagInfoList 接受参数:{}");
        BaseResponse<List<QueryTagInfoListDTO>> response = seerService.queryTagInfoList(query);
        log.info("接口 queryTagInfoList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "根据监控指标id查询监控信息",notes = "杨鹏")
    @PostMapping("/query/metric/id")
    public ResponseEntity<BaseResponse<List<QueryMonitorListDTO>>> queryMetricId(@Valid @RequestBody QueryMetricIdDTO query){
        log.info("接口 queryMetricId 接受参数:{}");
        BaseResponse<List<QueryMonitorListDTO>> response = seerService.queryMetricId(query);
        log.info("接口 queryMetricId 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "根据dataPointId查询哥斯拉信息",notes = "杨鹏")
    @PostMapping("/query/data/by/datepoint")
    public ResponseEntity<BaseResponse<List<QueryInfoByDataPointDTO>>> queryByDataPoint(@Valid @RequestBody QueryMetricIdDTO query){
        log.info("接口 queryByDataPoint 接受参数:{}");
        BaseResponse<List<QueryInfoByDataPointDTO>> response = seerService.queryByDataPoint(query);
        log.info("接口 queryByDataPoint 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

        @ApiOperation(value = "111111111111",notes = "杨鹏")
    @PostMapping("/update/rule")
    public ResponseEntity updateRule(@Valid @RequestBody QueryAllDataPointQuDTO query ){
        BaseResponse response = alarmService.updateRule(query);
        return ResponseEntity.ok(response);
    }

// 这个是部分RPC调用测试接口
//    @ApiOperation(value = "111111111111",notes = "杨鹏")
//    @PostMapping("/update/data/point1")
//    public ResponseEntity inserttt(InsertDashboardAndPanelDTO upMonitorRecordDTO){
//        BaseResponse response = monitorService.inserttt(upMonitorRecordDTO);
//        return ResponseEntity.ok(response);
//    }

}
