package com.ifourthwall.dbm.sentry.bo.metric;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author: hao.dai
 * @Date: 2020/1/2 16:49
 * @Description:
 */
@Data
@ToString
public class MetricValueRecordListReqBO {
    /**
     * 数据点id
     */
    @NotNull(message = "数据点id不能为空")
    private String dataPointId;

    /**
     * 应用id
     */
    @NotNull(message = "应用id不能为空")
    private String appId;
    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    @NotNull(message = "开始时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone= "GMT+8")
    private Date startTime;
    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    @NotNull(message = "结束时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone= "GMT+8")
    private Date endTime;
    /**
     * 每页大小
     */
    private int pageSize;
    /**
     * 页码
     */
    private int pageNum;
}
