package com.ifourthwall.dbm.sentry.bo.alarm;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author: hao.dai
 * @Date: 2020/1/2 17:03
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class AlarmRecordReqBO {
    /**
     * 数据点id
     */
    private String dataPointId;

    /**
     * 设备id
     */
    private String deviceId;
    /**
     * 应用id
     */
    @NotNull(message = "应用id不能为空")
    private String appId;
    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    /**
     * 每页大小
     */
    private int pageSize;
    /**
     * 页码
     */
    private int pageNum;
}
