package com.ifourthwall.dbm.sentry.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/31 10:28
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskInsertDoBO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = "租户Id不能为空")
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目id
     */
    @NotBlank(message = "项目Id不能为空")
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务类型id
     */
    @NotBlank(message = "任务类型Id不能为空")
    @ApiModelProperty(value = "任务类型id",required = true)
    private String taskTypeId;

    /**
     * 任务模版id
     */
    @NotBlank(message = "任务模版Id不能为空")
    @ApiModelProperty(value = "任务模版id",required = true)
    private String taskTemplateId;

    /**
     * 任务名称
     */
    @NotBlank(message = "任务名称不能为空")
    @ApiModelProperty(value = "任务名称",required = true)
    private String taskName;

    /**
     * 任务描述
     */
    @NotBlank(message = "任务描述不能为空")
    @ApiModelProperty(value = "任务描述",required = true)
    private String taskDescription;

    @NotBlank(message = "创建人岗位id不能为空")
    @ApiModelProperty(value = "创建人的岗位id")
    private String createByPositionId;

    @NotBlank(message = "createBy")
    private String createBy;

    @NotBlank(message = "任务创建来源(1.直接创建 2.巡视创建 3.报事创建 4.sentry告警 5.智能监控 6.智能门禁 7.provider报事)")
    private String taskSource;

}
