package com.ifourthwall.dbm.sentry.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/4/24 14:56
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SeerFileQuBO extends BaseReqDTO {

    @ApiModelProperty("数据点")
    @NotNull(message = "数据点不能为空")
    private String dataPointId;

    @NotNull(message = "开始时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @NotNull(message = "结束时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;

}
