package com.ifourthwall.dbm.sentry.bo;

import com.ifourthwall.dbm.asset.dto.MonitorInfoDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/12 10:48
 * @Description:
 */
@Data
public class QueryMonitorInfoDoBO implements Serializable {

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("监控对象id")
    private String monitorTargetId;

    @ApiModelProperty("监控对象描述")
    private String monitorTargetDesc;

    @ApiModelProperty("是否自动发起工单 0.发 1不发")
    private String autoCreateTemporaryTaskId;

    @ApiModelProperty("是否自动发起工单 0.发 1不发")
    private String autoCreateTemporaryTaskName;

    @ApiModelProperty("工单模板id")
    private String taskTemplateId;

    @ApiModelProperty("点位名字")
    private String assetName;

    @ApiModelProperty("空间Id")
    private String spaceId;

    @ApiModelProperty("资产系统id")
    private String assetTagId;

    @ApiModelProperty("资产系统名字")
    private String assetTagName;

    @ApiModelProperty("监控点信息")
    private List<MonitorInfoDTO> monitorMetricInfo;

    @ApiModelProperty("系统id")
    private String assetSystemId;

    @ApiModelProperty("系统名称")
    private String systemName;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("设备类型名称")
    private String equipmentTypeName;

    @ApiModelProperty("监控类型0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("监控类型")
    private String assetCategoryName;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

}
