package com.ifourthwall.dbm.sentry.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2020/9/15 15:44
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class PushMessageSentryBO implements Serializable {

    @ApiModelProperty("设备发生告警时间")
    private String time;

    @ApiModelProperty("检测设备名称")
    private String assetName;

    @ApiModelProperty("检测指标名称")
    private String monitorMetricName;

    @ApiModelProperty("空间位置")
    private String spaceName;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("告警内容")
    private String messageInfo;

    @ApiModelProperty("告警状态 alerting 异常 ，ok 正常")
    private String sentryStatus;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目Id")
    private String projectId;

    @ApiModelProperty("消息类型")
    private String messageType;

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("监控对象id")
    private String monitorTargetId;

    @ApiModelProperty("dataPointId")
    private String dataPointId;
}
