package com.ifourthwall.dbm.sentry.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/24 16:28
 * @Description:
 */
@Data
public class CreateTaskQueryDTO implements Serializable {


    /**
     * 任务基本信息
     */
    @Valid
    @NotNull(message = "任务基本信息不能为空")
    private TaskInsertDoBO task;

    /**
     * 任务空间信息
     */
    @ApiModelProperty(value = "任务空间信息（临时任务、计划任务传）")
    private List<TaskSpaceInsertBO> taskSpaceList;

    private List<String> assetIdList;

}
