/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.message.sms.config;

import com.ifourthwall.message.sms.SendSMSService;
import com.ifourthwall.message.sms.config.SMSProperties;
import com.ifourthwall.message.sms.config.SMSProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="ifw.sms.config", name={"enable"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={SMSProperty.class})
public class SendSMSConfig {
    @Autowired
    private SMSProperty smsProperty;

    @Bean
    public SendSMSService sendSMSService() {
        if (CollectionUtils.isEmpty(this.smsProperty.getConfig())) {
            throw new IllegalArgumentException("sms\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        HashMap<String, List<SMSProperties>> smsPropertiesMap = new HashMap<String, List<SMSProperties>>();
        ArrayList<SMSProperties> defaultSMSProperties = new ArrayList<SMSProperties>();
        for (SMSProperties smsProperties : this.smsProperty.getConfig()) {
            ArrayList<SMSProperties> smsPropertiesList = (ArrayList<SMSProperties>)smsPropertiesMap.get(smsProperties.getCountryCode());
            if (CollectionUtils.isEmpty((Collection)smsPropertiesList)) {
                smsPropertiesList = new ArrayList<SMSProperties>();
                smsPropertiesList.add(smsProperties);
                smsPropertiesMap.put(smsProperties.getCountryCode(), smsPropertiesList);
            } else {
                smsPropertiesList.add(smsProperties);
            }
            if (!smsProperties.isAsDefaultTemplate() || !smsProperties.isDefaultSelected()) continue;
            defaultSMSProperties.add(smsProperties);
        }
        if (CollectionUtils.isEmpty(defaultSMSProperties)) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u6307\u5b9a\u9ed8\u8ba4\u6a21\u677f");
        }
        SendSMSService sendSMSService = new SendSMSService(smsPropertiesMap, defaultSMSProperties);
        return sendSMSService;
    }
}

