package com.ifourthwall.common.utils;

import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.impl.DefaultMapperFactory;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/8/9 13:58
 * @Description:
 */
public class IFWBeanCopyUtil {
    public static final MapperFacade MAPPER_FACADE;

    static {
        MAPPER_FACADE = new DefaultMapperFactory.Builder().build().getMapperFacade();
    }

    public static <S, D> D map(S source, Class<D> destinationClass) {
        return MAPPER_FACADE.map(source, destinationClass);
    }

    public static <S, D> void map(S source, D destination) {
        MAPPER_FACADE.map(source, destination);
    }

    public static  <S, D> List<D> mapAsList(Iterable<S> source, Class<D> destinationClass){
        return MAPPER_FACADE.mapAsList(source,destinationClass);
    }
}
