package com.ifourthwall.common.cache;

import org.apache.commons.lang3.StringUtils;

/**
 * @Author: hao.dai
 * @Date: 2019/12/25 10:53
 * @Description:
 */
public class RedisKeyPrefixUtil {
    //告警自动创建临时任务
    public static final String SENTRY_AUTO_CREATE_WORKSHEET_PREFIX = "dbm:sentry:autocreate:worksheet";
    public static final String SPLIT_SYMBOL = ":";
    public static final String TASK_AUTO_CREATE_TASK_PREFIX = "dbm:task:autocreate:task";
    public static final String TRACKER_QUERY_HOME_DATA = "dbm:tracker:query:home:data";

    public static String getSentryAutoCreateTaskPrefix(String alertId) {
        return StringUtils.joinWith(SPLIT_SYMBOL, SENTRY_AUTO_CREATE_WORKSHEET_PREFIX, alertId);
    }

    public static String getTaskAutoCreateTaskPrefix(String alertId){
        return StringUtils.joinWith(SPLIT_SYMBOL,TASK_AUTO_CREATE_TASK_PREFIX,alertId);
    }

    //天气数据(前缀+和风天气方的天气id)
    public static final String QUERY_CITY_WEATHER = "dbm:seer:heweather:weather:city";
    public static String getWeather(String weatherId) {
        return StringUtils.joinWith(SPLIT_SYMBOL, QUERY_CITY_WEATHER, weatherId);
    }

    public static final String getTrackerQueryHomeDataPrefix(String userId){
        return StringUtils.joinWith(TRACKER_QUERY_HOME_DATA,TASK_AUTO_CREATE_TASK_PREFIX,userId);
    }

    //senrty、seer统计界面资产统计数据
    public static final String SENTRY_SEER_ASSET_COUNT_INFO = "dbm:sentry:asset:count:project:type";
    public static String getAssetCountInfoType(String type) {
        return StringUtils.joinWith(SPLIT_SYMBOL, SENTRY_SEER_ASSET_COUNT_INFO, type);
    }

    //senrty、seer统计界面系统排行数据
    public static final String SENTRY_SEER_RANKING_COUNT_INFO = "dbm:sentry:ranking:count:project:type";
    public static String getRankingCountInfoType(String type) {
        return StringUtils.joinWith(SPLIT_SYMBOL, SENTRY_SEER_RANKING_COUNT_INFO, type);
    }

    //seer告警次数排行
    public static final String SENTRY_SEER_ALERT_NUMBER_RANKING = "dbm:sentry:alert:number:ranking";
    public static String getSentrySeerAlertNumberRanking(String type) {
        return StringUtils.joinWith(SPLIT_SYMBOL, SENTRY_SEER_ALERT_NUMBER_RANKING, type);
    }

    //空间创建物件系统
    public static final String DBM_SPACE_INSERT_OBJECT = "dbm:space:insert:object";
    public static String insertObject(String weatherId) {
        return StringUtils.joinWith(SPLIT_SYMBOL, DBM_SPACE_INSERT_OBJECT, weatherId);
    }

    public static final String DBM_TRACKER_UPDATE_SPACE_SPECIAL_WORKSHEET_NUM = "dbm:tracker:update:space:special:worksheet:num";
    public static String getTrackerUpdateSpaceSpecialWorksheetPrefix(String spaceId){
        return StringUtils.joinWith(SPLIT_SYMBOL, DBM_TRACKER_UPDATE_SPACE_SPECIAL_WORKSHEET_NUM, spaceId);
    }

    //sentry自动告警存入redis,更新空间告警数
    public static final String DBM_SENTRY_UPDATE_SPACE_SPECIAL_ALARM_NUM = "dbm:sentry:update:space:special:alarm:num";
    public static String getDbmSentryUpdateSpaceSpecialAlarmNum(String spaceId){
        return StringUtils.joinWith(SPLIT_SYMBOL, DBM_SENTRY_UPDATE_SPACE_SPECIAL_ALARM_NUM, spaceId);
    }


    //uface自动告警存入redis,更新空间告警数
    public static final String DBM_UFACE_UPDATE_SPACE_SPECIAL_ALARM_NUM = "dbm:uface:update:space:special:alarm:num";
    public static String getDbmUfaceUpdateSpaceSpecialAlarmNum(String spaceId){
        return StringUtils.joinWith(SPLIT_SYMBOL, DBM_UFACE_UPDATE_SPACE_SPECIAL_ALARM_NUM, spaceId);
    }

    //senrty、seer统计界面资产统计数据
    public static final String SENTRY_SEER_CAMERA_COUNT_INFO = "dbm:camera:count:project:type";
    public static String getCameraCountInfoType(String type) {
        return StringUtils.joinWith(SPLIT_SYMBOL, SENTRY_SEER_CAMERA_COUNT_INFO, type);
    }

}
