package com.ifourthwall.common;

/**
 * @Author: hao.dai
 * @Date: 2019/8/8 15:45
 * @Description:
 */
public enum PlatformCodeEnum {
    SYS_ERROR("9999", "系统异常|System Error|システム異常"),
    VALIDATION_ERROR("1000", "校验失败|Validation Failure|チェックの失敗"),
    EXECUTE_SUCCESS("10000", "成功|Success|フリゲート"),
    //---------------------Project-----------------------
    NOT_FIND("001","上级id不存在|Superior id does not exist|上級idが存在しない"),
    INSERT_FAILURE("002","新增失败|Add failed|新規追加失敗"),
    UPDATE_FAILURE("003","更新失败|Update failed|更新失敗"),
    DELETE_FAILURE("004","删除失败|failed to delete|削除失敗"),
    SPACE_NOT_FIND("006","该空间不存在，请重新确认|This space does not exist, please reconfirm|空間が存在しません。もう一度確認してください。"),
    CAN_NOT_MOVE( "005","不能移动到子集或者自身|Cannot move to a subset or to itself|サブセットあるいは自分自身に移動できません"),
    PARAMETER_EXCEPTION( "007","参数异常|Parameter abnormality|パラメータ異常"),
    PICTURE_NOT_FIND("008","该图片不存在，无法修改|The picture does not exist and cannot be modified|画像が存在せず、修正ができません"),
    DATA_EXCEPTION("010","数据异常|Abnormal data|データ例外"),
    MOVE_FAILURE("11","移动失败|Move failed|移動の失敗"),
    CREATE_FAILED("12","监控对象创建成功，哥斯拉绑定失败，请重新绑定哥斯拉|The creation of the monitor target was successful, but the linking to the GODZILLA system failed, please link again.|モニター対象の作成が成功したが、GODZILLAシステムへの紐付失敗、再度紐づけてください。"),
    MONITOR_LIST_QUERY_FAILED("13","监控列表查询失败|Monitoring list query failed|リスト照会の失敗"),
    APP_CREATE_REPEAT("14","请勿重复创建AppId!|Don't create AppId repeatedly!|AppIdを繰り返し作成しないでください!"),
    APP_NOT_FIND("15","不存在appId，请申请!|There is no appId, please apply!|appIdがありません。申請してください！"),
    MESSAGE_INCOMPLETE("16","信息不完整，请填写完整信息！|The information is incomplete, please fill in the complete information!|情報が不完全です。完全な情報を入力してください！"),
    UNABLE_SPACE("034","该空间下有资产，无法删除|There are assets under this space and cannot be deleted|スペースに建物があり、削除できません"),
    CANNOT_MOVE_DIFFERENT_SPACE("031","无法移动非同层级的空间|Unable to move spaces at different levels|スペースに建物があり、削除できません"),
    CANNOT_MOVE_SELF("032","无法移动到自身|Unable to move to itself|自分に移動できません"),
    HAVE_SPACE_UNABLE_SPACE("035","该空间下有点位，无法删除|There is a bit under this space that cannot be deleted|このスペースにポイントがあり、削除できません"),
    PRESENCE_TASK_UNABLE_TO_IMPORT("021","该项目下的资产已有任务存在，无法导入|Assets under this project already have tasks and cannot be imported|プロジェクト内の建物に業務が存在し、インポートできません" ),
    PRESENCE_CHECKPOINT_UNABLE_TO_IMPORT("021","该项目下的资产已有点位，无法导入|Assets under this project already have points that cannot be imported|プロジェクト内の建物にポイントが存在し、インポートできません" ),
    MAC_REPEAT("021","mac/UID地址不可重复,重复的编码为|The mac / UID address is not repeatable, the repeated encoding is|mac / UIDアドレスは繰り返し可能ではありません。繰り返しエンコードは" ),
    PROJECT_NOT_FIND("021","无该项目，请重新选择项目|No such item, please re-select the item|プロジェクトがないので、プロジェクトを再選択してください" ),
    SPACE_INFO_ERROR("021","空间数据有误，请联系管理员！|The spatial data is wrong, please contact the administrator!|スペース・データエラー、管理者に連絡してください" ),
    DATA_ERROR("021","表格导入数据非该项目下数据，导入失败！|The imported data in the form is not the data under the project, and the import fails!|この項目に基づくデータではなく、データのインポートが失敗しました" ),

    TENANT_ID_NOT_NULL("0789","租户id不能为空|TENANT ID CANNOT BE EMPTY|テナントidは空にできません"),
    ILLEGAL_USER("0790","非法用户|ILLEGAL USER|不正利用者"),
    VERIFICATION_CODE_DOES_NOT_EXIST("0791","验证码不存在|VERIFICATION CODE DOES NOT EXIST|確認コードが存在しない"),
    INCORRECT_INPUT_OF_VERIFICATION_CODE("0792","验证码输入有误|INCORRECT INPUT OF VERIFICATION CODE|認証コードの入力ミス"),
    SIGN_OUT_FAILED("0793","退出登录失败|SIGN OUT FAILED|ログアウト失敗"),
    INCORRECT_PHONE_NUMBER("0794","手机号不正确|INCORRECT PHONE NUMBER|携帯のエラー"),
    INCORRECT_MAILBOX("0795","邮箱不正确|INCORRECT MAILBOX|メールのエラー"),
    AUTHENTICATION_FAILED("0796","认证失败|AUTHENTICATION FAILED|認証失敗"),
    FAILED_TO_MODIFY_ENTERPRISE_CERTIFICATION("0797","修改企业认证失败|FAILED TO MODIFY ENTERPRISE CERTIFICATION|企業認定の変更失敗"),
    FAILED_ADD_DEPARTMENT("0798","新增部门失败|FAILED ADD DEPARTMENT|部門追加の失敗"),
    FAILED_MODIFY_DEPARTMENT("0799","修改部门失败|FAILED MODIFY DEPARTMENT|部門変更の失敗"),
    FAILED_DELETE_DEPARTMENT("0800","删除部门失败|FAILED DELETE DEPARTMENT|部門削除の失敗"),
    FAILED_TO_ADD_ORGANIZATION_INFORMATION("0801","增加组织信息失败|FAILED TO ADD ORGANIZATION INFORMATION|組to modify enterprise certification failed to add 織情報の追加失敗"),
    FAILED_TO_MODIFY_ORGANIZATION_INFORMATION("0802","修改组织信息失败|FAILED TO MODIFY ORGANIZATION INFORMATION|組織情報の修正失敗"),
    FAILED_TO_DELETE_ORGANIZATION_INFORMATION("0803","删除组织信息失败|FAILED TO DELETE ORGANIZATION INFORMATION|組織情報の削除失敗"),
    FAILED_TO_ADD_POSITION("0804","增加岗位失败|FAILED TO ADD POSITION|役職追加の失敗"),
    FAILED_TO_MODIFY_POSITION("0805","修改岗位失败|FAILED TO MODIFY POSITION|役職変更の失敗"),
    FAILED_TO_DELETE_POSITION("0806","删除岗位失败|FAILED TO DELETE POSITION|役職削除の失敗"),
    PURCHASE_SERVICE("0807","该服务数量已经使用完了,请购买相应的服务|THE SERVICE QUANTITY HAS BEEN USED UP, PLEASE PURCHASE THE CORRESPONDING SERVICE|サービスの数が使い切られましました。対応するサービスを購入してください"),
    ROLE_OVERFLOW("0808","角色下面使用的人数超出服务的使用数量|THE NUMBER OF USERS UNDER THE ROLE EXCEEDS THE NUMBER OF USERS OF THE SERVICE|役割の下で使用されている人数がサービスの使用量以上です"),
    FAILED_TO_DELETE_ROLE("0809","删除角色失败|FAILED TO DELETE ROLE|役割削除の失敗"),
    THIS_PHONE_NUMBER_ALREADY_EXISTS("0810","此手机号已存在|THIS PHONE NUMBER ALREADY EXISTS|この電話番号は既に存在している。"),
    FAILED_TO_UPDATE_MOBILE_NUMBER("0811","更新手机号失败|FAILED TO UPDATE MOBILE NUMBER|携帯番号の更新失敗"),
    THIS_MAILBOX_ALREADY_EXISTS("0812","此邮箱已存在|THIS MAILBOX ALREADY EXISTS|このメールは既に存在している"),
    FAILED_TO_UPDATE_MAILBOX("0813","更新邮箱失败|FAILED_TO_UPDATE_MAILBOX|メールボックスの更新失敗"),
    FAILED_TO_ENABLE_OR_DISABLE_ACCOUNT("0814","账号的启用或停用失败|FAILED TO ENABLE OR DISABLE ACCOUNT|アカウントの有効化または無効化に失敗しました"),
    FAILED_TO_MODIFY_ACCOUNT_MANAGEMENT_INFORMATION("0815","修改账号管理信息失败|FAILED TO MODIFY ACCOUNT MANAGEMENT INFORMATION|アカウント管理情報の変更に失敗しました"),
    FAILED_TO_ADD_EMPLOYEE_INFORMATION("0816","添加雇员信息失败|FAILED TO ADD EMPLOYEE INFORMATION|スタッフ情報の追加失敗"),
    FAILED_TO_MODIFY_EMPLOYEE_INFORMATION("0817","编辑雇员信息失败|FAILED TO MODIFY EMPLOYEE INFORMATION|スタッフ情報の編集失敗"),
    FAILED_TO_DELETE_EMPLOYEE_INFORMATION("0818","删除租户失败|FAILED TO DELETE EMPLOYEE INFORMATION|テナントの削除失敗"),
    MOBILE_NUMBER_ALREADY_EXISTS_OR_REGISTRATION_FAILED("0820","手机号已存在或注册失败|MOBILE NUMBER ALREADY EXISTS OR REGISTRATION FAILED|電話番号はすでに存在するか、登録に失敗しました"),
    NO_SERVICE_USAGE_TIMES_UNDER_THIS_ROLE("0821","此角色下面的服务使用次数无|NO SERVICE USAGE TIMES UNDER THIS ROLE|この役割に基づくサービスの使用回数はない"),
    FAILED_TO_ADD_USER_INFORMATION("0822","新增用户信息失败|FAILED TO ADD USER INFORMATION|ユーザー追加情報の失敗"),
    WRONG_PASSWORD("0823","密码输入有误|WRONG PASSWORD|パスワード入力のエラー"),
    WRONG_ACCOUNT_OR_PASSWORD("0824","账号或密码错误|WRONG ACCOUNT OR PASSWORD|アカウントまたはパスワードエラー"),
    THE_USER_INFORMATION_DOES_NOT_EXIST("0825","该用户信息不存在|THE USER INFORMATION DOES NOT EXIST|このユーザー情報はない"),
    MAILBOX_ALREADY_EXISTS_OR_FAILED_TO_REGISTER("0826","邮箱已存在或注册失败|MAILBOX ALREADY EXISTS OR FAILED TO REGISTER|メールがすでに存在するか、登録に失敗しました"),
    FAILED_TO_ADD_USER("0827","添加用户失败|FAILED TO ADD USER|ユーザー追加の失敗"),
    FAILED_TO_DELETE_USER("0828","删除用户失败|FAILED TO DELETE USER|ユーザー削除の失敗"),
    FAILED_TO_MODIFY_USER("0829","修改用户失败|FAILED TO MODIFY USER|ユーザー変更の失敗"),
    FAILED_TO_ENABLE_OR_DISABLE_THE_SERVICE("0830","服务的启用或者停用失败|FAILED TO ENABLE OR DISABLE THE SERVICE|サービスの有効化または無効化に失敗しました"),
    FAILED_TO_AUDIT_TENANT("0831","审核租户失败|FAILED TO AUDIT TENANT(|テナントの審査失敗"),
    SERVICE_PURCHASE_FAILED("0832","服务的购买失败|SERVICE PURCHASE FAILED|サービスの取得失敗"),
    ILLEGAL_PARAMETER("0833","参数不合法|ILLEGAL PARAMETER|パラメーターのエラー"),
    DEPARTMENT_ID_CANNOT_BE_EMPTY("0834","部门id不能为空|DEPARTMENT ID CANNOT BE EMPTY|部門IDは空にできません"),
    POSITION_NAME_CANNOT_BE_EMPTY("0835","岗位名称不能为空|POSITION NAME CANNOT BE EMPTY(|役職名は空にできません"),
    DEPARTMENT_NAME_CANNOT_BE_EMPTY("0836","部门名称不能为空|DEPARTMENT NAME CANNOT BE EMPTY|部門名は空にできません"),
    USER_ID_CANNOT_BE_EMPTY("0837","用户id不能为空|USER ID CANNOT BE EMPTY|不正利用者"),
    COMPANY_NAME_CANNOT_BE_EMPTY("0838","公司名称不能为空号|COMPANY NAME CANNOT BE EMPTY|会社名は空にできません"),
    UNIFIED_SOCIAL_CREDIT_CODE_CANNOT_BE_EMPTY("0840","统一社会信用代码不能为空|UNIFIED SOCIAL CREDIT CODE CANNOT BE EMPTY|統合社会的信用コードは空にできません"),
    BUSINESS_LICENSE_CANNOT_BE_EMPTY("0842","营业执照不能为空|BUSINESS LICENSE CANNOT BE EMPTY|営業免許は空にできません"),
    CONTACT_NAME_CANNOT_BE_EMPTY("0843","联系姓名不能为空|CONTACT NAME CANNOT BE EMPTY|関連名は空にできません"),
    MOBILE_NUMBER_CANNOT_BE_EMPTY("0844","手机号不能为空|MOBILE NUMBER CANNOT BE EMPTY|携帯番号は空にできません"),
    MAILBOX_CANNOT_BE_EMPTY("0845","邮箱不能为空|MAILBOX CANNOT BE EMPTY|メールは空にできません"),
    FAILED_TO_ADD_DEVICE("0846","添加设备失败|FAILED TO ADD DEVICE|設備の追加失敗"),
    FAILED_TO_DELETE_DEVICE("0848","删除设备失败|FAILED TO DELETE DEVICE|設備の削除失敗"),
    SMS_SENDING_FAILED("0849","短信发送失败|SMS SENDING FAILED|メールの送信に失敗しました"),
    FAILED_TO_SEND_MAILBOX("0850","邮箱发送失败|FAILED TO SEND MAILBOX|メール送信に失敗しました"),



    TASK_DETAIL_CANNOT_BE_NULL("2001","任务详情信息不能为空|TASK DETAIL CANNOT BE NULL|業務の詳細を空欄にできません"),
    START_TIME_CANNOT_BE_NULL("2002","开始时间不能为空|START TIME CANNOT BE NULL|開始時間は空欄にできません"),
    END_TIME_CANNOT_BE_NULL("2003","结束时间不能为空|END TIME CANNOT BE NULL|終了時刻空欄にできません"),
    USER_INFO_IS_NULL("2004","用户信息为空|USER INFO IS NULL|ユーザーの役職情報が空です"),
    USER_POSITION_INFO_IS_NULL("2005","用户岗位信息为空|USER POSITION INFO IS NULL|ユーザーの役職情報が空です"),
    NO_POSITION_ACCESS("2006","无权访问|NO POSITION ACCESS|アクセス不能"),
    USER_DEPT_INFO_IS_NULL("2007","用户部门信息为空|USER DEPT INFO IS NULL|ユーザー部門情報が空です"),
    WORKSHEET_INFO_IS_NULL("2008","没有对应工单信息|WORKSHEET INFO IS NULL|対応する作業指示情報はありません"),
    SHARE_USER_INFO_IS_NULL("2009","分享人员信息为空|SHARE USER INFO IS NULL|人員情報の共有"),
    SHARE_USER_POSITION_PARAM_IS_ERROR("2010","分享人员岗位信息参数有误|SHARE USER POSITION PARAM IS ERROR|人員情報の共有エラー"),
    PPM_IN_THIS_YEAR_IS_EXIST("2011","该年份PPM计划任务目录已存在|PPM IN THIS YEAR IS EXIST|この年次PPM年間計画業務・ディレクトリーはすでに存在します"),
    PPM_CATEGORY_ADD_ERROR("2012","计划任务目录插入异常|PPM CATEGORY ADD ERROR|計画業務・ディレクトリーの例外挿入"),
    PPM_CATEGORY_IS_NULL("2013","没有对应计划任务目录|PPM CATEGORY IS NULL|対応する計画業務・ディレクトリーがありません"),
    PPM_CATEGORY_IS_DELETED("2014","该计划目录已被删除|PPM CATEGORY IS DELETED|計画ディレクトリは削除されました"),
    OPERATE_PPM_CATEGORY_ERROR("2015","操作计划任务目录异常|OPERATE PPM CATEGORY ERROR|計画業務ディレクトリ操作異常"),
    UPDATE_PPM_SUB_TASK_ERROR("2016","更新计划任务子任务异常|UPDATE PPM SUB TASK ERROR|計画業務のサブ業務更新例外"),
    PARAM_ERROR("2017","传值异常|PARAM ERROR|異常値"),
    ADD_PPM_TAG_ERROR("2018","新增计划任务标签异常|ADD PPM TAG ERROR|新規計画業務・種別追加例外"),
    DELETE_PPM_TAG_ERROR("2019","删除计划任务标签异常|DELETE PPM TAG ERROR|計画業務・種別削除例外"),
    DELETE_PPM_SUB_TASK_ERROR("2020","删除计划任务子任务异常|DELETE PPM SUB TASK ERROR|計画業務のサブ業務削除例外"),
    UPDAT_PPM_TAG_ERROR("2021","更新计划任务标签异常|UPDATE PPM TAG ERROR|計画業務・種別更新例外"),
    TASK_INFO_ERROR("2022","任务数据异常|TASK INFO ERROR|業務データ異常"),
    PPM_ADD_ERROR("2023","计划任务新增异常|PPM ADD ERROR|計画業務の追加例外"),
    PPM_SUB_TASK_VALID_TIME_ERROR("2024","计划任务工单生效日期新增异常|PPM SUB TASK VALID TIME ERROR|計画業務作業開始日の追加例外"),
    ADD_SUPPLIER_ERROR("2025","新增服务商信息异常|ADD SUPPLIER ERROR|新規サービスプロバイダー情報例外"),
    DELETE_SUPPLIER_ERROR("2026","删除服务商异常|DELETE SUPPLIER ERROR|サービスプロバイダー削除例外"),
    WORKSHEET_CANNOT_REMIND("2027","该工单不可发送任务提醒|WORKSHEET CANNOT REMIND|この業務は通知を送信できません"),
    REMIND_WORKSHEET_PARAM_ERROR("2028","提醒工单传值异常|REMIND WORKSHEET PARAM ERROR|作業のパス値の例外注意"),
    POSITION_HAS_NO_PERMISSION_ACCESS("2029","当前岗位没有相关权限|POSITION HAS NO PERMISSION ACCESS|関連する権限がありません"),
    ADD_REPORT_ERROR("2030","报事新增异常|ADD REPORT ERROR|報告追加例外"),
    ADD_REPORT_PICTURE_ERROR("2031","报事图片新增异常|ADD REPORT PICTURE ERROR|報告画像の追加例外"),
    REPORT_IS_NULL("2032","没找该报事信息|REPORT IS NULL|報告情報が見つかりません"),
    UPDATE_REPORT_STATUS_PARAM_ERROR("2033","更新报事状态传值异常|UPDATE REPORT STATUS PARAM ERROR|報告状況パス値の更新例外"),
    REPORT_STATUS_IS_NOT_NEED_TO_RESOLVE_OR_RESOLVED("2034","该报事状态为无需处理或已处理|REPORT STATUS IS NOT NEED TO RESOLVE OR RESOLVED|報告された事象の状態は、処理不要または処理済です"),
    REPORT_NEW_TASK_ID_IS_NULL("2035","报事状态更新为处理中时newTaskId不能为空|REPORT NEW TASK ID IS NULL|報告の状態が処理中に更新される場合、NewTaskIdを空にすることはできません"),
    UPDATE_REPORT_ERROR("2036","更新报事信息异常|UPDATE REPORT ERROR|報告状況の更新例外"),
    REPORT_STATUS_IS_PROCESSING("2037","该报事状态在流程处理中|REPORT STATUS IS PROCESSING|報告の状況は、プロセス内にある"),
    REPORT_STATUS_IS_UNRESOLVED("2038","当前报事为未处理状态，不能直接更新已完成|REPORT STATUS IS UNRESOLVED|現在の報告は未処理であり、完了に更新できません"),
    TASK_TYPE_PARAM_ERROR("2039","任务类型传值错误|TASK TYPE PARAM ERROR|業務タイプのパス値が例外"),
    TASK_TEMPLATE_WITHOUT_EXECUTOR("2040","选择的任务模版信息没有配置执行人信息|TASK TEMPLATE WITHOUT EXECUTOR|選択された業務・テンプレート情報には、実行者情報の構成はありません"),
    PATROL_TASK_NEED_TWO_CHECKPOINT_AT_LEAST("2041","巡视任务checkpoint需要两个及两个以上|PATROL TASK NEED TWO CHECKPOINT AT LEAST|巡回業務checkpointは2個以上が必要です"),
    PATROL_TASK_CYCLE_PARAM_ERROR("2042","巡视任务周期传值异常|PATROL TASK CYCLE PARAM ERROR|巡回業務のサイクルパス値が例外"),
    REPORT_TASK_PATROL_NUM_PARAM_ERROR("2043","巡视任务巡视次数传值异常|REPORT TASK PATROL NUM PARAM ERROR|巡回業務の巡回回数パス値が例外"),
    REPORT_TASK_ORDER_PARAM_ERROR("2044","巡视任务是否按顺序传值异常|REPORT TASK ORDER PARAM ERROR|巡视任务是否按顺序传值异常"),
    REPORT_TASK_CHECKPOINT_ORDER_ERROR("2045","巡视任务巡视点位顺序值异常|REPORT TASK CHECKPOINT ORDER ERROR|巡回業務の巡回順番パス値が例外"),
    STATIC_TASK_IS_ONLY_ONE_CHECKPOINT("2046","固定任务checkpoint有且只有一个|STATIC TASK IS ONLY ONE CHECKPOINT|固定業務checkpointは1つのみである"),
    STATIC_TASK_WORKING_TIME_ERROR("2047","固定岗任务在岗时间传值异常|STATIC TASK WORKING TIME ERROR|固定勤務の時期例外"),
    TASK_HAS_NO_EXECUTOR("2048","该任务没有任务执行人相关信息|TASK HAS NO EXECUTOR|この業務には、実行者に関する情報はない"),
    ADD_TASK_BASIC_INFO_ERROR("2049","任务基本信息新增异常|ADD TASK BASIC INFO ERROR|業務の基本情報の追加例外"),
    SENTRY_AUTO_CREATE_WORKSHEET_TOPIC_CANNOT_BE_NULL("2050","sentry报警自动创建任务工单topic不能为空|SENTRY AUTO CREATE WORKSHEET TOPIC CANNOT BE NULL|sentryアラーム自動作成業務のtopicは空欄にできません"),
    TASK_CREATED("2051","对应任务已经创建,不需要重复创建|TASK CREATED NO NEED TO CREATE AGAIN|対応する業務は既に作成されており、重複して作成する必要はない"),
    SENTRY_AUTO_CREATE_TASK_PARAM_ERROR("2052","sentry报警自动创建任务工单，任务参数不能为空|SENTRY AUTO CREATE TASK PARAM ERROR|sentryアラートについて自動作成業務のパラメーターを空欄にできません"),
    TASK_IS_NULL("2053","没有找到该任务|TASK_IS_NULL|業務が見つからない"),
    TEMP_TASK_CANNOT_DELETE("2054","临时任务不可删除|TEMP TASK CAN NOT DELETE|臨時業務は削除不能"),
    UPDATE_USER_IS_NULL("2055","更新人userId不能为空|UPDATE USER IS NULL|更新者userIdは空欄にできません。"),
    TASK_HAS_DELETED("2056","该任务已被删除|TASK HAS DELETED|業務が削除された"),
    TASK_OPERATE_ERROR("2057","任务操作异常|TASK OPERATE ERROR|業務操作例外"),
    TASK_OPERATE_PARAM_ERROR("2058","任务操作传值异常|TASK OPERATE PARAM ERROR|業務操作パス値の例外"),
    TEMP_TASK_CANNOT_UPDATE("2059","临时任务不可编辑更新|TEMP TASK CAN NOT UPDATE|臨時業務は編集不能"),
    UPDATE_TASK_PARAM_TASKID_ERROR("2060","更新任务taskId传值异常|UPDATE TASK PARAM TASK ID ERROR|業務更新taskIdパス値の例外"),
    WORKSHEET_CHECKPOINT_ERROR("2061","工单点位信息查询异常|WORKSHEET CHECKPOINT ERROR|作業ポイント照会例外"),
    CHECKPOINT_DELETE_FAILED("2062","点位删除失败|CHECKPOINT DELETE FAILED|ポイント削除失敗"),
    NO_PERMISSION_ACCESS_BY_THE_TASK_TEMPLATE("2063","没有使用该模版发布任务权限|NO PERMISSION ACCESS BY THE TASK TEMPLATE|このテンプレートを使用して業務を公開する権限がありません"),
    DELETE_TASK_PICTURE_ERROR("2064","任务图片信息删除异常|DELETE TASK PICTURE ERROR|業務画像の削除例外"),
    INSER_TASK_PICTURE_ERROR("2065","任务图片插入异常|INSER TASK PICTURE ERROR|業務画像の挿入例外"),
    DELETE_TASK_EXECUTOR_ERROR("2066","任务执行人信息删除异常|DELETE TASK EXECUTOR ERROR|業務執行者情報の削除例外"),
    INSERT_TASK_EXECUTOR_ERROR("2067","任务执行人插入异常|INSERT TASK EXECUTOR ERROR|業務執行者情報の異常例外"),
    DELETE_TASK_SPACE_ERROR("2068","任务空间信息删除异常|DELETE TASK SPACE ERROR|業務・スペース情報の削除例外"),
    INSERT_TASK_SPACE_ERROR("2069","任务空间信息插入异常|INSERT TASK SPACE ERROR|業務・スペース情報の挿入例外"),
    DELETE_TASK_CHECKPOINT_ERROR("2070","任务点位信息删除异常|DELETE TASK CHECKPOINT ERROR|業務・ポイント情報の削除例外"),
    INSERT_TASK_CHECKPOINT_ERROR("2071","任务点位插入异常|INSERT TASK CHECKPOINT ERROR|業務・ポイントの挿入例外"),
    INSERT_TASK_TEMPLATE_TAG_ERROR("2072","任务模版标签新增异常|INSERT TASK TEMPLATE TAG ERROR|業務・テンプレート・種別の追加例外"),
    DELETE_TASK_TEMPLATE_ERROR("2073","任务模版删除异常|DELETE TASK TEMPLATE ERROR|業務テンプレートの削除例外"),
    TASK_TEMPLATE_IS_NULL("2074","没有该任务模版|TASK TEMPLATE IS NULL|業務・テンプレートが存在しない"),
    TASK_TEMPLATE_INVALID("2075","该任务模版为无效模版|TASK TEMPLETE INVALID|この業務・テンプレートは無効テンプレートです"),
    UPDATE_TASK_TEMPLATE_BASIC_INFO_ERROR("2076","任务模版基本信息更新异常|UPDATE TASK TEMPLATE BASIC INFO ERROR|業務・テンプレートの基本情報更新例外"),
    DELETE_TASK_TEMPLATE_TAG_ERROR("2077","任务模版标签信息删除异常|DELETE TASK TEMPLATE TAG ERROR|業務・テンプレート・種別削除例外"),
    ADD_TASK_TEMPLATE_TAG_ERROR("2078","任务模版标签信息新增异常|ADD TASK TEMPLATE TAG ERROR|業務・テンプレート・種別情報の追加例外"),
    DELETE_TASK_TEMPLATE_PERMISSION_ERROR("2079","任务模版权限信息删除异常|DELETE TASK TEMPLATE PERMISSION_ERROR|業務・テンプレート権限削除例外"),
    ADD_TASK_TEMPALTE_PERMISSION_ERROR("2080","任务模版权限信息新增异常|ADD TASK TEMPALTE PERMISSION ERROR|業務・テンプレートの権利の追加例外"),
    ADD_WORKSHEET_EVENT_BASIC_INFO_ERROR("2081","事件基本信息新增异常|ADD WORKSHEET EVENT BASIC INFO ERROR|事件の基本的な情報の追加例外"),
    ADD_WORKSHEET_CONSUME_INFO_ERROR("2082","事件消耗信息新增异常|ADD WORKSHEET CONSUME INFO ERROR|消費情報の追加例外"),
    ADD_WORKSHEET_EBENT_PICTURE_ERROR("2083","事件图片信息新增异常|ADD WORKSHEET EVENT PICTURE ERROR|画像情報の追加例外"),
    ADD_WORKSHEET_EVENT_POSITION_ERROR("2084","事件岗位信息新增异常|ADD WORKSHEET EVENT POSITION ERROR|役職情報の追加例外"),
    ADD_WORKSHEET_EVENT_SHARE_ERROR("2085","新增事件分享用户信息异常|ADD WORKSHEET EVENT SHARE ERROR|情報共有の追加例外"),
    ADD_WORKSHET_EVENT_CHECKPOINT_ERROR("2086","新增事件点位信息异常|ADD WORKSHEET EVENT CHECKPOINT ERROR|事件の基本的な情報の追加例外|ポイント情報の追加例外"),
    CREATOR_POSITION_CANNOT_BE_NULL("2087","任务创建人岗位Id不能为空|CREATOR POSITION CAN NOT BE NULL|業務作成者のIDは空欄にできません"),
    ADD_ASSET_FAULT_ERROR("2088","新增资产故障记录信息异常|ADD ASSET FAULT ERROR|建物の故障履歴の追加例外"),
    ADD_WORKSHEET_ERROR("2089","新增工单信息异常|ADD_WORKSHEET_ERROR|作業情報の追加例外"),
    ADD_EXECUTOR_ERROR("2090","新增任务执行人员信息异常|ADD EXECUTOR ERROR|業務実行者情報の追加例外"),
    DELETE_WORKSHEET_ERROR("2091","删除工单异常|DELETE WORKSHEET ERROR|作業の削除例外"),
    QUERY_WORKSHEET_PARAM_ERROR("2092","查询工单列表传值异常|QUERY WORKSHEET PARAM ERROR|作業照会パス値例外"),
    NO_EXECUTOR_TO_ASSIGN("2093","没有委派人员信息,不可进行委派|NO EXECUTOR TO ASSIGN|委任者情報がなく、委任ができません"),
    WORKSHEET_CANNOT_BE_ASSIGNED_TO_THE_POSITION("2094","不可将该工单委派给该岗位|WORKSHEET CANNOT BE ASSIGNED TO THE POSITION|作業を該当役職に委任ができません"),
    WORKSHEET_CANNOT_BE_ASSIGNED_TO_THE_USER("2095","不可将该工单委派给该人员|WORKSHEET CANNOT BE ASSIGNED TO THE USER|作業を該当人員に委任ができません"),
    ASSIGN_WORKSHEET_ERROR("2096","委派工单异常|ASSIGN WORKSHEET ERROR|作業委任例外"),
    ASSIGN_WORKSHEET_PARAM_ERROR("2097","委派工单传值异常|ASSIGN WORKSHEET PARAM ERROR|作業委任のパス値例外"),
    UPGRADE_WORKSHEET_ERROR("2098","工单升级待处理异常|UPGRADE WORKSHEET ERROR|作業アップグレードの例外"),
    UPDATE_WORKSHEET_TAG_ERROR("2099","工单修改标签异常|UPDATE WORKSHEET TAG ERROR|作業ラベル変更パス値の例外"),
    ADD_CONSUM_ERROR("2100","添加物料/金额备注异常|ADD CONSUM ERROR|材料・金額の追加例外"),
    ADD_CONTENT_ERROR("2101","补充内容异常|ADD_CONTENT_ERROR|補足内容例外"),
    ADD_CONTENT_PARAM_ERROR("2102","补充内容传值异常|ADD CONTENT PARAM ERROR|補足内容のパス値例外"),
    WORKSHEET_IS_NULL("2103","没有找到相关工单信息|WORKSHEET IS NULL|業務に関する情報が見つからない"),
    TASK_TO_WORKSHEET_IS_NULL("2104","未找到该工单对对应任务信息|TASK TO WORKSHEET IS NULL|対応する業務情報が見つからない"),
    FINISH_WORKSHEET_ERROR("2105","完成工单异常|FINISH WORKSHEET ERROR|業務完成異常"),
    FINISH_WORKSHEET_PARAM_ERROR("2106","完成工单传值异常|FINISH WORKSHEET PARAM ERROR|業務完成のパス値異常"),
    ADD_ASSIGN_WORKSSHET_EXECUTOR_ERROR("2107","委派工单插入执行人信息异常|ADD ASSIGN WORKSSHET EXECUTOR ERROR|委任業務に実行者状挿入情報例外"),
    CHECK_WORKSHEET_PARAM_ERROR("2108","验收工单传值异常|CHECK WORKSHEET PARAM ERROR|業務検収パス値の例外"),
    UPDATE_FEEDBACK_STATUS_ERROR("2109","更新反馈状态异常|UPDATE FEEDBACK STATUS ERROR|フィードバック状態の更新例外"),
    UPDATE_FEEDBACK_STATUS_PARAM_ERROR("2110","更新反馈状态异常传值异常|UPDATE FEEDBACK STATUS PARAM ERROR|フィードバック状態パス値の例外"),
    UPLOAD_PATROL_CHECKPOINT_ERROR("2111","巡点上传传值错误|UPLOAD PATROL CHECKPOINT ERROR|巡回ポイントのアップロードパス値の例外"),
    WORKSHEET_HAS_NO_CHECKPOINT("2112","该工单任务没有对应点位信息|WORKSHEET HAS NO CHECKPOINT|該当業務には、ポイントに関する情報はない"),
    WORKSHEET_HAS_PAROLED("2113","该点已经巡视过|WORKSHEET HAS PAROLED|このポイントは巡回しました"),
    PLEASE_PATROL_IN_ORDER("2114","请按照正确顺序巡视点位|PLEASE PATROL IN ORDER|正しい順序で巡回してください"),
    UPDATE_WORKSHEET_FINISH_FAILED("2115","更新工单完成失败|UPDATE WORKSHEET FINISH FAILED|作業完成の更新に失敗しました"),
    WORKSHEET_ID_ERROR("2116","工单Id传值异常|WORKSHEET ID ERROR|作業Idのパス値例外"),
    WORKSHEET_STATUS_ERROR("2117","工单状态检测异常|WORKSHEET STATUS ERROR|作業状態検出例外"),
    WORKSHEET_CANNOT_BE_OPERATE("2118","当前工单状态不可进行该操作|WORKSHEET_CANNOT_BE_OPERATE|現在の手数料の状況は、これを行うことはできません。"),
    TASK_TEMPLATE_PERMISSION_ERROR("2119","任务模版权限信息异常|TASK TEMPLATE PERMISSION ERROR|業務・テンプレートの権限情報の例外"),
    ASSET_ID_CANNOT_NULL("2120","资产Id不能为空|ASSET ID CANNOT NULL|建物Idは空欄にできません"),
    ASSET_STATUS_CANNOT_NULL("2121","资产状态不能为空|ASSET STATUS CANNOT NULL|建物の状況は空欄にできません"),
    CHECKPOINT_ID_CANNOT_NULL("2123","点位Id不能为空|CHECKPOINT ID CANNOT NULL|ポイントIdサイトは空欄にできません"),
    TASK_WORKSHEET_ID_CANNOT_NULL("2124","任务工单Id不能为空|TASK ID CANNOT NULL|業務Idは空欄にできません"),
    PROJECT_ID_CANNOT_NULL("2125","项目Id不能为空|PROJECT ID CANNOT NULL|項目Idは空欄にできません"),
    TENANT_ID_CANNOT_NULL("2126","租户Id不能为空|TENANT ID CANNOT NULL|テナントIDは空欄にできません"),
    PATORL_USER_ID_CANNOT_NULL("2127","巡视人userId不能为空|PATORL USER ID CANNOT NULL|巡回userIdは空欄にできません"),
    PATROL_NUM_CANNOT_NULL("2128","扫描次数编号不能为空|PATROL NUM CANNOT NULL|スキャン数は空欄にできません"),
    TASK_TYPE_CANNOT_NULL("2129","任务类型不能为空|TASK TYPE CANNOT NULL|業務の種類は空欄にできません"),
    TASK_TEMPLATE_ID_CANNOT_NULL("2130","任务模版Id不能为空|TASK TEMPLATE ID CANNOT NULL|業務テンプレートIdは空欄にできません"),
    OPERATE_ID_CANNOT_NULL("2131","操作Id不能为空|OPERATE ID CANNOT NULL|操作dは空欄にできません"),
    SUBJECT_POSITION_ID_CANNOT_NULL("2132","主语岗位Id不能为空|SUBJECT POSITION ID CANNOT NULL|役職Idは空欄にできません"),
    PPM_CATRGPRY_ID_CANNOT_NULL("2133","计划任务目录Id不能为空|PPM CATRGPRY ID CANNOT NULL|計画・業務・ディレクトリーIdは空欄にできません"),
    POSITION_ID_CANNOT_NULL("2134","岗位Id不能为空|POSITION ID CANNOT NULL|役職Idは空欄にできません"),
    PPM_CATEGORY_NAME_CANNOT_NULL("2135","计划任务目录名称不能为空|PPM CATEGORY NAME CANNOT NULL|計画・業務・ディレクトリー名は空欄にできません"),
    PPM_CATEGORY_YEAY_CANNOT_NULL("2136","计划任务目录年份不能为空|PPM CATEGORY YEAY CANNOT NULL|計画・業務・ディレクトリーの年は空欄にできません"),
    CREATE_USER_ID_CANNOR_NULL("2140","创建人userId不能为空|CREATE USER ID CANNOR NULL|作成者userIdは空欄にできません"),
    CREATOR_POSITION_ID_CANNOT_NULL("2141","创建人岗位Id集合不能为空|CREATOR POSITION ID CANNOT NULL|作成者の役職Id集合は空欄にできません"),
    PPM_CATEGPRY_ID_CANNOT_NULL("2142","计划任务目录Id不能为空|PPM CATEGPRY ID CANNOT NULL|計画・業務・ディレクトリーIdは空欄にできません"),
    OPERATE_TYPE_CANNOT_NULL("2143","操作类型不能为空|OPERATE TYPE CANNOT NULL|操作の種類は空欄にできません"),
    OPERATOR_ID_CANNOT_NULL("2144","操作人Id不能为空|OPERATOR ID CANNOT NULL|操作者IDは空欄にできません"),
    PPM_MAINTENANCE_TAG_ID_CANNOT_NULL("2145","计划任务保养类型标签Id不能为空|PPM MAINTENANCE TAG ID CANNOT NULL|計画・業務業務のメンテナンスタイプ種別IDは空欄にできません"),
    PPM_SYSTEM_TAG_ID_CANNOT_NULL("2146","计划任务系统标签Id不能为空|PPM SYSTEM TAG ID CANNOT NULL|計画・業務・システム・レベルIDは空欄にできません"),
    TASK_DETAIL_INFO_CANNOT_NULL("2147","任务详细信息不能为空|TASK DETAIL INFO CANNOT NULL|業務の詳細は空欄にできません"),
    PPM_CATEGORY_TAG_NAME_CANNOT_NULL("2148","计划任务目录标签名称不能为空|PPM CATEGORY TAG NAME CANNOT NULL|計画・業務・ディレクトリーの種別名IDは空欄にできません"),
    PPM_CATRGORY_TAG_ID_CANNOT_NULL("2149","计划任务目录标签Id不能为空|PPM CATRGORY TAG ID CANNOT NULL|計画・業務・ディレクトリー・種別名IDは空欄にできません"),
    TAG_TYPE_CANNOT_NULL("2150","标签类型不能为空|TAG TYPE CANNOT NULL|種別の種類は空欄にできません"),
    YEAR_CANNOT_NULL("2151","年份不能为空|YEAR CANNOT NULL|年は空欄にできません"),
    WORKSHEET_VALID_TIME_CANNOT_NULL("2152","工单生效时间不能为空|WORKSHEET VALID TIME CANNOT NULL|作業の有効期間は空欄にできません"),
    REPORT_TITLE_CANNOT_NULL("2153","报事报修标题不能为空|REPORT TITLE CANNOT NULL|報告の見出しは空欄にできません"),
    REPORT_CONTENT_CANNOT_NULL("2154","报事报修内容不能为空|REPORT CONTENT CANNOT NULL|報告の内容は空欄にできません"),
    REPORT_SPACE_ID_CANNOT_NULL("2155","报事报修空间Id不能为空|REPORT SPACE ID CANNOT NULL|報告スペースIdは空欄にできません"),
    REPORT_ID_CANNOT_NULL("2156","报事Id不能为空|REPORT ID CANNOT NULL|報告Idは空欄にできません"),
    LANGUAGE_CODE_CANNOT_NULL("2157","语言code不能为空|LANGUAGE CODE CANNOT NULL|言語codeは空欄にできません"),
    SUPPLIER_NAME_CANNOT_NULL("2158","服务提供方名称不能为空|SUPPLIER NAME CANNOT NULL|サービスプロバイダー名は空欄にできません"),
    SUPPLIER_ID_CANNOT_NULL("2159","服务商Id不能为空|SUPPLIER ID CANNOT NULL|サービス事業者IDは空欄にできません"),
    USER_ID_CANNOT_NULL("2160","用户Id不能为空|USER ID CANNOT NULL|ユーザーIDは空欄にできません"),
    WORKSHEET_STATUS_CANNOT_NULL("2161","工单状态不能为空|WORKSHEET STATUS CANNOT NULL|作業状態は空欄にできません"),
    SPACE_ID_LIST_CANNOT_NULL("2162","空间Id列表不能为空|SPACE ID LIST CANNOT NULL|スペースIdのリストは空欄にできません"),
    TASK_ID_CANNOT_NULL("2163","任务Id不能为空|TASK ID CANNOT NULL|業務Idは空欄にできません"),
    TASK_ECECUTOR_POSITION_CANNOT_NULL("2164","任务执行岗位Id不能为空|TASK ECECUTOR POSITION CANNOT NULL|業務執行役職Idは空欄にできません"),
    TASK_EXECUTOR_USER_CANNOT_NULL("2165","任务执行人Id不能为空|TASK EXECUTOR USER CANNOT NULL|業務執行者IDは空欄にできません"),
    TASK_TYPE_ID_CANNOT_NULL("2166","任务类型Id不能为空|TASK TYPE ID CANNOT NULL|業務タイプIdは空欄にできません"),
    TASK_NAME_CANNOT_NULL("2167","任务名称不能为空|TASK NAME CANNOT NULL|業務名は空欄にできません"),
    TASK_DESC_CANNOT_NULL("2168","任务描述不能为空|TASK DESC CANNOT NULL|業務の記述は空欄にできません"),
    OPERATE_POSITION_ID_CANNOT_NULL("2169","操作人岗位Id不能为空|OPERATE POSITION ID CANNOT NULL|操作者の役職Idは空欄にできません"),
    OBJECT_POSITION_ID_CANNOT_NULL("2170","宾语岗位Id不能为空|OBJECT POSITION ID CANNOT NULL|オブジェクトの位置IDは空欄にできません"),
    TASK_TEMPLATE_NAME_CANNOT_NULL("2171","任务模版名称不能为空|TASK TEMPLATE NAME CANNOT NULL|業務・テンプレート名は空欄にできません"),
    TASK_TEMPLATE_ICON_CANNOT_NULL("2172","任务模版图标不能为空|TASK TEMPLATE ICON CANNOT NULL|業務・テンプレート・アイコンは空欄にできません"),
    TASK_TEMPLATE_BASIC_INFO_CANNOT_NULL("2173","任务模版基本信息不能为空|TASK TEMPLATE BASIC INFO CANNOT NULL|業務・テンプレートの基本情報は空欄にできません"),
    OPERATE_PERMISSION_ID_CANNOT_NULL("2174","权限任务操作Id不能为空|OPERATE PERMISSION ID CANNOT NULL|権限業務操作Idは空欄にできません"),
    TASK_TEMPLATE_TAG_ID_CANNOT_NULL("2175","任务模版标签Id不能为空|TASK TEMPLATE TAG ID CANNOT NULL|業務・ステンシル・種別Idは空欄にできません"),
    TASK_TEMPLATE_TAG_CANNOT_NULL("2176","任务模版标签不能为空|TASK TEMPLATE TAG CANNOT NULL|業務・ステンシル・種別は空欄にできません"),
    WORKSHEET_BASIC_INFO_CANNOT_NULL("2178","工单基本信息不能为空|WORKSHEET BASIC INFO CANNOT NULL|作業の基本情報は空欄にできません"),
    WORKSHEET_EXECUTOR_INFO_CANNOT_NULL("2179","工单执行人信息不能为空|WORKSHEET EXECUTOR INFO CANNOT NULL|作業実行者の情報は空欄にできません"),
    TASK_EXECUTOR_INFO_CANNOT_NULL("2180","任务执行人数据不能为空|TASK EXECUTOR INFO CANNOT NULL|作業実行者のデータは空欄にできません"),
    TASK_BASIC_INFO_CANNOT_NULL("2181","任务基本信息不能为空|TASK BASIC INFO CANNOT NULL|業務の基本情報は空欄にできません"),
    WORKSHEET_EVENT_BASIC_CANNOT_NULL("2182","工单事件基本信息不能为空|WORKSHEET EVENT BASIC CANNOT NULL|業務事象の基本情報は空欄にできません"),
    ASSET_RECORD_CANNOT_NULL("2183","资产记录不能为空|ASSET RECORD CANNOT NULL|建物の記録は空欄にできません"),
    WORKSHEET_ID_CANNOT_NULL("2184","工单事件Id不能为空|WORKSHEET ID CANNOT NULL|作業事件Idは空欄にできません"),
    WORKSHEET_CREATOR_POSITION_CANNOT_NULL("2186","工单创建人岗位Id不能为空|WORKSHEET CREATOR POSITION CANNOT NULL|作業作成者Idはは空欄にできません"),
    SUBJECT_POSITION_ID_INFO_CANNOT_NULL("2187","主语岗位Id信息不能为空|SUBJECT POSITION ID INFO CANNOT NULL|役職Id情報は空欄にできません"),
    USER_POSITION_LIST_CANNOT_NULL("2190","用户岗位Id集合不能为空|USER POSITION LIST CANNOT NULL|ユーザー・役職Idの集合は空欄にできません"),
    CHECKPOINT_ID_LIST_CANNOT_NULL("2191","点位Id集合不能为空|CHECKPOINT ID LIST CANNOT NULL|ポイントIdの集合は空欄にできません"),
    QUERY_TYPE_CANNOT_NULL("2192","查询方式不能为空|QUERY TYPE CANNOT NULL|照会方はは空欄にできません"),
    MAC_CANNOT_NULL("2193","mac地址不能为空|MAC CANNOT NULL|macアドレスは空欄にできません"),
    DEPT_ID_CANNOT_NULL("2194","部门Id不能为空|DEPT ID CANNOT NULL|部門IDは空欄にできません"),
    MAC_NFC_CANNOT_NULL("2195","mac地址或nfc不能为空|MAC NFC CANNOT NULL|macアドレスまたはnfcは空欄にできません"),
    CHECK_STATUS_CANNOT_NULL("2196","验收状态不能为空|CHECK STATUS CANNOT NULL|検収状況は空欄にできません"),
    TASK_TYPE_LIST_CANNOT_NULL("2197","任务类型集合不能为空|TASK TYPE LIST CANNOT NULL|業務・タイプの集合は空欄にできません"),
    FEEDBACK_RESULT_CANNOT_NULL("2198","反馈评价结果不能为空|FEEDBACK RESULT CANNOT NULL|フィードバック評価結果は空欄にできません"),
    TASK_BASIC_TYPE_LIST_CANNOT_NULL("2199","任务基本类型集合不能为空|TASK BASIC TYPE LIST CANNOT NULL|基本業務・タイプの集合は空欄にできません"),
    SUBJECT_POSITION_CANNOT_NULL("2200","主语岗位集合不能为空|SUBJECT POSITION CANNOT NULL|マスター役職の集合は空欄にできません"),
    POSITION_ID_LIST_CANNOT_NULL("2201","岗位集合Id不能为空|POSITION ID LIST CANNOT NULL|役職の集合Idは空欄にできません"),
    OPERATE_USER_ID_CANNOT_NULL("2202","操作人userId不能为空|OPERATE USER ID CANNOT NULL|操作者userIdは空欄にできません"),
    PPM_TASK_ID_CANNOT_NULL("2203","计划任务Id不能为空|PPM TASK ID CANNOT NULL|計画・業務Idは空欄にできません"),
    VALID_TIEM_CANNOT_NULL("2204","生效时间不能为空|VALID TIME CANNOT NULL|有効期間は空欄にできません"),
    PROJECT_ID_LIST_CANNOT_NULL("2205","项目Id集合不能为空|PROJECT ID LIST CANNOT NULL|項目Idの集合は空欄にできません"),
    NEW_MAC_CANNOT_NULL("2206","新mac地址不能为空|NEW MAC CANNOT NULL|新しいmacアドレスは空欄にできません"),
    UPDATOR_USER_ID_CANNOT_NULL("2207","更新者userId不能为空|UPDATOR USER ID CANNOT NULL|更新者userIdは空欄にできません"),
    SIPPLIER_ID_CANNOT_NULL("2208","服务商Id不能为空|SIPPLIER ID CANNOT NULL|サービス事業者IDは空欄にできません"),
    TASK_OPERATE_TYPE_CANNOT_NULL("2209","任务操作类型不能为空|TASK OPERATE TYPE CANNOT NULL|業務・操作のタイプは空欄にできません"),
    SPACE_ID_CANNOT_NULL("2210","空间Id不能为空|SPACE ID CANNOT NULL|スペースIdは空欄にできません"),
    SPACE_NAME_CANNOT_NULL("2221","空间名称不能为空|SPACE NAME CANNOT NULL|スペース名は空欄にできません"),
    TASK_TEMPLATE_PERMISION_CANNOT_NULL("2222","任务模版权限配置信息不能为空|TASK TEMPLATE PERMISION CANNOT NULL|業務・テンプレートの権限構成情報は空欄にできません"),
    PERMISSION_OPERATE_ID_CANNOT_NULL("2223","权限操作Id不能为空|PERMISSION OPERATE ID CANNOT NULL|権限操作IDは空欄にできません"),
    SUBJECT_POSITION_LIST_CANNOT_NULL("2224","主语岗位Id集合不能为空|SUBJECT POSITION LIST CANNOT NULL|マスター役職Idの集合は空欄にできません"),
    WORKSHEET_TAG_ID_CANNOT_NULL("2225","工单标签Id不能为空|WORKSHEET TAG ID CANNOT NULL|作業種別Idは空欄にできません"),
    REFUSE_RESON_CANNOT_NULL("2226","拒绝原因不能为空|REFUSE RESON CANNOT NULL|拒否理由は空欄にできません"),
    TEMPLATE_CANNOT_DELETE("2227","该模版有任务使用不可删除|The template has tasks that cannot be deleted|このテンプレートはタスク使用時に削除できない"),
    TASK_SPACE_CANNOT_NULL("2228","任务空间信息不能为空|Task space information cannot be empty|タスク空間情報は空ではない"),
    SPACE_ID_AND_DESC_CANNOT_NULL("2229","空间id和空间名称不能为空|The space id and space name cannot be empty|空間idと空間名は空ではない"),
    TASK_EXECUTOR_PARAM_ERROR("2230","任务执行人传值异常|The task executor passed a value exception|タスク遂行者情報が異常"),
    REASON_OF_NOT_NEED_TO_RESOLVE_CANNOT_NULL("2231","无需处理原因不能为空|No need to handle reason cannot be null|原因を処理しなくても空にすることはできない"),
    DEVICE_RESTART_FAILED("3333","设备重启失败|BATCH AUTHORIZATION FAILED|一括認証に失敗しました"),
    POINTS_ARE_IN_TASK("2232","点位在任务中|The points are in the task|任務中に位置する"),
    DEVICE_ENABLE_FAILED("3334","设备启用失败|BATCH AUTHORIZATION FAILED|一括認証に失敗しました"),
    DEVICE_DISABLE_FAILED("3335","设备的禁用失败|DEVICE DISABLE FAILED|デバイスの無効化に失敗しました。"),
    DEVICE_RESET_FAILED("3336","设备的重置失败|DEVICE RESET FAILED|デバイスのリセットに失敗しました。。"),
    ACCESS_CONTROL_EQUIPMENT_MODIFICATION_FAILED("3339","门禁设备修改失败|ACCESS CONTROL EQUIPMENT MODIFICATION FAILED|ゲートの設定の変更に失敗しました"),
    ACCESS_EQUIPMENT_CONFIGURATION_MODIFICATION_FAILED("3340","门禁设备配置修改失败|ACCESS CONTROL EQUIPMENT CONFIGURATION MODIFICATION FAILED|ゲートの設定の変更に失敗しました"),
    REMOTE_CONTROL_FAILURE_OF_ACCESS_CONTROL_EQUIPMENT("3341","门禁设备的远程控制失败|REMOTE CONTROL FAILURE OF ACCESS CONTROL EQUIPMENT|ゲート禁止設備の遠隔制御に失敗しました"),
    START_FAILED_TO_OPEN_DEVICE_REGISTRATION_MODE_TASK("3342","开启设备注册模式任务失败|FAILED TO OPEN DEVICE REGISTRATION MODE TASK|デバイス登録モードタスクのオープンに失敗しました。"),
    FAILED_TO_OPEN_DEVICE_REGISTRATION_MODE_TASK("3343","结束设备注册模式任务失败|END DEVICE REGISTRATION MODE TASK FAILED|デバイス登録モードタスクの終了に失敗しました"),
    DEVICE_AUTHORIZER_FAILED("3344","设备授权人员失败|PRIVILEGE GRANT FAILED|認証に失敗しました"),
    SELLING_RIGHT_FAILED("3345","销权失败|SELLING RIGHT FAILED|販売権の失敗"),
    FAILED_TO_EMPTY_PERSONNEL_INFORMATION("3346","设备清空人员信息失败|FAILED TO EMPTY PERSONNEL INFORMATION|設備のクリア者情報が失敗しました。"),
    BATCH_AUTHORIZATION_FAILED("3347","批量授权失败|BATCH AUTHORIZATION FAILED|一括認証に失敗しました"),
    PERSONNEL_PHOTO_REGISTRATION("3348","人员照片注册|PHOTO REGISTRATION FAILED FOR PERSON|人の写真の登録に失敗しました。"),
    PERSONNEL_PHOTO_DELETION_FAILED("3349","人员照片删除失败|PERSONNEL PHOTO DELETION FAILED|人員写真の削除に失敗しました"),
    FAILED_TO_SET_AUXILIARY_INFORMATION_OF_PERSONNEL_AND_EQUIPMENT("3350","人员设备附属信息设置失败|FAILED TO SET AUXILIARY INFORMATION OF PERSONNEL AND EQUIPMENT|人員設備付属情報の設定に失敗しました。"),
    RESET_OF_AUXILIARY_INFORMATION_OF_PERSONNEL_AND_EQUIPMENT_FAILED("3351","人员设备附属信息重置失败|RESET OF AUXILIARY INFORMATION OF PERSONNEL AND EQUIPMENT FAILED|人員設備付属情報のリセットに失敗しました"),
    TABLE_EXPORT_FAILED("3352","表格导出失败|TABLE EXPORT FAILED|表のエクスポートに失敗しました"),
    FAILED_TO_ADD_PERSONNEL("3353","添加用户失败|FAILED TO ADD USER|ユーザの追加に失敗しました"),
    FAILED_TO_DELETE_PERSONNEL("3354","删除人员失败|FAILED TO DELETE PERSONNEL|削除に失敗しました"),
    FAILED_TO_MODIFY_PERSONNEL("3355","修改人员失败|FAILED TO MODIFY PERSONNEL|修正者が失敗しました"),;

    private String code;
    private String desc;

    PlatformCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}