package com.ifourthwall.common;

import org.apache.commons.lang3.StringUtils;

/**
 * @Author: hao.dai
 * @Date: 2019/12/13 11:31
 * @Description:
 */
public class CacheKeyDecorator {
    /**
     * 静态资源
     */
    public static final String OWNED_RESOURCES = "modules";
    /**
     * 模糊匹配后缀
     */
    public static final String FUZZY_MATCH_SUFFIX = "*";
    /**
     * key分隔符
     */
    public static final String SPLIT_SYMBOL = ":";
    /**
     * 用户类型缓存前缀
     */
    public static final String USER_CACHE_PREFIX = "user";
    /**
     * 权限
     */
    public static final String AUTH_CACHE_PREFIX = "auth";
    /**
     * 邮箱验证码验证
     */
    public static final String EMAIL_CACHE_PREFIX = "email";
    /**
     * 短信验证码验证
     */
    public static final String PHONE_CACHE_PREFIX = "phone";

    //邮箱验证码Key
    public static String getEmailAuthenticationKey(String email) {
        return StringUtils.joinWith(SPLIT_SYMBOL, AUTH_CACHE_PREFIX, EMAIL_CACHE_PREFIX, email);
    }

    //手机验证码Key
    public static String getPhoneAuthenticationKey(String phone) {
        return StringUtils.joinWith(SPLIT_SYMBOL, AUTH_CACHE_PREFIX, PHONE_CACHE_PREFIX, phone);
    }

    //用户信息Key
    public static String getUserInfoKey(String token) {
        return StringUtils.joinWith(SPLIT_SYMBOL, AUTH_CACHE_PREFIX, USER_CACHE_PREFIX, token);
    }

    //模块权限
    public static String getModulesAuthenticationKey(String userId) {
        return StringUtils.joinWith(SPLIT_SYMBOL, AUTH_CACHE_PREFIX, OWNED_RESOURCES, userId);
    }
}
