/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.RequestTemplate;
import feign.Util;
import feign.form.FormDataProcessor;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormEncodedDataProcessor
implements FormDataProcessor {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";

    @Override
    public void process(Map<String, Object> data, RequestTemplate template) {
        StringBuilder body = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (body.length() > 0) {
                body.append('&');
            }
            body.append(this.createKeyValuePair(entry));
        }
        template.header("Content-Type", CONTENT_TYPE);
        template.body(body.toString());
    }

    @Override
    public String getSupportetContentType() {
        return CONTENT_TYPE;
    }

    private String createKeyValuePair(Map.Entry<String, Object> entry) {
        return URLEncoder.encode(entry.getKey(), Util.UTF_8.name()) + '=' + URLEncoder.encode(entry.getValue().toString(), Util.UTF_8.name());
    }
}

