/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.Util;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RequestTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Collection<String>> queries = new LinkedHashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> headers = new LinkedHashMap<String, Collection<String>>();
    private String method;
    private StringBuilder url = new StringBuilder();
    private transient Charset charset;
    private byte[] body;
    private String bodyTemplate;
    private boolean decodeSlash = true;

    public RequestTemplate() {
    }

    public RequestTemplate(RequestTemplate toCopy) {
        Util.checkNotNull(toCopy, "toCopy", new Object[0]);
        this.method = toCopy.method;
        this.url.append((CharSequence)toCopy.url);
        this.queries.putAll(toCopy.queries);
        this.headers.putAll(toCopy.headers);
        this.charset = toCopy.charset;
        this.body = toCopy.body;
        this.bodyTemplate = toCopy.bodyTemplate;
        this.decodeSlash = toCopy.decodeSlash;
    }

    private static String urlDecode(String arg) {
        try {
            return URLDecoder.decode(arg, Util.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String urlEncode(Object arg) {
        try {
            return URLEncoder.encode(String.valueOf(arg), Util.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isHttpUrl(CharSequence value) {
        return value.length() >= 4 && value.subSequence(0, 3).equals("http".substring(0, 3));
    }

    private static CharSequence removeTrailingSlash(CharSequence charSequence) {
        if (charSequence != null && charSequence.length() > 0 && charSequence.charAt(charSequence.length() - 1) == '/') {
            return charSequence.subSequence(0, charSequence.length() - 1);
        }
        return charSequence;
    }

    public static String expand(String template, Map<String, ?> variables) {
        if (Util.checkNotNull(template, "template", new Object[0]).length() < 3) {
            return template;
        }
        Util.checkNotNull(variables, "variables for %s", template);
        boolean inVar = false;
        StringBuilder var2 = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        block4: for (char c : template.toCharArray()) {
            switch (c) {
                case '{': {
                    if (inVar) {
                        builder.append("{");
                        inVar = false;
                        continue block4;
                    }
                    inVar = true;
                    continue block4;
                }
                case '}': {
                    if (!inVar) {
                        builder.append('}');
                        continue block4;
                    }
                    inVar = false;
                    String key = var2.toString();
                    Object value = variables.get(var2.toString());
                    if (value != null) {
                        builder.append(value);
                    } else {
                        builder.append('{').append(key).append('}');
                    }
                    var2 = new StringBuilder();
                    continue block4;
                }
                default: {
                    if (inVar) {
                        var2.append(c);
                        continue block4;
                    }
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    private static Map<String, Collection<String>> parseAndDecodeQueries(String queryLine) {
        LinkedHashMap<String, Collection<String>> map = new LinkedHashMap<String, Collection<String>>();
        if (Util.emptyToNull(queryLine) == null) {
            return map;
        }
        if (queryLine.indexOf(38) == -1) {
            RequestTemplate.putKV(queryLine, map);
        } else {
            int i;
            char[] chars = queryLine.toCharArray();
            int start = 0;
            for (i = 0; i < chars.length; ++i) {
                if (chars[i] != '&') continue;
                RequestTemplate.putKV(queryLine.substring(start, i), map);
                start = i + 1;
            }
            RequestTemplate.putKV(queryLine.substring(start, i), map);
        }
        return map;
    }

    private static void putKV(String stringToParse, Map<String, Collection<String>> map) {
        String value;
        String key;
        int firstEq = stringToParse.indexOf(61);
        if (firstEq == -1) {
            key = RequestTemplate.urlDecode(stringToParse);
            value = null;
        } else {
            key = RequestTemplate.urlDecode(stringToParse.substring(0, firstEq));
            value = RequestTemplate.urlDecode(stringToParse.substring(firstEq + 1));
        }
        Collection<Object> values = map.containsKey(key) ? map.get(key) : new ArrayList();
        values.add(value);
        map.put(key, values);
    }

    public RequestTemplate resolve(Map<String, ?> unencoded) {
        return this.resolve(unencoded, Collections.<String, Boolean>emptyMap());
    }

    RequestTemplate resolve(Map<String, ?> unencoded, Map<String, Boolean> alreadyEncoded) {
        this.replaceQueryValues(unencoded, alreadyEncoded);
        LinkedHashMap<String, String> encoded = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ?> entry : unencoded.entrySet()) {
            String key = entry.getKey();
            Object objectValue = entry.getValue();
            String encodedValue = this.encodeValueIfNotEncoded(key, objectValue, alreadyEncoded);
            encoded.put(key, encodedValue);
        }
        String resolvedUrl = RequestTemplate.expand(this.url.toString(), encoded).replace("+", "%20");
        if (this.decodeSlash) {
            resolvedUrl = resolvedUrl.replace("%2F", "/");
        }
        this.url = new StringBuilder(resolvedUrl);
        LinkedHashMap resolvedHeaders = new LinkedHashMap();
        for (String field : this.headers.keySet()) {
            ArrayList<String> resolvedValues = new ArrayList<String>();
            for (String value : Util.valuesOrEmpty(this.headers, field)) {
                String resolved = RequestTemplate.expand(value, unencoded);
                resolvedValues.add(resolved);
            }
            resolvedHeaders.put(field, resolvedValues);
        }
        this.headers.clear();
        this.headers.putAll(resolvedHeaders);
        if (this.bodyTemplate != null) {
            this.body(RequestTemplate.urlDecode(RequestTemplate.expand(this.bodyTemplate, encoded)));
        }
        return this;
    }

    private String encodeValueIfNotEncoded(String key, Object objectValue, Map<String, Boolean> alreadyEncoded) {
        String value = String.valueOf(objectValue);
        Boolean isEncoded = alreadyEncoded.get(key);
        if (isEncoded == null || !isEncoded.booleanValue()) {
            value = RequestTemplate.urlEncode(value);
        }
        return value;
    }

    public Request request() {
        LinkedHashMap<String, Collection<String>> safeCopy = new LinkedHashMap<String, Collection<String>>();
        safeCopy.putAll(this.headers);
        return Request.create(this.method, this.url + this.queryLine(), Collections.unmodifiableMap(safeCopy), this.body, this.charset);
    }

    public RequestTemplate method(String method) {
        this.method = Util.checkNotNull(method, "method", new Object[0]);
        Util.checkArgument(method.matches("^[A-Z]+$"), "Invalid HTTP Method: %s", method);
        return this;
    }

    public String method() {
        return this.method;
    }

    public RequestTemplate decodeSlash(boolean decodeSlash) {
        this.decodeSlash = decodeSlash;
        return this;
    }

    public boolean decodeSlash() {
        return this.decodeSlash;
    }

    public RequestTemplate append(CharSequence value) {
        this.url.append(value);
        this.url = this.pullAnyQueriesOutOfUrl(this.url);
        return this;
    }

    public RequestTemplate insert(int pos, CharSequence value) {
        if (RequestTemplate.isHttpUrl(value)) {
            value = RequestTemplate.removeTrailingSlash(value);
            if (this.url.length() > 0 && this.url.charAt(0) != '/') {
                this.url.insert(0, '/');
            }
        }
        this.url.insert(pos, this.pullAnyQueriesOutOfUrl(new StringBuilder(value)));
        return this;
    }

    public String url() {
        return this.url.toString();
    }

    public RequestTemplate query(boolean encoded, String name, String ... values) {
        return this.doQuery(encoded, name, values);
    }

    public RequestTemplate query(boolean encoded, String name, Iterable<String> values) {
        return this.doQuery(encoded, name, values);
    }

    public RequestTemplate query(String name, String ... values) {
        return this.doQuery(false, name, values);
    }

    public RequestTemplate query(String name, Iterable<String> values) {
        return this.doQuery(false, name, values);
    }

    private RequestTemplate doQuery(boolean encoded, String name, String ... values) {
        Util.checkNotNull(name, "name", new Object[0]);
        String paramName = encoded ? name : RequestTemplate.encodeIfNotVariable(name);
        this.queries.remove(paramName);
        if (values != null && values.length > 0 && values[0] != null) {
            ArrayList<String> paramValues = new ArrayList<String>();
            for (String value : values) {
                paramValues.add(encoded ? value : RequestTemplate.encodeIfNotVariable(value));
            }
            this.queries.put(paramName, paramValues);
        }
        return this;
    }

    private RequestTemplate doQuery(boolean encoded, String name, Iterable<String> values) {
        if (values != null) {
            return this.doQuery(encoded, name, Util.toArray(values, String.class));
        }
        return this.doQuery(encoded, name, (String[])null);
    }

    private static String encodeIfNotVariable(String in) {
        if (in == null || in.indexOf(123) == 0) {
            return in;
        }
        return RequestTemplate.urlEncode(in);
    }

    public RequestTemplate queries(Map<String, Collection<String>> queries) {
        if (queries == null || queries.isEmpty()) {
            this.queries.clear();
        } else {
            for (Map.Entry<String, Collection<String>> entry : queries.entrySet()) {
                this.query(entry.getKey(), Util.toArray((Iterable)entry.getValue(), String.class));
            }
        }
        return this;
    }

    public Map<String, Collection<String>> queries() {
        LinkedHashMap decoded = new LinkedHashMap();
        for (String field : this.queries.keySet()) {
            ArrayList<String> decodedValues = new ArrayList<String>();
            for (String value : Util.valuesOrEmpty(this.queries, field)) {
                if (value != null) {
                    decodedValues.add(RequestTemplate.urlDecode(value));
                    continue;
                }
                decodedValues.add(null);
            }
            decoded.put(RequestTemplate.urlDecode(field), decodedValues);
        }
        return Collections.unmodifiableMap(decoded);
    }

    public RequestTemplate header(String name, String ... values) {
        Util.checkNotNull(name, "header name", new Object[0]);
        if (values == null || values.length == 1 && values[0] == null) {
            this.headers.remove(name);
        } else {
            ArrayList<String> headers = new ArrayList<String>();
            headers.addAll(Arrays.asList(values));
            this.headers.put(name, headers);
        }
        return this;
    }

    public RequestTemplate header(String name, Iterable<String> values) {
        if (values != null) {
            return this.header(name, Util.toArray(values, String.class));
        }
        return this.header(name, (String[])null);
    }

    public RequestTemplate headers(Map<String, Collection<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            this.headers.clear();
        } else {
            this.headers.putAll(headers);
        }
        return this;
    }

    public Map<String, Collection<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public RequestTemplate body(byte[] bodyData, Charset charset) {
        this.bodyTemplate = null;
        this.charset = charset;
        this.body = bodyData;
        int bodyLength = bodyData != null ? bodyData.length : 0;
        this.header("Content-Length", String.valueOf(bodyLength));
        return this;
    }

    public RequestTemplate body(String bodyText) {
        byte[] bodyData = bodyText != null ? bodyText.getBytes(Util.UTF_8) : null;
        return this.body(bodyData, Util.UTF_8);
    }

    public Charset charset() {
        return this.charset;
    }

    public byte[] body() {
        return this.body;
    }

    public RequestTemplate bodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
        this.charset = null;
        this.body = null;
        return this;
    }

    public String bodyTemplate() {
        return this.bodyTemplate;
    }

    private StringBuilder pullAnyQueriesOutOfUrl(StringBuilder url) {
        int queryIndex = url.indexOf("?");
        if (queryIndex != -1) {
            String queryLine = url.substring(queryIndex + 1);
            Map<String, Collection<String>> firstQueries = RequestTemplate.parseAndDecodeQueries(queryLine);
            if (!this.queries.isEmpty()) {
                firstQueries.putAll(this.queries);
                this.queries.clear();
            }
            for (String key : firstQueries.keySet()) {
                Collection<String> values = firstQueries.get(key);
                if (this.allValuesAreNull(values)) {
                    this.queries.put(RequestTemplate.urlEncode(key), values);
                    continue;
                }
                this.query(key, values);
            }
            return new StringBuilder(url.substring(0, queryIndex));
        }
        return url;
    }

    private boolean allValuesAreNull(Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return true;
        }
        for (String val2 : values) {
            if (val2 == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.request().toString();
    }

    public void replaceQueryValues(Map<String, ?> unencoded) {
        this.replaceQueryValues(unencoded, Collections.<String, Boolean>emptyMap());
    }

    void replaceQueryValues(Map<String, ?> unencoded, Map<String, Boolean> alreadyEncoded) {
        Iterator<Map.Entry<String, Collection<String>>> iterator = this.queries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Collection<String>> entry = iterator.next();
            if (entry.getValue() == null) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (String value : entry.getValue()) {
                if (value.indexOf(123) == 0 && value.indexOf(125) == value.length() - 1) {
                    Object variableValue = unencoded.get(value.substring(1, value.length() - 1));
                    if (variableValue == null) continue;
                    if (variableValue instanceof Iterable) {
                        for (Object val2 : (Iterable)Iterable.class.cast(variableValue)) {
                            String encodedValue = this.encodeValueIfNotEncoded(entry.getKey(), val2, alreadyEncoded);
                            values.add(encodedValue);
                        }
                        continue;
                    }
                    String encodedValue = this.encodeValueIfNotEncoded(entry.getKey(), variableValue, alreadyEncoded);
                    values.add(encodedValue);
                    continue;
                }
                values.add(value);
            }
            if (values.isEmpty()) {
                iterator.remove();
                continue;
            }
            entry.setValue(values);
        }
    }

    public String queryLine() {
        if (this.queries.isEmpty()) {
            return "";
        }
        StringBuilder queryBuilder = new StringBuilder();
        for (String field : this.queries.keySet()) {
            for (String value : Util.valuesOrEmpty(this.queries, field)) {
                queryBuilder.append('&');
                queryBuilder.append(field);
                if (value == null) continue;
                queryBuilder.append('=');
                if (value.isEmpty()) continue;
                queryBuilder.append(value);
            }
        }
        queryBuilder.deleteCharAt(0);
        return queryBuilder.insert(0, '?').toString();
    }

    static interface Factory {
        public RequestTemplate create(Object[] var1);
    }
}

