/*
 * Decompiled with CFR 0.152.
 */
package com.uniubi.sdk.auth.authToken;

import com.uniubi.sdk.auth.authToken.AppAuthParam;
import com.uniubi.sdk.auth.authToken.FetchTokenRunnable;
import com.uniubi.sdk.auth.authToken.SdkException;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TokenFetcher
implements AutoCloseable {
    private static volatile RuntimeException exceptionOnRun;
    private static volatile boolean init;
    private static ScheduledExecutorService scheduledExecutorService;
    private static FetchTokenRunnable fetchTokenRunnable;
    private static AppAuthParam appAuthParam;

    public static String getToken() {
        TokenFetcher.fastFailIfNotInitBefore();
        while (fetchTokenRunnable.getToken() == null) {
            if (exceptionOnRun == null) continue;
            throw exceptionOnRun;
        }
        return fetchTokenRunnable.getToken();
    }

    public static String manualGetToken() {
        return fetchTokenRunnable.executeFetchTokenFromRemote();
    }

    public static void cleanToken() {
        exceptionOnRun = null;
        fetchTokenRunnable.cleanTokenInner();
    }

    private static void fastFailIfNotInitBefore() {
        if (!init) {
            throw new SdkException("WO_EXP-1000", "invoke init(AppAuthParam appAuthParam) first");
        }
    }

    public static void init(AppAuthParam appAuthParam) {
        TokenFetcher.appAuthParam = appAuthParam;
        fetchTokenRunnable = new FetchTokenRunnable(appAuthParam);
        scheduledExecutorService.scheduleAtFixedRate(fetchTokenRunnable, 0L, 18L, TimeUnit.HOURS);
        init = true;
    }

    public static void shutdown() {
        scheduledExecutorService.shutdown();
    }

    public static void shutdownNow() {
        scheduledExecutorService.shutdownNow();
    }

    public static boolean isShutDown() {
        return scheduledExecutorService.isTerminated();
    }

    public static boolean isInit() {
        return init;
    }

    public static void setExceptionOnRun(RuntimeException exceptionOnRun) {
        TokenFetcher.exceptionOnRun = exceptionOnRun;
    }

    public static AppAuthParam getAppAuthParam() {
        TokenFetcher.fastFailIfNotInitBefore();
        return appAuthParam;
    }

    @Override
    public void close() throws Exception {
        TokenFetcher.shutdown();
    }

    static {
        init = false;
        scheduledExecutorService = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("Scheduled-thread-" + new Date().getTime());
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        new RuntimeException("Thread [" + t.getName() + "]: the uncaught exception occurs", e).printStackTrace();
                    }
                });
                return thread;
            }
        });
    }
}

