/*
 * Decompiled with CFR 0.152.
 */
package com.uniubi.sdk.auth.authToken;

import com.uniubi.sdk.ApiClient;
import com.uniubi.sdk.api.TokenControllerApi;
import com.uniubi.sdk.auth.TokenAuth;
import com.uniubi.sdk.auth.authToken.AppAuthParam;
import com.uniubi.sdk.auth.authToken.FetchTokenStrategy;
import com.uniubi.sdk.auth.authToken.SdkException;
import com.uniubi.sdk.auth.authToken.TokenFetcher;
import com.uniubi.sdk.model.Resultstring;

public class RemoteFetchTokenStrategy
implements FetchTokenStrategy {
    private final String sign;
    private final String timestamp;
    private final AppAuthParam appAuthParam;
    private TokenControllerApi tokenApi;

    public RemoteFetchTokenStrategy(AppAuthParam appAuthParam, String timestamp, String sign) {
        this.appAuthParam = appAuthParam;
        this.timestamp = timestamp;
        this.sign = sign;
    }

    @Override
    public String fetch() {
        ApiClient apiClient = new ApiClient();
        apiClient.addAuthorization("authToken", new TokenAuth());
        apiClient.setAuthApiKey(this.appAuthParam.getAppKey(), String.valueOf(this.timestamp), this.sign);
        this.tokenApi = apiClient.buildClient(TokenControllerApi.class);
        Resultstring result = this.tokenApi.authUsingGET(this.appAuthParam.getAppId());
        if (result.getResult() == 0) {
            TokenFetcher.setExceptionOnRun(new SdkException(result.getCode(), result.getMsg()));
        }
        return result.getData();
    }
}

