/*
 * Decompiled with CFR 0.152.
 */
package com.uniubi.sdk.auth.authToken;

import com.uniubi.sdk.MD5Util;
import com.uniubi.sdk.auth.authToken.AppAuthParam;
import com.uniubi.sdk.auth.authToken.FetchTokenStrategy;
import com.uniubi.sdk.auth.authToken.RemoteFetchTokenStrategy;

class FetchTokenRunnable
implements Runnable {
    private volatile String token;
    private AppAuthParam appAuthParam;
    private FetchTokenStrategy fetchTokenStrategy;

    public FetchTokenRunnable(AppAuthParam appAuthParam) {
        this.appAuthParam = appAuthParam;
    }

    @Override
    public void run() {
        this.token = this.fetchTokenFromRemote();
    }

    private String fetchTokenFromRemote() {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign4Auth = MD5Util.encryption(this.appAuthParam.getAppKey() + timestamp + this.appAuthParam.getAppSecret());
        this.fetchTokenStrategy = new RemoteFetchTokenStrategy(this.appAuthParam, timestamp, sign4Auth);
        return this.fetchTokenStrategy.fetch();
    }

    String getToken() {
        return this.token;
    }

    void cleanTokenInner() {
        this.token = null;
    }

    public String executeFetchTokenFromRemote() {
        this.token = this.fetchTokenFromRemote();
        return this.token;
    }
}

