/*
 * Decompiled with CFR 0.152.
 */
package com.uniubi.sdk.api;

import com.uniubi.sdk.ApiClient;
import com.uniubi.sdk.EncodingUtils;
import com.uniubi.sdk.model.CommonDeviceSettingInput;
import com.uniubi.sdk.model.CustomDeviceMessageInput;
import com.uniubi.sdk.model.DeviceBatchBindInput;
import com.uniubi.sdk.model.DeviceCreateInput;
import com.uniubi.sdk.model.DeviceInteractiveCreateInput;
import com.uniubi.sdk.model.DeviceRegisterModeInput;
import com.uniubi.sdk.model.DeviceSettingInput;
import com.uniubi.sdk.model.DeviceUpdateInput;
import com.uniubi.sdk.model.EstablishDeviceSessionInput;
import com.uniubi.sdk.model.PersonGuidInput;
import com.uniubi.sdk.model.Result;
import com.uniubi.sdk.model.ResultCommonDeviceSettingOutput;
import com.uniubi.sdk.model.ResultDeviceOutput;
import com.uniubi.sdk.model.ResultDeviceRegisterModeOutput;
import com.uniubi.sdk.model.ResultDeviceSettingOutput;
import com.uniubi.sdk.model.ResultPageResultBeanAuthOutput;
import com.uniubi.sdk.model.ResultPageResultBeanDeviceOnlineStateOutput;
import com.uniubi.sdk.model.ResultPageResultBeanDeviceOutput;
import com.uniubi.sdk.model.ResultPageResultBeanDevicePackageOutput;
import com.uniubi.sdk.model.ResultPageResultBeanPersonOutput;
import com.uniubi.sdk.model.SendSignatureInput;
import com.uniubi.sdk.model.UpgradeDeviceInput;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface DeviceControllerApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/person/{personGuid}/type/{type}")
    @Headers(value={"Accept: */*"})
    public Result bindPersonPersonsetUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="personGuid") String var3, @Param(value="type") String var4);

    @RequestLine(value="PUT /v1/{appId}/device/batchBind")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result batchBindUsingPUT(DeviceBatchBindInput var1, @Param(value="appId") String var2);

    @RequestLine(value="POST /v1/{appId}/device/{deviceKey}/recType/{recType}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public ResultDeviceOutput createDeviceUsingPOST(DeviceCreateInput var1, @Param(value="appId") String var2, @Param(value="deviceKey") String var3, @Param(value="recType") Byte var4);

    @RequestLine(value="POST /v1/{appId}/device/{deviceKey}/registerMode")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public ResultDeviceRegisterModeOutput createRegisterModeUsingPOST(DeviceRegisterModeInput var1, @Param(value="appId") String var2, @Param(value="deviceKey") String var3);

    @RequestLine(value="DELETE /v1/{appId}/device/{deviceKey}?source={source}")
    @Headers(value={"Accept: */*"})
    public Result deleteDeviceUsingDELETE(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="DELETE /v1/{appId}/device/{deviceKey}")
    @Headers(value={"Accept: */*"})
    public Result deleteDeviceUsingDELETE(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="DELETE /v1/{appId}/device/{deviceKey}/registerMode/{taskGuid}")
    @Headers(value={"Accept: */*"})
    public Result deleteRegisterModeUsingDELETE(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="taskGuid") String var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/disable")
    @Headers(value={"Accept: */*"})
    public Result disableDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/enable")
    @Headers(value={"Accept: */*"})
    public Result enableDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="GET /v1/device/devicePackage?index={index}&length={length}&type={type}&hardwareVersion={hardwareVersion}&platform={platform}&source={source}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDevicePackageOutput findDevicePackageUsingGET(@Param(value="index") Integer var1, @Param(value="length") Integer var2, @Param(value="type") Byte var3, @Param(value="hardwareVersion") Byte var4, @Param(value="platform") Byte var5, @Param(value="source") Integer var6);

    @RequestLine(value="GET /v1/device/devicePackage?index={index}&length={length}&type={type}&hardwareVersion={hardwareVersion}&platform={platform}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDevicePackageOutput findDevicePackageUsingGET(@Param(value="index") Integer var1, @Param(value="length") Integer var2, @Param(value="type") Byte var3, @Param(value="hardwareVersion") Byte var4, @Param(value="platform") Byte var5);

    @RequestLine(value="GET /v1/device/devicePackage?index={index}&length={length}&type={type}&hardwareVersion={hardwareVersion}&platform={platform}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDevicePackageOutput findDevicePackageUsingGET(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/{appId}/person/authorization?index={index}&length={length}&personGuid={personGuid}&deviceType={deviceType}&type={type}&personName={personName}&deviceName={deviceName}&deviceKey={deviceKey}&startTime={startTime}&endTime={endTime}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanPersonOutput findPersonsAuthorizationUsingGET(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="index") Integer var3, @Param(value="length") Integer var4, @Param(value="personName") String var5, @Param(value="deviceName") String var6, @Param(value="personGuid") String var7, @Param(value="deviceType") Byte var8, @Param(value="type") Byte var9, @Param(value="personsetGuid") String var10, @Param(value="startTime") Date var11, @Param(value="endTime") Date var12);

    @RequestLine(value="GET /v1/{appId}/person/authorization?index={index}&length={length}&personGuid={personGuid}&deviceType={deviceType}&type={type}&personName={personName}&deviceName={deviceName}&deviceKey={deviceKey}&startTime={startTime}&endTime={endTime}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanAuthOutput findPersonsAuthorizationUsingGET(@Param(value="appId") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/{appId}/device/{deviceKey}/setting?source={source}")
    @Headers(value={"Accept: */*"})
    public ResultCommonDeviceSettingOutput getCommonDeviceSettingUsingGET(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="GET /v1/{appId}/device/{deviceKey}/setting")
    @Headers(value={"Accept: */*"})
    public ResultDeviceSettingOutput getDeviceSettingUsingGET(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="GET /v1/{appId}/device/{deviceKey}?source={source}")
    @Headers(value={"Accept: */*"})
    public ResultDeviceOutput getDeviceUsingGET(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="GET /v1/{appId}/device/{deviceKey}")
    @Headers(value={"Accept: */*"})
    public ResultDeviceOutput getDeviceUsingGET(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="GET /v1/{appId}/device/{deviceKey}/registerMode/{taskGuid}")
    @Headers(value={"Accept: */*"})
    public ResultDeviceRegisterModeOutput getRegisterModeUsingGET(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="taskGuid") String var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/reset?source={source}")
    @Headers(value={"Accept: */*"})
    public Result resetDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/reset")
    @Headers(value={"Accept: */*"})
    public Result resetDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/restore?source={source}")
    @Headers(value={"Accept: */*"})
    public Result restoreDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/calibration?source={source}")
    @Headers(value={"Accept: */*"})
    public Result calibrationDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="DELETE /v1/{appId}/device/{deviceKey}/person/type/{type}")
    @Headers(value={"Accept: */*"})
    public Result resetPersonsetUsingDELETE(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="type") String var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/restart?source={source}")
    @Headers(value={"Accept: */*"})
    public Result restartDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/restart")
    @Headers(value={"Accept: */*"})
    public Result restartDeviceUsingPUT(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="GET /v1/{appId}/device?index={index}&length={length}&deviceKey={deviceKey}&name={name}&tag={tag}&type={type}&versionNo={versionNo}&recType={recType}&state={state}&startTime={startTime}&endTime={endTime}&source={source}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDeviceOutput searchDeviceUsingGET(@Param(value="appId") String var1, @Param(value="index") Integer var2, @Param(value="length") Integer var3, @Param(value="deviceKey") String var4, @Param(value="name") String var5, @Param(value="tag") String var6, @Param(value="type") Byte var7, @Param(value="versionNo") String var8, @Param(value="recType") Byte var9, @Param(value="state") Byte var10, @Param(value="startTime") Date var11, @Param(value="endTime") Date var12, @Param(value="source") Integer var13);

    @RequestLine(value="GET /v1/{appId}/device?index={index}&length={length}&deviceKey={deviceKey}&name={name}&tag={tag}&type={type}&versionNo={versionNo}&recType={recType}&state={state}&startTime={startTime}&endTime={endTime}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDeviceOutput searchDeviceUsingGET(@Param(value="appId") String var1, @Param(value="index") Integer var2, @Param(value="length") Integer var3, @Param(value="deviceKey") String var4, @Param(value="name") String var5, @Param(value="tag") String var6, @Param(value="type") Byte var7, @Param(value="versionNo") String var8, @Param(value="recType") Byte var9, @Param(value="state") Byte var10, @Param(value="startTime") Date var11, @Param(value="endTime") Date var12);

    @RequestLine(value="GET /v1/{appId}/device?index={index}&length={length}&deviceKey={deviceKey}&name={name}&tag={tag}&type={type}&versionNo={versionNo}&recType={recType}&state={state}&startTime={startTime}&endTime={endTime}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDeviceOutput searchDeviceUsingGET(@Param(value="appId") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/{appId}/device/onlineState?deviceKeys={deviceKeys}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDeviceOnlineStateOutput searchDeviceOnlineStateUsingGET(@Param(value="appId") String var1, @Param(value="deviceKeys") String var2);

    @RequestLine(value="GET /v1/{appId}/device/onlineState?deviceKeys={deviceKeys}")
    @Headers(value={"Accept: */*"})
    public ResultPageResultBeanDeviceOnlineStateOutput searchDeviceOnlineStateUsingGET(@Param(value="appId") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/{appId}/device/{deviceKey}/person/{personGuid}/type/{type}")
    @Headers(value={"Accept: */*"})
    public Result unbindPersonPersonsetUsingDELETE(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="personGuid") String var3, @Param(value="type") String var4);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/setting")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result updateCommonDeviceSettingUsingPUT(CommonDeviceSettingInput var1, @Param(value="appId") String var2, @Param(value="deviceKey") String var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}/setting")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result updateDeviceSettingUsingPUT(DeviceSettingInput var1, @Param(value="appId") String var2, @Param(value="deviceKey") String var3);

    @RequestLine(value="PUT /v1/{appId}/device/{deviceKey}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result updateDeviceUsingPUT(DeviceUpdateInput var1, @Param(value="appId") String var2, @Param(value="deviceKey") String var3);

    @RequestLine(value="PUT /v1/{appId}/device/upgrade?source={source}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result upgradeDeviceUsingPUT(UpgradeDeviceInput var1, @Param(value="appId") String var2, @Param(value="source") Integer var3);

    @RequestLine(value="PUT /v1/{appId}/device/upgrade")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result upgradeDeviceUsingPUT(UpgradeDeviceInput var1, @Param(value="appId") String var2);

    @RequestLine(value="POST /v1/{appId}/device/{deviceKey}/interactive")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result createDeviceInteractiveUsingPOST(@Param(value="appId") String var1, DeviceInteractiveCreateInput var2, @Param(value="deviceKey") String var3);

    @RequestLine(value="PUT /v1/{appId}/device/{srcDeviceKey}/copy/to/{destDeviceKey}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result copyDeviceAuthDataUsingPUT(@Param(value="appId") String var1, @Param(value="srcDeviceKey") String var2, @Param(value="destDeviceKey") String var3);

    @RequestLine(value="POST /v1/{appId}/device/{deviceKey}/person/type/{type}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result bathUnbindPersonPersonsetUsingPOST(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="type") String var3, PersonGuidInput var4);

    @RequestLine(value="PUT /v1/{appId}/device/custom")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result customDeviceMessagePUT(@Param(value="appId") String var1, CustomDeviceMessageInput var2);

    @RequestLine(value="PUT /v1/{appId}/device/signature")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result sendSignaturePUT(@Param(value="appId") String var1, SendSignatureInput var2);

    @RequestLine(value="PUT /v1/{appId}/device/establish/session")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result establishDeviceSessionUsingPUT(@Param(value="appId") String var1, EstablishDeviceSessionInput var2);

    @RequestLine(value="POST /v1/{appId}/device/openys/{deviceKey}/validateCode/{validateCode}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result<String> createYsDeviceUsingPOST(@Param(value="appId") String var1, @Param(value="deviceKey") String var2, @Param(value="validateCode") String var3);

    @RequestLine(value="DELETE /v1/{appId}/device/openys/{deviceKey}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result<String> delYsDeviceUsingDELETE(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="POST /v1/{appId}/device/openys/{deviceKey}/playInfo")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result<String> getYsDevicePlayInfo(Map<String, String> var1, @Param(value="appId") String var2, @Param(value="deviceKey") String var3);

    @RequestLine(value="POST /v1/{appId}/device/openys/{deviceKey}/camera/list")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result<String> getYsDeviceCameraList(@Param(value="appId") String var1, @Param(value="deviceKey") String var2);

    @RequestLine(value="POST /v1/{appId}/device/openys/getToken")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public Result<String> getYsToken(@Param(value="appId") String var1);

    public static class SearchDeviceOnlineStateUsingGETQueryParams
    extends HashMap<String, Object> {
        public SearchDeviceOnlineStateUsingGETQueryParams deviceKeys(String value) {
            this.put("deviceKeys", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchDeviceUsingGETQueryParams
    extends HashMap<String, Object> {
        public SearchDeviceUsingGETQueryParams index(Integer value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams length(Integer value) {
            this.put("length", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams deviceKey(String value) {
            this.put("deviceKey", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams tag(String value) {
            this.put("tag", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams type(Byte value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams versionNo(String value) {
            this.put("versionNo", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams recType(Byte value) {
            this.put("recType", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams state(Byte value) {
            this.put("state", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams startTime(Date value) {
            this.put("startTime", EncodingUtils.encode(value));
            return this;
        }

        public SearchDeviceUsingGETQueryParams endTime(Date value) {
            this.put("endTime", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class FindDevicePackageUsingGETQueryParams
    extends HashMap<String, Object> {
        public FindDevicePackageUsingGETQueryParams index(Integer value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public FindDevicePackageUsingGETQueryParams length(Integer value) {
            this.put("length", EncodingUtils.encode(value));
            return this;
        }

        public FindDevicePackageUsingGETQueryParams type(Byte value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public FindDevicePackageUsingGETQueryParams hardwareVersion(Byte value) {
            this.put("hardwareVersion", EncodingUtils.encode(value));
            return this;
        }

        public FindDevicePackageUsingGETQueryParams platform(Byte value) {
            this.put("platform", EncodingUtils.encode(value));
            return this;
        }
    }
}

